<?php
require_once("auth.php");
require_once("db_con.php");

header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(['error' => 'No ID provided']);
    exit;
}

$expense_id = $_GET['id'];

$sql = "SELECT * FROM expenses WHERE expense_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $expense_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $expense = $result->fetch_assoc();
    echo json_encode($expense);
} else {
    echo json_encode(['error' => 'Expense not found']);
}
?>