<?php
require_once("auth.php");
require_once("db_con.php");

if(isset($_GET['customer_id'])) {
    $customer_id = $_GET['customer_id']; 
    
    // Get customer info
    $customer_sql = "SELECT * FROM customers WHERE customer_id = ?";
    $stmt = $conn->prepare($customer_sql);
    $stmt->bind_param("s", $customer_id);
    $stmt->execute();
    $customer_result = $stmt->get_result();
    
    if($customer_result->num_rows > 0) {
        $customer = $customer_result->fetch_assoc();
        
        echo "<div class='customer-info'>";
        echo "<h3>ຂໍ້ມູນລູກຄ້າ</h3>";
        echo "<p><strong>ລະຫັດ:</strong> " . $customer['customer_id'] . "</p>";
        echo "<p><strong>ຊື່:</strong> " . $customer['name'] . "</p>";
        echo "<p><strong>ເບີໂທ:</strong> " . $customer['phone'] . "</p>";
        echo "</div>";
        
        // Get order history using order_items table instead of order_details
        $order_sql = "SELECT o.*, COUNT(oi.product_id) as total_items, SUM(oi.total) as total_amount 
                     FROM orders o 
                     LEFT JOIN order_items oi ON o.order_id = oi.order_id 
                     WHERE o.customer_id = ? 
                     GROUP BY o.order_id 
                     ORDER BY o.created_at DESC";
        
        $stmt = $conn->prepare($order_sql);
        $stmt->bind_param("s", $customer_id);
        $stmt->execute();
        $order_result = $stmt->get_result();
        
        if($order_result->num_rows > 0) {
            echo "<h3>ປະຫວັດການສັ່ງຊື້</h3>";
            echo "<table class='history-table'>";
            echo "<thead><tr><th>ລະຫັດໃບບິນ</th><th>ວັນທີ</th><th>ຈຳນວນສິນຄ້າ</th><th>ຍອດລວມ</th><th>ລາຍລະອຽດ</th></tr></thead>";
            echo "<tbody>";
            
            while($row = $order_result->fetch_assoc()) {
                $date_from = '2020-01-01'; // หรือวันที่เริ่มต้นที่เหมาะสม
                $date_to = date('Y-m-d');  // วันนี้
                
                echo "<tr>";
                echo "<td>" . $row['order_id'] . "</td>";
                echo "<td>" . date('d/m/Y', strtotime($row['created_at'])) . "</td>";
                echo "<td>" . $row['total_items'] . " ລາຍການ</td>";
                echo "<td>₭" . number_format($row['total_amount'], 0) . "</td>";
                echo "<td><button onclick=\"window.location.href='invoice_history?order_id=" . $row['order_id'] . "&customer_id=" . $customer_id . "&date_from=" . $date_from . "&date_to=" . $date_to . "'\" class=\"btn-view-details\"><i class=\"fas fa-eye\"></i> ເບິ່ງລາຍລະອຽດ</button></td>";
                echo "</tr>";
            }
            
            echo "</tbody></table>";
        } else {
            echo "<p class='no-history'>ລູກຄ້ານີ້ຍັງບໍ່ມີປະຫວັດການສັ່ງຊື້</p>";
        }
    } else {
        echo "<p class='error'>ບໍ່ພົບຂໍ້ມູນລູກຄ້າ</p>";
    }
} else {
    echo "<p class='error'>ບໍ່ພົບຂໍ້ມູນລູກຄ້າ</p>";
}
?>






