<?php
require_once("auth.php");
require_once("db_con.php");

// Get days parameter from request (default to 30 days)
$days = isset($_GET['days']) ? intval($_GET['days']) : 30;

// SQL query to get best selling products
$sql = "SELECT 
            p.product_id,
            p.pro_id,
            p.product_name,
            p.product_image,
            p.selling_price,
            pc.category_name,
            SUM(oi.quantity) as quantity_sold,
            SUM(oi.quantity * oi.price) as total_sales
        FROM 
            order_items oi
        JOIN 
            products p ON oi.product_id = p.product_id
        LEFT JOIN 
            product_category pc ON p.category_id = pc.category_id
        JOIN 
            orders o ON oi.order_id = o.order_id";

// Add date filter if days parameter is not 'all'
if ($days !== 'all' && $days > 0) {
    $sql .= " WHERE o.order_date >= DATE_SUB(CURRENT_DATE(), INTERVAL ? DAY)";
}

// Group by product and order by quantity sold descending
$sql .= " GROUP BY p.product_id
          ORDER BY quantity_sold DESC
          LIMIT 50";

$stmt = $conn->prepare($sql);

// Bind parameters if using date filter
if ($days !== 'all' && $days > 0) {
    $stmt->bind_param("i", $days);
}

$stmt->execute();
$result = $stmt->get_result();

$products = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $products[] = $row;
    }
}

// Return data as JSON
header('Content-Type: application/json');
echo json_encode($products);

$stmt->close();
$conn->close();
?>