<?php
// Turn off all error reporting to prevent HTML output
error_reporting(0);
ini_set('display_errors', 0);
ini_set('log_errors', 0); 

require_once("auth.php");
require_once("db_con.php");

// Set content type first and clean any output
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-cache, must-revalidate');

// Clean any output that might have been generated
while (ob_get_level()) {
    ob_end_clean();
}

// Start output buffering to catch any stray output
ob_start();

// Input validation
$order_id = isset($_GET['order_id']) ? trim($_GET['order_id']) : '';
$operation_type = isset($_GET['operation_type']) ? trim($_GET['operation_type']) : '';
$operation_time = isset($_GET['operation_time']) ? trim($_GET['operation_time']) : '';

if (empty($order_id) || empty($operation_type) || empty($operation_time)) {
    ob_clean();
    echo json_encode([
        'success' => false, 
        'message' => 'ຂໍ້ມູນບໍ່ຄົບຖ້ວນ: ກະລຸນາໃສ່ Order ID, Operation Type ແລະ Operation Time'
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// Validate operation_type
$valid_operations = ['INSERT', 'UPDATE', 'DELETE'];
if (!in_array($operation_type, $valid_operations)) {
    ob_clean();
    echo json_encode([
        'success' => false, 
        'message' => 'ປະເພດການດຳເນີນການບໍ່ຖືກຕ້ອງ'
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

try {
    // ค้นหาข้อมูลจาก orders_history - เรียงตาม audit_id จากมากไปน้อย เพื่อให้ได้ record ล่าสุด
    $sql_orders = "SELECT * FROM orders_history 
                   WHERE (old_order_id = ? OR new_order_id = ?) AND operation_type = ? AND operation_time = ?
                   ORDER BY audit_id DESC LIMIT 1";
    
    $stmt_orders = $conn->prepare($sql_orders);
    $stmt_orders->bind_param("ssss", $order_id, $order_id, $operation_type, $operation_time);
    $stmt_orders->execute();
    $result_orders = $stmt_orders->get_result();
    
    // ค้นหาข้อมูลจาก order_items_history - เรียงตาม audit_id จากมากไปน้อย
    $sql_items = "SELECT * FROM order_items_history 
                  WHERE (old_order_id = ? OR new_order_id = ?) AND operation_type = ? AND operation_time = ?
                  ORDER BY audit_id DESC";
    
    $stmt_items = $conn->prepare($sql_items);
    $stmt_items->bind_param("ssss", $order_id, $order_id, $operation_type, $operation_time);
    $stmt_items->execute();
    $result_items = $stmt_items->get_result();
    
    $response = [
        'success' => true,
        'order_id' => $order_id,
        'operation_type' => $operation_type,
        'operation_time' => date('d/m/Y H:i:s', strtotime($operation_time)),
        'operation_user' => 'System',
        'table_name' => 'orders', // Static value since we know this is orders data
        'old_data' => null,
        'new_data' => null
    ];
    
    // ประมวลผลข้อมูล orders
    if ($result_orders->num_rows > 0) {
        $order_row = $result_orders->fetch_assoc();
        $response['operation_user'] = $order_row['operation_user'] ?? 'System';
        
        // เพิ่ม debug info เพื่อให้เห็นว่าดึงข้อมูลจาก record ไหน
        $response['debug_info'] = [
            'audit_id' => $order_row['audit_id'],
            'found_records' => $result_orders->num_rows,
            'raw_old_shipping_code' => $order_row['old_shipping_code'],
            'raw_new_shipping_code' => $order_row['new_shipping_code'],
            'raw_old_shipping_company' => $order_row['old_shipping_company'],
            'raw_new_shipping_company' => $order_row['new_shipping_company'],
            'raw_old_store_id' => $order_row['old_store_id'],
            'raw_new_store_id' => $order_row['new_store_id']
        ];
        
        // สร้างข้อมูลเก่าและใหม่
        if ($operation_type == 'UPDATE') {
            $response['old_data'] = [
                'order_date' => $order_row['old_order_date'],
                'sale_type' => $order_row['old_sale_type'],
                'customer_id' => $order_row['old_customer_id'],
                'payment_status' => $order_row['old_payment_status'],
                'payment_method' => $order_row['old_payment_method'],
                'total_amount' => $order_row['old_total_amount'],
                'subtotal' => $order_row['old_subtotal'],
                'discount' => $order_row['old_discount'],
                'deposit_amount' => $order_row['old_deposit_amount'],
                'cash_received' => $order_row['old_cash_received'],
                'cash_change' => $order_row['old_cash_change'],
                'cod_type' => $order_row['old_cod_type'],
                'shipping_company' => $order_row['old_shipping_company'],
                'shipping_branch' => $order_row['old_shipping_branch'],
                'shipping_code' => $order_row['old_shipping_code'],
                'store_id' => $order_row['old_store_id'],
                'printed_shop' => $order_row['old_printed_shop'],
                'printed_online' => $order_row['old_printed_online']
            ];
            
            $response['new_data'] = [
                'order_date' => $order_row['new_order_date'],
                'sale_type' => $order_row['new_sale_type'],
                'customer_id' => $order_row['new_customer_id'],
                'payment_status' => $order_row['new_payment_status'],
                'payment_method' => $order_row['new_payment_method'],
                'total_amount' => $order_row['new_total_amount'],
                'subtotal' => $order_row['new_subtotal'],
                'discount' => $order_row['new_discount'],
                'deposit_amount' => $order_row['new_deposit_amount'],
                'cash_received' => $order_row['new_cash_received'],
                'cash_change' => $order_row['new_cash_change'],
                'cod_type' => $order_row['new_cod_type'],
                'shipping_company' => $order_row['new_shipping_company'],
                'shipping_branch' => $order_row['new_shipping_branch'],
                'shipping_code' => $order_row['new_shipping_code'],
                'store_id' => $order_row['new_store_id'],
                'printed_shop' => $order_row['new_printed_shop'],
                'printed_online' => $order_row['new_printed_online']
            ];
        } elseif ($operation_type == 'INSERT') {
            $response['new_data'] = [
                'order_date' => $order_row['new_order_date'],
                'sale_type' => $order_row['new_sale_type'],
                'customer_id' => $order_row['new_customer_id'],
                'payment_status' => $order_row['new_payment_status'],
                'payment_method' => $order_row['new_payment_method'],
                'total_amount' => $order_row['new_total_amount'],
                'subtotal' => $order_row['new_subtotal'],
                'discount' => $order_row['new_discount'],
                'deposit_amount' => $order_row['new_deposit_amount'],
                'cash_received' => $order_row['new_cash_received'],
                'cash_change' => $order_row['new_cash_change'],
                'cod_type' => $order_row['new_cod_type'],
                'shipping_company' => $order_row['new_shipping_company'],
                'shipping_branch' => $order_row['new_shipping_branch'],
                'shipping_code' => $order_row['new_shipping_code'],
                'store_id' => $order_row['new_store_id'],
                'printed_shop' => $order_row['new_printed_shop'],
                'printed_online' => $order_row['new_printed_online']
            ];
        } else { // DELETE
            $response['old_data'] = [
                'order_date' => $order_row['old_order_date'],
                'sale_type' => $order_row['old_sale_type'],
                'customer_id' => $order_row['old_customer_id'],
                'payment_status' => $order_row['old_payment_status'],
                'payment_method' => $order_row['old_payment_method'],
                'total_amount' => $order_row['old_total_amount'],
                'subtotal' => $order_row['old_subtotal'],
                'discount' => $order_row['old_discount'],
                'deposit_amount' => $order_row['old_deposit_amount'],
                'cash_received' => $order_row['old_cash_received'],
                'cash_change' => $order_row['old_cash_change'],
                'cod_type' => $order_row['old_cod_type'],
                'shipping_company' => $order_row['old_shipping_company'],
                'shipping_branch' => $order_row['old_shipping_branch'],
                'shipping_code' => $order_row['old_shipping_code'],
                'store_id' => $order_row['old_store_id'],
                'printed_shop' => $order_row['old_printed_shop'],
                'printed_online' => $order_row['old_printed_online']
            ];
        }
    }
    
    // ประมวลผลข้อมูล order_items
    if ($result_items->num_rows > 0) {
        $items_data = [];
        while ($item_row = $result_items->fetch_assoc()) {
            // Update table name to include items info
            if ($response['table_name'] == 'orders') {
                $response['table_name'] = 'orders + order_items';
            }
            
            $item_info = [
                'product_id' => '',
                'quantity' => '',
                'price' => ''
            ];
            
            if ($operation_type == 'UPDATE') {
                $item_info['old'] = [
                    'product_id' => $item_row['old_product_id'],
                    'quantity' => $item_row['old_quantity'],
                    'price' => $item_row['old_price']
                ];
                
                $item_info['new'] = [
                    'product_id' => $item_row['new_product_id'],
                    'quantity' => $item_row['new_quantity'],
                    'price' => $item_row['new_price']
                ];
            } elseif ($operation_type == 'INSERT') {
                $item_info = [
                    'product_id' => $item_row['new_product_id'],
                    'quantity' => $item_row['new_quantity'],  
                    'price' => $item_row['new_price']
                ];
            } else { // DELETE
                $item_info = [
                    'product_id' => $item_row['old_product_id'],
                    'quantity' => $item_row['old_quantity'], 
                    'price' => $item_row['old_price']
                ];
            }
            
            $items_data[] = $item_info;
        }
        
        $response['items'] = $items_data;
    }
    
    // Clean any stray output and send JSON
    ob_clean();
    echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    ob_clean();
    echo json_encode([
        'success' => false, 
        'message' => 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage(),
        'error_code' => $e->getCode()
    ], JSON_UNESCAPED_UNICODE);
}

mysqli_close($conn);
ob_end_flush();
?>
