<?php
require_once("db_con.php");

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['edit_store_id']) && isset($_POST['store_name'])) {
    $store_id = $_POST['edit_store_id'];
    $store_name = $_POST['store_name'];
    
    // ตรวจสอบว่าชื่อร้านซ้ำ<|im_start|>ไม่ (ยกเว้นรายการ<|im_start|>่<|im_start|>แก้ไข)
    $check_sql = "SELECT * FROM stores WHERE store_name = ? AND store_id != ?";
    $check_stmt = $conn->prepare($check_sql);
    $check_stmt->bind_param("si", $store_name, $store_id);
    $check_stmt->execute();
    $check_result = $check_stmt->get_result();
    
    if ($check_result->num_rows > 0) {
        header("Location: add_store?status=duplicate");
    } else {
        $sql = "UPDATE stores SET store_name = ? WHERE store_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("si", $store_name, $store_id);
        
        if ($stmt->execute()) {
            header("Location: add_store?status=updated");
        } else {
            header("Location: add_store?status=error&message=" . urlencode($stmt->error));
        }
        
        $stmt->close();
    }
    
    $check_stmt->close();
} else {
    header("Location: add_store");
}

$conn->close();
?>