<?php
require_once("auth.php");
require_once("db_con.php");

function formatAmount($amount) {
    $amount = floatval($amount);
    if ($amount == floor($amount)) {
        return number_format($amount, 0);
    } else {
        return number_format($amount, 2);
    }
}

if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "<!DOCTYPE html>
    <html>
    <head>
        <script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <link href='https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap' rel='stylesheet'>
        <style>
            .swal2-popup {
                font-family: 'Noto Sans Lao', sans-serif !important;
            }
            .swal2-title {
                font-family: 'Noto Sans Lao', sans-serif !important;
            }
            .swal2-html-container {
                font-family: 'Noto Sans Lao', sans-serif !important;
            }
            .swal2-confirm {
                font-family: 'Noto Sans Lao', sans-serif !important;
            }
        </style>
    </head>
    <body>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                Swal.fire({
                    title: 'ຂໍ້ຜິດພາດ!',
                    text: 'ບໍ່ພົບລະຫັດໃບສັ່ງຊື້',
                    icon: 'error',
                    confirmButtonText: 'ຕົກລົງ',
                    customClass: {
                        popup: 'swal2-popup',
                        title: 'swal2-title',
                        htmlContainer: 'swal2-html-container',
                        confirmButton: 'swal2-confirm'
                    }
                }).then((result) => {
                    window.location.href='show_Ordering_Report';
                });
            });
        </script>
    </body>
    </html>";
    exit;
}

$order_id = $_GET['id'];
$success_message = '';
$error_message = '';

// ข้อมูลใบส่งซื้อ
$sql = "SELECT po.* FROM purchase_orders po WHERE po.id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $order_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo "<!DOCTYPE html>
    <html>
    <head>
        <script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <link href='https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap' rel='stylesheet'>
        <style>
            .swal2-popup {
                font-family: 'Noto Sans Lao', sans-serif !important;
            }
            .swal2-title {
                font-family: 'Noto Sans Lao', sans-serif !important;
            }
            .swal2-html-container {
                font-family: 'Noto Sans Lao', sans-serif !important;
            }
            .swal2-confirm {
                font-family: 'Noto Sans Lao', sans-serif !important;
            }
        </style>
    </head>
    <body>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                Swal.fire({
                    title: 'ຂໍ້ຜິດພາດ!',
                    text: 'ບໍ່ພົບຂໍ້ມູນໃບສັ່ງຊື້',
                    icon: 'error',
                    confirmButtonText: 'ຕົກລົງ',
                    customClass: {
                        popup: 'swal2-popup',
                        title: 'swal2-title',
                        htmlContainer: 'swal2-html-container',
                        confirmButton: 'swal2-confirm'
                    }
                }).then((result) => {
                    window.location.href='show_Ordering_Report';
                });
            });
        </script>
    </body>
    </html>";
    exit;
}

$order = $result->fetch_assoc();
// ไม่ต้องแปลงค่า store_id เป็น integer
// $order['store_id'] = (int)$order['store_id']; <- ลบบรรทัด: ไม่ต้องแปลงค่า store_id เป็น integer

// ข้อมูลร้านค้า: หมด
$stores_sql = "SELECT * FROM stores ORDER BY store_name";
$stores_result = $conn->query($stores_sql);
$stores = [];
while ($row = $stores_result->fetch_assoc()) {
    // ไม่ต้องแปลงค่า store_id เป็น integer
    // $row['store_id'] = (int)$row['store_id']; <- ลบบรรทัด: ไม่ต้องแปลงค่า store_id เป็น integer
    $stores[] = $row;
}

// ข้อมูลรายการ: ค้าในใบส่งซื้อ
$sql = "SELECT poi.*, p.product_name, p.pro_id 
        FROM purchase_order_items poi
        LEFT JOIN products p ON poi.product_id = p.product_id
        WHERE poi.purchase_order_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $order_id);
$stmt->execute();
$result = $stmt->get_result();

$items = [];
while ($row = $result->fetch_assoc()) {
    $items[] = $row;
}

// ข้อมูลร้านค้า: หมด
$stores_sql = "SELECT * FROM stores ORDER BY store_name";
$stores_result = $conn->query($stores_sql);
$stores = [];
while ($row = $stores_result->fetch_assoc()) {
    $stores[] = $row;
}

// ถ้าส่งฟอร์มแก้ไข
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_order'])) {
    try {
        $conn->begin_transaction();
        
        // ข้อมูลใบส่งซื้อ
        $store_id = $_POST['store_id'];
        $order_date = $_POST['order_date'];
        $supplier_name = $_POST['supplier_name'];
        $supplier_contact = $_POST['supplier_contact'];
        $notes = $_POST['notes'];
        $status = $_POST['status'];
        
        // ปเดตข้อมูลใบส่งซื้อ
        $update_sql = "UPDATE purchase_orders SET 
                      store_id = ?, 
                      order_date = ?, 
                      supplier_name = ?, 
                      supplier_contact = ?, 
                      notes = ?, 
                      status = ? 
                      WHERE id = ?";
        
        $update_stmt = $conn->prepare($update_sql);
        $update_stmt->bind_param("ssssssi", 
            $store_id, 
            $order_date, 
            $supplier_name, 
            $supplier_contact, 
            $notes, 
            $status, 
            $order_id
        );
        
        $update_stmt->execute();
        
        // คำนวณยอดรวมใหม่
        $total_amount = 0;
        foreach ($_POST['item_id'] as $key => $item_id) {
            if (isset($_POST['quantity'][$key]) && isset($_POST['price'][$key])) {
                $quantity = floatval($_POST['quantity'][$key]);
                $price = floatval($_POST['price'][$key]);
                $total = $quantity * $price;
                $total_amount += $total;
                
                // ปเดตรายการ: ค้า
                $update_item_sql = "UPDATE purchase_order_items SET 
                                   quantity = ?, 
                                   price = ?, 
                                   total = ? 
                                   WHERE id = ?";
                
                $update_item_stmt = $conn->prepare($update_item_sql);
                $update_item_stmt->bind_param("dddi", 
                    $quantity, 
                    $price, 
                    $total, 
                    $item_id
                );
                
                $update_item_stmt->execute();
            }
        }
        
        // ปเดตยอดรวมในใบส่งซื้อ
        $update_total_sql = "UPDATE purchase_orders SET total_amount = ? WHERE id = ?";
        $update_total_stmt = $conn->prepare($update_total_sql);
        $update_total_stmt->bind_param("di", $total_amount, $order_id);
        $update_total_stmt->execute();
        
        $conn->commit();
        $success_message = "ອັບເດດໃບສັ່ງຊື້ສຳເລັດແລ້ວ";
        
        // Redirect to show_Ordering_Report after successful update
        echo "<!DOCTYPE html>
        <html>
        <head>
            <script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
            <link href='https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap' rel='stylesheet'>
            <style>
                .swal2-popup {
                    font-family: 'Noto Sans Lao', sans-serif !important;
                }
                .swal2-title {
                    font-family: 'Noto Sans Lao', sans-serif !important;
                }
                .swal2-html-container {
                    font-family: 'Noto Sans Lao', sans-serif !important;
                }
                .swal2-confirm {
                    font-family: 'Noto Sans Lao', sans-serif !important;
                }
            </style>
        </head>
        <body>
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    Swal.fire({
                        title: 'ສຳເລັດ!',
                        text: 'ອັບເດດໃບສັ່ງຊື້ສຳເລັດແລ້ວ',
                        icon: 'success',
                        confirmButtonText: 'ຕົກລົງ',
                        customClass: {
                            popup: 'swal2-popup',
                            title: 'swal2-title',
                            htmlContainer: 'swal2-html-container',
                            confirmButton: 'swal2-confirm'
                        }
                    }).then((result) => {
                        window.location.href='show_Ordering_Report';
                    });
                });
            </script>
        </body>
        </html>";
        exit;
        
        // ข้อมูลใหม่: ปเดต (This code won't execute due to the redirect above)
        $sql = "SELECT po.* FROM purchase_orders po WHERE po.id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $order_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $order = $result->fetch_assoc();
        
        // ข้อมูลรายการ: ค้าใหม่
        $sql = "SELECT poi.*, p.product_name, p.pro_id 
                FROM purchase_order_items poi
                LEFT JOIN products p ON poi.product_id = p.product_id
                WHERE poi.purchase_order_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $order_id);
        $stmt->execute();
        $result = $stmt->get_result();
        
        $items = [];
        while ($row = $result->fetch_assoc()) {
            $items[] = $row;
        }
        
    } catch (Exception $e) {
        $conn->rollback();
        $error_message = "ເກີດຂໍ້ຜິດພາດ: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="lo">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ແກ້ໄຂໃບສັ່ງຊື້ - <?php echo htmlspecialchars($order['order_code']); ?></title>
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/edit_purchase_order.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <link rel="icon" type="image/png" href="/test01/favicon.png">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

</head>
<body>
    <?php include('home.php'); ?>

    <div class="content-area">
        <div class="edit-form">
            <h1><i class="fas fa-edit"></i> ແກ້ໄຂໃບສັ່ງຊື້: <?php echo htmlspecialchars($order['order_code']); ?></h1>
            
            <?php if (!empty($success_message)): ?>
                <div class="alert alert-success">
                    <?php echo $success_message; ?>
                </div>
            <?php endif; ?>
            
            <?php if (!empty($error_message)): ?>
                <div class="alert alert-danger">
                    <?php echo $error_message; ?>
                </div>
            <?php endif; ?>
            
            <form method="POST">
                <div class="form-row">
                    <div class="form-col">
                        <div class="form-group">
                            <label for="order_code">ລະຫັດໃບສັ່ງຊື້</label>
                            <input type="text" id="order_code" value="<?php echo htmlspecialchars($order['order_code']); ?>" readonly>
                        </div>
                    </div>
                    <div class="form-col">
                        <div class="form-group">
                            <label for="order_date">ວັນທີສັ່ງຊື້</label>
                            <input type="date" id="order_date" name="order_date" value="<?php echo $order['order_date']; ?>" required>
                        </div>
                    </div>
                    <div class="form-col">
                        <div class="form-group">
                            <label for="status">ສະຖານະ</label>
                            <select id="status" name="status" class="status-select" required>
                                <option value="pending" <?php echo $order['status'] == 'pending' ? 'selected' : ''; ?> class="status-pending">ລໍຖ້າ</option>
                                <option value="completed" <?php echo $order['status'] == 'completed' ? 'selected' : ''; ?> class="status-completed">ສຳເລັດແລ້ວ</option>
                                <option value="cancelled" <?php echo $order['status'] == 'cancelled' ? 'selected' : ''; ?> class="status-cancelled">ຍົກເລີກ</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-col">
                        <div class="form-group">
                            <label for="store_id">ຮ້ານຄ້າ</label>
                            <select id="store_id" name="store_id" required>
                                <option value="">ເລືອກຮ້ານຄ້າ</option>
                                <?php foreach ($stores as $store): ?>
                                    <?php 
                                    // เພີ້ມການກວດສອບแบบ string ไม่ใช่ integer
                                    $is_selected = ($order['store_id'] === $store['store_id']);
                                    ?>
                                    <option value="<?php echo $store['store_id']; ?>" <?php echo $is_selected ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($store['store_name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-col">
                        <div class="form-group">
                            <label for="supplier_name">ຊື່ຜູ້ສະໜອງ</label>
                            <input type="text" id="supplier_name" name="supplier_name" value="<?php echo htmlspecialchars($order['supplier_name']); ?>" required>
                        </div>
                    </div>
                    <div class="form-col">
                        <div class="form-group">
                            <label for="supplier_contact">ຂໍ້ມູນຕິດຕໍ່ຜູ້ສະໜອງ</label>
                            <input type="text" id="supplier_contact" name="supplier_contact" value="<?php echo htmlspecialchars($order['supplier_contact'] ?? ''); ?>">
                        </div>
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="notes">ໝາຍເຫດ</label>
                    <textarea id="notes" name="notes"><?php echo htmlspecialchars($order['notes'] ?? ''); ?></textarea>
                </div>
                
                <h3>ລາຍການສິນຄ້າ</h3>
                <table>
                    <thead>
                        <tr>
                            <th>ລຳດັບ</th>
                            <th>ລະຫັດສິນຄ້າ</th>
                            <th>ຊື່ສິນຄ້າ</th>
                            <th>ຈຳນວນ</th>
                            <th>ລາຄາຕໍ່ຫນ່ວຍ (ກີບ)</th>
                            <th>ລວມ (ກີບ)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($items) > 0): ?>
                            <?php $i = 1; foreach ($items as $item): ?>
                                <tr>
                                    <td><?php echo $i++; ?></td>
                                    <td><?php echo htmlspecialchars($item['pro_id'] ?? 'N/A'); ?></td>
                                    <td><?php echo htmlspecialchars($item['product_name'] ?? 'N/A'); ?></td>
                                    <td>
                                        <input type="hidden" name="item_id[]" value="<?php echo $item['id']; ?>">
                                        <input type="number" name="quantity[]" value="<?php echo (floor($item['quantity']) == $item['quantity']) ? intval($item['quantity']) : $item['quantity']; ?>" min="1" step="1" required onchange="updateTotal(this)">
                                    </td>
                                    <td>
                                        <input type="number" name="price[]" value="<?php echo (floor($item['price']) == $item['price']) ? intval($item['price']) : $item['price']; ?>" min="0" step="1" required onchange="updateTotal(this)">
                                    </td>
                                    <td class="item-total"><?php echo formatAmount($item['total']); ?> ກີບ</td>
                                </tr>
                            <?php endforeach; ?>
                            <tr class="total-row">
                                <td colspan="5" style="text-align: right;">ຍອດລວມທັງໝົດ:</td>
                                <td id="grand-total"><?php echo formatAmount($order['total_amount']); ?> ກີບ</td>
                            </tr>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" style="text-align: center;">ບໍ່ພົບລາຍການສິນຄ້າ</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
                
                <div class="btn-container">
                    <a href="show_Ordering_Report" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> ກັບຄືນ</a>
                    <button type="submit" name="update_order" class="btn btn-primary"><i class="fas fa-save"></i> ບັນທຶກການແກ້ໄຂ</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function updateTotal(input) {
            const row = input.closest('tr');
            const quantity = parseFloat(row.querySelector('input[name="quantity[]"]').value);
            const price = parseFloat(row.querySelector('input[name="price[]"]').value);
            const total = quantity * price;
            
            if (!isNaN(total)) {
                // แสดงผลแบบไม่ .00 ถ้าเป็นจำนวนเต็ม
                const formattedTotal = total % 1 === 0 ? 
                    total.toLocaleString() : 
                    total.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2});
                row.querySelector('.item-total').textContent = formattedTotal + ' ກີບ';
            }
            
            // ຄຳນວณຍອດລວມທັງໝົດ
            let grandTotal = 0;
            document.querySelectorAll('input[name="quantity[]"]').forEach((quantityInput, index) => {
                const row = quantityInput.closest('tr');
                const quantity = parseFloat(quantityInput.value);
                const price = parseFloat(document.querySelectorAll('input[name="price[]"]')[index].value);
                
                if (!isNaN(quantity) && !isNaN(price)) {
                    grandTotal += quantity * price;
                }
            });
            
            // แสดงผลแบบไม่ .00 ถ้าเป็นจำนวนเต็ม
            const formattedGrandTotal = grandTotal % 1 === 0 ? 
                grandTotal.toLocaleString() : 
                grandTotal.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2});
            document.getElementById('grand-total').textContent = formattedGrandTotal + ' ກີບ';
        }
    </script>
</body>
</html>






