<?php
    require_once("auth.php");
    require_once("db_con.php");

    // รับค่า page จาก POST ก่อน GET
    $page = isset($_POST['page']) ? intval($_POST['page']) : (isset($_GET['page']) ? intval($_GET['page']) : 1);

    // Debug: แสดงค่า $_GET ทั้งหมด (ลบออกหลังแก้เสร็จ)
    // echo "<pre>GET Parameters: " . print_r($_GET, true) . "</pre>";

    if (!isset($_GET['order_id'])) { 
        echo "ບໍ່ພົບລະຫັດໃບບິນ";
        exit;
    }

    $order_id = $_GET['order_id'];
    $alert_message = '';
    $alert_type = '';

    // ข้อมูลใบ
    $sql = "SELECT o.*, c.name as customer_name, c.phone as customer_phone, sc.shipping_name, s.store_name 
            FROM orders o 
            LEFT JOIN customers c ON o.customer_id = c.customer_id COLLATE utf8mb4_general_ci
            LEFT JOIN shipping_company sc ON o.shipping_company = sc.shipping_id COLLATE utf8mb4_general_ci
            LEFT JOIN stores s ON o.store_id = s.store_id COLLATE utf8mb4_general_ci
            WHERE o.order_id = ?";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $order_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        echo "ບໍ່ພົບຂໍ້ມູນໃບບິນ";
        exit;
    }

    $order = $result->fetch_assoc();

    // ดึงข้อมูลสินค้า
    $sql = "SELECT oi.*, p.product_name 
            FROM order_items oi 
            LEFT JOIN products p ON oi.product_id = p.product_id 
            WHERE oi.order_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $order_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $items = [];
    while ($row = $result->fetch_assoc()) {
        $items[] = $row;
    }

    // ดึงข้อมูลบริษัทขนส่ง
    $sql = "SELECT * FROM shipping_company ORDER BY shipping_name";
    $shipping_companies = $conn->query($sql)->fetch_all(MYSQLI_ASSOC);

    // ดึงข้อมูลร้าน
    $sql = "SELECT * FROM stores ORDER BY store_name";
    $all_stores = $conn->query($sql)->fetch_all(MYSQLI_ASSOC);

    // ดึงข้อมูลสินค้า (สำหรับ dropdown) ใช้ selling_price และ quantity
    $products = $conn->query("SELECT product_id, product_name, selling_price, quantity, product_image FROM products")->fetch_all(MYSQLI_ASSOC);

    // --- ส่วนจัดการสินค้า (เพิ่ม/ลบ/แก้ไข) ---
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        try {
            $conn->begin_transaction();

            // ลบสินค้าเก่าตาม delete_ids[]
            if (!empty($_POST['delete_ids']) && is_array($_POST['delete_ids'])) {
                foreach ($_POST['delete_ids'] as $delete_id) {
                    $delete_id = intval($delete_id);
                    // คืน stock ก่อนลบ
                    $res = $conn->query("SELECT product_id, quantity FROM order_items WHERE id = $delete_id AND order_id = '$order_id'");
                    if ($row = $res->fetch_assoc()) {
                        $conn->query("UPDATE products SET quantity = quantity + {$row['quantity']} WHERE product_id = {$row['product_id']}");
                    }
                    $conn->query("DELETE FROM order_items WHERE id = $delete_id AND order_id = '$order_id'");
                }
            }

            // อัปเดตสินค้าเดิม
            if (isset($_POST['item_id']) && is_array($_POST['item_id'])) {
                foreach ($_POST['item_id'] as $i => $item_id) {
                    $item_id = intval($item_id);
                    $price = floatval($_POST['price'][$i]);
                    $quantity = intval($_POST['quantity'][$i]);
                    $total = $price * $quantity;
                    $conn->query("UPDATE order_items SET price=$price, quantity=$quantity, total=$total WHERE id=$item_id AND order_id = '$order_id'");
                }
            }

            // ເພີ່ມສິນຄ້າໃໝ່ (หลายรายการ)
            if (!empty($_POST['new_product_id']) && is_array($_POST['new_product_id'])) {
                foreach ($_POST['new_product_id'] as $i => $product_id) {
                    $product_id = intval($product_id);
                    $price = floatval($_POST['new_price'][$i]);
                    $quantity = intval($_POST['new_quantity'][$i]);
                    if ($product_id && $quantity > 0) {
                        $total = $price * $quantity;
                        $conn->query("INSERT INTO order_items (order_id, product_id, quantity, price, total) VALUES ('$order_id', $product_id, $quantity, $price, $total)");
                        // ตัด stock
                        $conn->query("UPDATE products SET quantity = quantity - $quantity WHERE product_id = $product_id");
                    }
                }
            }

            // อัปเดตยอดรวม + ส่วนลด + เงินมัดจำ
            $res = $conn->query("SELECT SUM(total) as subtotal FROM order_items WHERE order_id = '$order_id'");
            $row = $res->fetch_assoc();
            $subtotal = $row['subtotal'] ?? 0;
            $discount = floatval($_POST['discount'] ?? $order['discount']);
            $depositAmount = floatval($_POST['deposit_amount'] ?? $order['deposit_amount']);
            $total_amount = $subtotal - $discount - $depositAmount;
            $conn->query("UPDATE orders SET subtotal = $subtotal, total_amount = $total_amount, discount = $discount, deposit_amount = $depositAmount WHERE order_id = '$order_id'");

            // --- ส่วนข้อมูลลูกค้า/ใบเสร็จ (เหมือนเดิม) ---
            // 1. ดึง customer_id เดิมของ order นี้
            $sql = "SELECT customer_id FROM orders WHERE order_id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("s", $order_id);
            $stmt->execute();
            $result = $stmt->get_result();
            $order_row = $result->fetch_assoc();
            $customer_id = $order_row['customer_id'];

            // 2. เช็คว่ามี order อื่นใช้ customer_id นี้ไหม
            $sql = "SELECT COUNT(*) as cnt FROM orders WHERE customer_id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("s", $customer_id);
            $stmt->execute();
            $result = $stmt->get_result();
            $count = $result->fetch_assoc();

            if ($count['cnt'] > 1) {
                $new_customer_id = 'CUST' . rand(10000, 99999);
                $sql = "INSERT INTO customers (customer_id, name, phone) VALUES (?, ?, ?)";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("sss", $new_customer_id, $_POST['customer_name'], $_POST['customer_phone']);
                $stmt->execute();
                $sql = "UPDATE orders SET customer_id = ? WHERE order_id = ?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("ss", $new_customer_id, $order_id);
                $stmt->execute();
            } else {
                $sql = "UPDATE customers SET name = ?, phone = ? WHERE customer_id = ?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("sss", $_POST['customer_name'], $_POST['customer_phone'], $customer_id);
                $stmt->execute();
            }

            // อัปเดตข้อมูล order อื่นๆ
            // ตรวจสอบว่ามีการเปลี่ยน payment_status หรือไม่
$old_payment_status = $order['payment_status'];
$new_payment_status = $_POST['payment_status'] ?? $old_payment_status;

if ($new_payment_status !== $old_payment_status) {
    // อัปเดต payment_status และ updated_at
    $sql = "UPDATE orders SET 
        shipping_branch = ?, 
        store_id = ?, 
        shipping_company = ?, 
        payment_status = ?, 
        payment_method = ?, 
        shipping_code = ?, 
        updated_at = CURRENT_TIMESTAMP
        WHERE order_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssssss", 
        $_POST['shipping_branch'], 
        $_POST['store_id'], 
        $_POST['shipping_company'], 
        $new_payment_status, 
        $_POST['payment_method'], 
        $_POST['shipping_code'],
        $order_id
    );
    $stmt->execute();
} else {
    // อัปเดตข้อมูลอื่นๆ โดยไม่เปลี่ยน updated_at
    $sql = "UPDATE orders SET 
        shipping_branch = ?, 
        store_id = ?, 
        shipping_company = ?, 
        payment_status = ?, 
        payment_method = ?, 
        shipping_code = ?
        WHERE order_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssssss", 
        $_POST['shipping_branch'], 
        $_POST['store_id'], 
        $_POST['shipping_company'], 
        $new_payment_status, 
        $_POST['payment_method'], 
        $_POST['shipping_code'],
        $order_id
    );
    $stmt->execute();
}

// คืน stock ถ้าเปลี่ยนเป็น "ຍົກເລີກ" หรือ "cancelled"
if ($new_payment_status === 'ຍົກເລີກ' || strtolower($new_payment_status) === 'cancelled') {
    // ดึงรายการสินค้าใน order นี้
    $res = $conn->query("SELECT product_id, quantity FROM order_items WHERE order_id = '$order_id'");
    while ($row = $res->fetch_assoc()) {
        $conn->query("UPDATE products SET quantity = quantity + {$row['quantity']} WHERE product_id = {$row['product_id']}");
    }
}

            $conn->commit();

            $_SESSION['alert_message'] = 'ອັບເດດຂໍ້ມູນໃບບິນສຳເລັດແລ້ວ';
            $_SESSION['alert_type'] = 'success';
            
            // สร้าง URL redirect พร้อมพารามิเตอร์ครบ
            $redirect_params = [
                'page' => $page,
                'order_id' => $order_id,
                'highlight' => 1
            ];
            
            // เพิ่มพารามิเตอร์ search และ date ถ้ามี
            if (isset($_GET['search']) && !empty($_GET['search'])) {
                $redirect_params['search'] = $_GET['search'];
            }
            if (isset($_GET['date_from']) && !empty($_GET['date_from'])) {
                $redirect_params['date_from'] = $_GET['date_from'];
            }
            if (isset($_GET['date_to']) && !empty($_GET['date_to'])) {
                $redirect_params['date_to'] = $_GET['date_to'];
            }
            if (isset($_GET['customer_id']) && !empty($_GET['customer_id'])) {
                $redirect_params['customer_id'] = $_GET['customer_id'];
            }
            
            $redirect_url = 'invoice_history.php?' . http_build_query($redirect_params);
            header("Location: $redirect_url");
            exit;
        } catch (Exception $e) {
            $conn->rollback();
            $alert_message = 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage();
            $alert_type = 'danger';
        }
    }

    // โหลดข้อมูลใหม่หลังบันทึก
    $sql = "SELECT oi.*, p.product_name 
            FROM order_items oi 
            LEFT JOIN products p ON oi.product_id = p.product_id 
            WHERE oi.order_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $order_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $items = [];
    while ($row = $result->fetch_assoc()) {
        $items[] = $row;
    }

    // โหลด order ใหม่ (หลังบันทึก)
    $sql = "SELECT o.*, c.name as customer_name, c.phone as customer_phone, sc.shipping_name, s.store_name 
            FROM orders o 
            LEFT JOIN customers c ON o.customer_id = c.customer_id COLLATE utf8mb4_general_ci
            LEFT JOIN shipping_company sc ON o.shipping_company = sc.shipping_id COLLATE utf8mb4_general_ci
            LEFT JOIN stores s ON o.store_id = s.store_id COLLATE utf8mb4_general_ci
            WHERE o.order_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $order_id);
    $stmt->execute();
    $order = $stmt->get_result()->fetch_assoc();
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="stylesheet" href="css/home.css">
        <link rel="stylesheet" href="css/invoice_history.css">
        <link rel="stylesheet" href="css/edit_invoice.css">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
        <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
        <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
        <link rel="icon" type="image/png" href="/test01/favicon.png">
        <title>ແກ້ໄຂໃບບິນ - ຮ້ານ Jຕຸກຂາຍເຄື່ອງໃຊ້ໄຟຟ້າ</title>

        <script>
        var productsData = <?php
            $productsArr = [];
            foreach ($products as $p) {
                $productsArr[$p['product_id']] = [
                    'name' => $p['product_name'],
                    'price' => floatval($p['selling_price']),
                    'quantity' => isset($p['quantity']) ? intval($p['quantity']) : 0,
                    'image' => isset($p['product_image']) ? $p['product_image'] : 'default.png'
                ];
            }
            echo json_encode($productsArr, JSON_UNESCAPED_UNICODE);
        ?>;

        let newItemIndex = 0;
        function addNewItemRow() {
            newItemIndex++;
            const tbody = document.getElementById('new-items-body');
            const tr = document.createElement('tr');
            tr.innerHTML = `
                <td>+</td>
                <td>
                    <select name="new_product_id[]" class="form-control product-select" style="width:220px" required>
                        <option value="">ຄົ້ນຫາແລະເລືອກສິນຄ້າ...</option>
                        <?php foreach ($products as $product): ?>
                            <option 
                                value="<?php echo htmlspecialchars($product['product_id'] ?? ''); ?>"
                                data-price="<?php echo htmlspecialchars($product['selling_price'] ?? '0'); ?>"
                                data-image="<?php echo htmlspecialchars($product['product_image'] ?? 'default.png'); ?>"
                                data-quantity="<?php echo htmlspecialchars($product['quantity'] ?? '0'); ?>"
                                <?php echo (isset($product['quantity']) && $product['quantity'] <= 0) ? 'disabled style="color:#888;"' : ''; ?>
                            >
                                <?php echo htmlspecialchars($product['product_name'] ?? ''); ?>
                                <?php echo (isset($product['quantity']) && $product['quantity'] <= 0) ? ' (ເຄື່ອງໝົດສະຕ໋ອກ)' : ''; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </td>
                <td>
                    <input type="number" name="new_price[]" id="new_price_${newItemIndex}" class="form-control" step="0.01" min="0" required>
                </td>
                <td>
                    <input type="number" name="new_quantity[]" class="form-control" min="1" value="1" required oninput="updateNewTotal(${newItemIndex})">
                </td>
                <td>
                    <input type="number" name="new_total[]" id="new_total_${newItemIndex}" class="form-control" step="0.01" min="0" readonly>
                </td>
                <td>
                    <button type="button" class="btn btn-danger" onclick="this.closest('tr').remove()">
                        <i class="fas fa-trash"></i>
                    </button>
                </td>
            `;
            tbody.appendChild(tr);

            // Apply Select2
            $(tr).find('.product-select').select2({
                templateResult: formatProductOption,
                templateSelection: formatProductSelection,
                dropdownParent: $(tr)
            }).on('select2:select', function(e) {
                autoFillProduct(this, newItemIndex);
            });

            // Event คำนวณ total อัตโนมัติ
            const priceInput = tr.querySelector(`input[name="new_price[]"]`);
            const qtyInput = tr.querySelector(`input[name="new_quantity[]"]`);
            priceInput.addEventListener('input', () => updateNewTotal(newItemIndex));
            qtyInput.addEventListener('input', () => updateNewTotal(newItemIndex));
        }

        // Select2 template
        function formatProductOption(state) {
            if (!state.id) return state.text;
            var $option = $(state.element);
            var img = $option.data('image') ? $option.data('image') : 'default.png';
            var imgPath = 'img/products/' + img;
            var price = $option.data('price');
            var qty = $option.data('quantity');
            var outOfStock = qty <= 0;
            return $(
                `<span>
                    <img src="${imgPath}" style="width:30px;height:30px;object-fit:cover;border-radius:4px;margin-right:8px;" onerror="this.onerror=null;this.src='img/products/default.png';">
                    ${state.text}
                    <span style="color:#888;font-size:12px;"> - ₭${price}${outOfStock ? ' (ເຄື່ອງໝົດສະຕ໋ອກ)' : ''}</span>
                </span>`
            );
        }
        function formatProductSelection(state) {
            if (!state.id) return state.text;
            var $option = $(state.element);
            var img = $option.data('image') ? $option.data('image') : 'default.png';
            var imgPath = 'img/products/' + img;
            return $(
                `<span>
                    <img src="${imgPath}" style="width:22px;height:22px;object-fit:cover;border-radius:3px;margin-right:6px;" onerror="this.onerror=null;this.src='img/products/default.png';">
                    ${state.text}
                </span>`
            );
        }

        function autoFillProduct(select, idx) {
            const option = select.options[select.selectedIndex];
            const price = option.getAttribute('data-price');
            if (price !== null) {
                document.getElementById('new_price_' + idx).value = price;
                updateNewTotal(idx);
            }
        }

        function updateNewTotal(idx) {
            const price = parseFloat(document.getElementById('new_price_' + idx).value) || 0;
            const tr = document.getElementById('new_price_' + idx).closest('tr');
            const qtyInput = tr.querySelector('input[name="new_quantity[]"]');
            const qty = qtyInput ? parseInt(qtyInput.value) || 0 : 0;
            document.getElementById('new_total_' + idx).value = (price * qty).toFixed(2);
        }

        $(document).ready(function() {
            // Apply Select2 to all .product-select (existing and future)
            $('.product-select').select2({
                templateResult: formatProductOption,
                templateSelection: formatProductSelection,
                width: '100%'
            }).on('select2:select', function(e) {
                // For existing rows, do nothing (readonly)
            });
        });
        </script>
    </head>
    <body>
        <?php include_once('home.php'); ?>

        <div class="content-area">
            <div class="edit-form">
                <h1><i class="fas fa-edit"></i> ແກ້ໄຂໃບບິນ: <?php echo htmlspecialchars($order['order_id']); ?> - ຮ້ານ: <?php echo htmlspecialchars($order['store_name'] ?? '-'); ?></h1>
                <?php if (!empty($alert_message)): ?>
                    <div class="alert alert-<?php echo $alert_type; ?>">
                        <?php echo $alert_message; ?>
                    </div>
                <?php endif; ?>
                
                <form method="POST" action="">
                    <input type="hidden" name="page" value="<?php echo $page; ?>">
                    <div class="form-row">
                        <div class="form-col">
                            <h3>ຂໍ້ມູນລູກຄ້າ</h3>
                            <div class="form-group">
                                <label for="customer_name">ຊື່ລູກຄ້າ</label>
                                <input type="text" id="customer_name" name="customer_name" class="form-control" value="<?php echo htmlspecialchars($order['customer_name'] ?? ''); ?>">
                            </div>
                            <div class="form-group">
                                <label for="customer_phone">ເບີໂທລູກຄ້າ</label>
                                <input type="text" id="customer_phone" name="customer_phone" class="form-control" value="<?php echo htmlspecialchars($order['customer_phone'] ?? ''); ?>">
                            </div>
                            <div class="form-group">
                                <label for="shipping_branch">ທີ່ຢູ່/ສາຂາຂົນສົ່ງ</label>
                                <input type="text" id="shipping_branch" name="shipping_branch" class="form-control" value="<?php echo htmlspecialchars($order['shipping_branch'] ?? ''); ?>">
                            </div>
                            <div class="form-group">
                                <label for="store_id">เลือกร้านค้า</label>
                                <select id="store_id" name="store_id" class="form-control">
                                    <option value="">-- ເລືອກຮ້ານ --</option>
                                    <?php foreach ($all_stores as $store): ?>
                                        <option value="<?php echo htmlspecialchars($store['store_id']); ?>" <?php echo ($order['store_id'] == $store['store_id']) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($store['store_name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-col">
                            <h3>ຂໍ້ມູນການຈັດສົ່ງແລະການຊຳລະ</h3>
                            <div class="form-group">
                                <label for="shipping_company">ບໍລິສັດຂົນສົ່ງ</label>
                                <select id="shipping_company" name="shipping_company" class="form-control">
                                    <option value="">-- ເລືອກບໍລິສັດຂົນສົ່ງ --</option>
                                    <?php foreach ($shipping_companies as $company): ?>
                                        <option value="<?php echo htmlspecialchars($company['shipping_id']); ?>" <?php echo ($order['shipping_company'] == $company['shipping_id']) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($company['shipping_name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="payment_status">ສະຖານະການຈ່າຍ</label>
                                <select id="payment_status" name="payment_status" class="form-control">
                                    <option value="ຍັງບໍ່ຈ່າຍ" <?php echo (trim($order['payment_status']) == 'ຍັງບໍ່ຈ່າຍ' || strtolower(trim($order['payment_status'])) == 'pending') ? 'selected' : ''; ?>>ຍັງບໍ່ຈ່າຍ</option>
                                    <option value="ມັດຈຳ" <?php echo (trim($order['payment_status']) == 'ມັດຈຳ' || strtolower(trim($order['payment_status'])) == 'deposit') ? 'selected' : ''; ?>>ມັດຈຳ</option>
                                    <option value="ຈ່າຍເເລ້ວ" <?php echo (trim($order['payment_status']) == 'ຈ່າຍເເລ້ວ' || trim($order['payment_status']) == 'ຈ່າຍແລ້ວ') ? 'selected' : ''; ?>>ຈ່າຍເເລ້ວ</option>
                                    <option value="ຍົກເລີກ" <?php echo (trim($order['payment_status']) == 'ຍົກເລີກ' || strtolower(trim($order['payment_status'])) == 'cancelled') ? 'selected' : ''; ?>>ຍົກເລີກ</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="payment_method">ວິທີການຈ່າຍ</label>
                                <select id="payment_method" name="payment_method" class="form-control">
                                    <?php
                                    $is_pending = ($order['payment_status'] ?? '') === 'ຍັງບໍ່ຈ່າຍ';
                                    ?>
                                    <option value="" <?php echo $is_pending ? 'selected' : ''; ?>>ຍັງບໍ່ມີການຈ່າຍ</option>
                                    <option value="ຈ່າຍສົດ" <?php echo ($order['payment_method'] == 'ຈ່າຍສົດ') ? 'selected' : ''; ?>>ຈ່າຍສົດ</option>
                                    <option value="ໂອນ" <?php echo ($order['payment_method'] == 'ໂອນ') ? 'selected' : ''; ?>>ໂອນ</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="cod_type">ຂໍ້ມູນຄ່າຝາກ</label>
                                <select id="cod_type" name="cod_type" class="form-control">
                                    <option value="ຫັກ COD" <?php echo ($order['cod_type'] == 'ຫັກ COD') ? 'selected' : ''; ?>>ຫັກ COD</option>
                                    <option value="ຄ່າຝາກປາຍທາງ" <?php echo ($order['cod_type'] == 'ຄ່າຝາກປາຍທາງ') ? 'selected' : ''; ?>>ຄ່າຝາກປາຍທາງ</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="shipping_code">ໄອດີຂົນສົ່ງ</label>
                                <input type="text" name="shipping_code" id="shipping_code" class="form-control" value="<?php echo htmlspecialchars($order['shipping_code'] ?? ''); ?>">
                            </div>
                        </div>
                    </div>
                    <div class="readonly-items">
                        <h3>ລາຍການສິນຄ້າ (ເພີ່ມ/ລົບ/ເເກ້ໄຂໄດ້)</h3>
                        <table class="invoice-items-table">
                            <thead>
                                <tr>
                                    <th>ລຳດັບ</th>
                                    <th>ສິນຄ້າ</th>
                                    <th>ລາຄາ</th>
                                    <th>ຈຳນວນ</th>
                                    <th>ລວມ</th>
                                    <th>ลบ</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (count($items) > 0): ?>
                                    <?php foreach ($items as $index => $item): ?>
                                        <tr>
                                            <td><?php echo $index + 1; ?></td>
                                            <td>
                                                <input type="hidden" name="item_id[]" value="<?php echo $item['id']; ?>">
                                                <input type="text" value="<?php echo htmlspecialchars($item['product_name'] ?? ''); ?>" class="form-control" readonly>
                                            </td>
                                            <td>
                                                <input type="number" name="price[]" value="<?php echo $item['price']; ?>" class="form-control" step="0.01" min="0">
                                            </td>
                                           <td>
                                        <?php
                                        $product_id = $item['product_id'];
                                        $stock = $productsArr[$product_id]['quantity'] ?? 0;
                                        $old_qty = $item['quantity'];
                                        $max_qty = $stock + $old_qty;
                                        ?>
                                        <input
                                            type="number"
                                            name="quantity[]"
                                            value="<?php echo $old_qty; ?>"
                                            class="form-control quantity-input"
                                            min="1"
                                            max="<?php echo $max_qty; ?>"
                                            data-stock="<?php echo $stock; ?>"
                                            data-oldqty="<?php echo $old_qty; ?>"
                                            style="width:80px;display:inline-block;"
                                        >
                                        <span class="stock-info" style="color:#888;font-size:12px;">
                                            (ໃນ stock: <?php echo $stock; ?> + ໃນ order ນີ້: <?php echo $old_qty; ?>)
                                        </span>
                                        <span class="stock-warning" style="color:red;font-size:12px;display:none;">ມີໃນ stock+order ພຽງເເຕ່ <span class="stock-max"><?php echo $max_qty; ?></span> ອັນ</span>
                                    </td>
                                            <td>
                                                <input type="number" name="total[]" value="<?php echo $item['total']; ?>" class="form-control" step="0.01" min="0" readonly>
                                            </td>
                                            <td>
                                                <!-- สำหรับสินค้าเก่า -->
<button type="button" class="btn btn-danger" onclick="removeItemRow(this, <?php echo $item['id']; ?>, '<?php echo htmlspecialchars($item['product_name'], ENT_QUOTES); ?>')">
    <i class="fas fa-trash"></i>
</button>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                            <tbody id="new-items-body">
                            </tbody>
                            <tr>
                                <td colspan="6">
                                    <button type="button" class="btn btn-primary" onclick="addNewItemRow()">
                                        <i class="fas fa-plus"></i> ເພີ່ມສິນຄ້າໃໝ່
                                    </button>
                                </td>
                            </tr>
                        </table>
                        <div class="invoice-summary">
                            <div class="summary-row">
                                <span>ລວມເງິນ:</span>
                                <span>₭<?php echo number_format($order['subtotal'] ?? 0, 0); ?></span>
                            </div>
                            <div class="summary-row">
                                <span>ສ່ວນຫຼຸດ:</span>
                                <input type="number" name="discount" value="<?php echo $order['discount'] ?? 0; ?>" class="form-control" style="width:100px;display:inline-block;">
                            </div>
                            <div class="summary-row">
                                <span>ຈຳນວນເງິນມັດຈຳ:</span>
                                <input type="number" name="deposit_amount" value="<?php echo $order['deposit_amount'] ?? 0; ?>" class="form-control" style="width:100px;display:inline-block;">
                            </div>
                            <div class="summary-row total">
                                <span>ຍອດເງິນທັງໝົດ:</span>
                                <span>₭<?php 
                                    $subtotal = floatval($order['subtotal'] ?? 0);
                                    $discount = floatval($order['discount'] ?? 0);
                                    $depositAmount = floatval($order['deposit_amount'] ?? 0);
                                    $remainingAmount = $subtotal - $discount - $depositAmount;
                                    echo number_format($remainingAmount, 0); 
                                ?></span>
                            </div> 
                        </div>
                    </div>
                    <div class="btn-container" style="display: flex; justify-content: flex-end; gap: 10px;">
                        <?php
                        // สร้าง URL กลับไปหน้าเดิมพร้อมพารามิเตอร์ครบ
                        $return_params = [
                            'order_id' => $order['order_id'],
                            'page' => $page,
                            'highlight' => 1
                        ];
                        
                        // เพิ่มพารามิเตอร์ search และ date ถ้ามี
                        if (isset($_GET['search']) && !empty($_GET['search'])) {
                            $return_params['search'] = $_GET['search'];
                        }
                        if (isset($_GET['date_from']) && !empty($_GET['date_from'])) {
                            $return_params['date_from'] = $_GET['date_from'];
                        }
                        if (isset($_GET['date_to']) && !empty($_GET['date_to'])) {
                            $return_params['date_to'] = $_GET['date_to'];
                        }
                        if (isset($_GET['customer_id']) && !empty($_GET['customer_id'])) {
                            $return_params['customer_id'] = $_GET['customer_id'];
                        }
                        
                        $return_url = 'invoice_history.php?' . http_build_query($return_params);
                        ?>
                        <a href="<?php echo htmlspecialchars($return_url); ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> ກັບຄືນ
                        </a>
                        <button type="submit" name="update_invoice" class="btn-update-invoice">
                            <i class="fas fa-save"></i> ບັນທຶກການແກ້ໄຂ
                        </button>
                    </div>
                </form> 
                
            </div> 
        </div>
        <script>
        // คำนวณ total อัตโนมัติเมื่อเปลี่ยนราคา/จำนวน
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('input[name^="price"], input[name^="quantity"]').forEach(function(input) {
                input.addEventListener('input', function() {
                    var row = input.closest('tr');
                    var price = parseFloat(row.querySelector('input[name^="price"]').value) || 0;
                    var qty = parseInt(row.querySelector('input[name^="quantity"]').value) || 0;
                    var total = row.querySelector('input[name^="total"]');
                    if (total) total.value = (price * qty).toFixed(2);
                });
            });
        });
        </script>
        <script>
function formatProduct (product) {
    var stockLabel = outOfStock ? '<span style="color:red;"> (ເຄື່ອງໝົດສະຕ໋ອກ)</span>' : '';
    return $(
        '<div class="select2-product-item">' +
            (img ? '<img src="' + img + '" class="select2-product-img" />' : '') +
            '<span class="select2-product-name">' + name + stockLabel + '</span>' +
            (price ? '<span class="select2-product-price">' + price + ' ₭</span>' : '') +
        '</div>'
    );
}
$('.product-select').select2({
    templateResult: formatProduct,
    templateSelection: formatProduct,
    width: '100%' // ให้เต็มบรรทัด
});
</script>
<style>
.select2-container--default .select2-results__option .select2-product-item {
    display: flex;
    align-items: center;
    gap: 10px;
    min-width: 350px; /* ขยายพื้นที่ dropdown */
}
.select2-product-img {
    width: 40px;
    height: 40px;
    object-fit: contain;
    margin-right: 10px;
    border: 1px solid #eee;
    background: #fff;
}
.select2-product-name {
    flex: 1 1 200px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    font-weight: bold;
    font-size: 1em;
}
.select2-product-price {
    color: #888;
    margin-left: 10px;
    min-width: 60px;
    text-align: right;
}
.select2-container--default .select2-selection--single .select2-product-item {
    min-width: 250px;
}
.select2-container--default .select2-selection--single {
    min-width: 250px;
    max-width: 100%;
}

/* ปรับขนาด dropdown และ option ของ Select2 ให้พอดี ไม่บังราคา */
.select2-container--default .select2-results__option {
    min-width: 300px;   /* ปรับให้พอดี */
    max-width: 340px;   /* ป้องกันกว้างเกิน */
    white-space: normal !important;
    word-break: break-word;
    padding: 8px 12px;
}
.select2-container--default .select2-dropdown {
    min-width: 320px;
    max-width: 360px;
}
.select2-container--default .select2-selection--single {
    min-width: 300px;
    max-width: 340px;
}
.select2-product-name {
    display: inline-block;
    max-width: 200px;
    white-space: normal;
    vertical-align: middle;
}
        </style>
        <script>
document.addEventListener('DOMContentLoaded', function() {
    const urlParams = new URLSearchParams(window.location.search);
    const orderId = urlParams.get('order_id');
    if(orderId) {
        const row = document.querySelector(`tr[data-order-id='${orderId}']`);
        if(row) {
            row.scrollIntoView({behavior: 'smooth', block: 'center'});
            row.style.background = '#ffeeba'; // highlight
            setTimeout(() => row.style.background = '', 3000); // ลบ highlight หลัง 3 วิ
        }
    }
});
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.quantity-input').forEach(function(input) {
        input.addEventListener('input', function() {
            var max = parseInt(input.getAttribute('max')) || 0;
            var val = parseInt(input.value) || 0;
            var warning = input.parentElement.querySelector('.stock-warning');
            var maxSpan = input.parentElement.querySelector('.stock-max');
            if(val > max) {
                input.value = max > 0 ? max : 1;
                if(warning && maxSpan) {
                    maxSpan.textContent = max;
                    warning.style.display = '';
                }
            } else {
                if(warning) warning.style.display = 'none';
            }
        });
    });
});
</script>
<script>
function removeItemRow(btn, itemId, productName) {
    // Show confirmation dialog with product name
    Swal.fire({
        title: 'ຢືນຢັນການລົບສິນຄ້າ',
        text: 'ທ່ານຕ້ອງການລົບສິນຄ້າ ' + productName + ' ບໍ ?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'ຕົກລົງ',
        cancelButtonText: 'ຍົກເລີກ'
    }).then((result) => {
        if (result.isConfirmed) {
            // เพิ่ม hidden input สำหรับเก็บ id ที่จะลบ
            var input = document.createElement('input');
            input.type = 'hidden';
            input.name = 'delete_ids[]';
            input.value = itemId;
            document.querySelector('form').appendChild(input);

            // ลบแถวออกจากตาราง
            btn.closest('tr').remove();
        }
    });
}
</script> 
    </body>
    </html>








