<?php
require_once("db_con.php");

// ตั้งค่า header เป็น JSON
header('Content-Type: application/json'); 

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['delete_store_id'])) {
    $store_id = $_POST['delete_store_id'];
    
    // ตรวจสอบว่าร้านค้านี้ถูกใช้งานใน orders หรือไม่
    $check_sql = "SELECT COUNT(*) as count FROM orders WHERE store_id = ?";
    $check_stmt = $conn->prepare($check_sql);
    $check_stmt->bind_param("s", $store_id);
    $check_stmt->execute();
    $check_result = $check_stmt->get_result();
    $check_row = $check_result->fetch_assoc();
    
    if($check_row['count'] > 0) {
        echo json_encode([
            "success" => false,
            "message" => "ບໍ່ສາມາດລຶບໄດ້ເນື່ອງຈາກມີການສັ່ງຊື້ທີ່ໃຊ້ຮ້ານນີ້ຢູ່"
        ]);
        exit;
    }
    
    // ลบร้านค้า
    $sql = "DELETE FROM stores WHERE store_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $store_id);
    
    if ($stmt->execute()) {
        echo json_encode(["success" => true, "message" => "ລຶບຂໍ້ມູນຮ້ານສຳເລັດແລ້ວ"]);
    } else {
        echo json_encode(["success" => false, "message" => "ເກີດຂໍ້ຜິດພາດ: " . $stmt->error]);
    }
    
    $stmt->close();
    $check_stmt->close();
} else {
    echo json_encode(["success" => false, "message" => "ກະລຸນາລະບຸລະຫັດຮ້ານ"]);
}

$conn->close();
?>






