<?php
require_once("auth.php");
require_once("db_con.php");

//  англиการแสดง errors และ warnings
error_reporting(0);
ini_set('display_errors', 0);

// Set header as JSON
header('Content-Type: application/json');

try {
    if(isset($_POST['id'])) {
        $shipping_id = $_POST['id'];
        
        // Check if shipping company is in use
        $check_sql = "SELECT COUNT(*) as count FROM orders WHERE shipping_company = ?";
        $check_stmt = $conn->prepare($check_sql);
        $check_stmt->bind_param("s", $shipping_id);
        $check_stmt->execute();
        $check_result = $check_stmt->get_result();
        $check_row = $check_result->fetch_assoc();
        
        if($check_row['count'] > 0) {
            // Shipping company is in use, cannot delete
            echo json_encode(["success" => false, "message" => "ບໍ່ສາມາດລຶບໄດ້ເນື່ອງຈາກມີການສັ່ງຊື້ທີ່ໃຊ້ບໍລິສັດຂົນສົ່ງນີ້ຢູ່"]);
        } else {
            // Delete shipping company
            $delete_sql = "DELETE FROM shipping_company WHERE shipping_id = ?";
            $delete_stmt = $conn->prepare($delete_sql);
            $delete_stmt->bind_param("s", $shipping_id);
            
            if($delete_stmt->execute()) {
                echo json_encode(["success" => true]);
            } else {
                echo json_encode(["success" => false, "message" => $delete_stmt->error]);
            }
            
            $delete_stmt->close();
        }
        
        $check_stmt->close();
    } else {
        echo json_encode(["success" => false, "message" => "ກະລຸນາລະບຸລະຫັດບໍລິສັດຂົນສົ່ງ"]);
    }
} catch (Exception $e) {
    echo json_encode(["success" => false, "message" => "Server error: " . $e->getMessage()]);
}

$conn->close();
?>

