<?php
require_once("auth.php");
require_once("db_con.php");

// ຕັ້ງຄ່າ header ເປັນ JSON
header('Content-Type: application/json');

// <lemmaข้อมูล<lemma่ได้<lemma
$received_data = print_r($_POST, true);
error_log("Received data: " . $received_data);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id']) && !empty($_POST['id'])) {
    $order_id = $_POST['id'];
    error_log("Processing delete for order ID: " . $order_id);
    
    try {
        // ເລີ່ມ transaction
        $conn->begin_transaction();
        
        // ລຶບລາຍການສິນຄ້າໃນໃບສັ່ງຊື້
        $delete_items_sql = "DELETE FROM purchase_order_items WHERE purchase_order_id = ?";
        $delete_items_stmt = $conn->prepare($delete_items_sql);
        $delete_items_stmt->bind_param("i", $order_id);
        $delete_items_stmt->execute();
        
        // ລຶບໃບສັ່ງຊື້
        $delete_order_sql = "DELETE FROM purchase_orders WHERE id = ?";
        $delete_order_stmt = $conn->prepare($delete_order_sql);
        $delete_order_stmt->bind_param("i", $order_id);
        $delete_order_stmt->execute();
        
        // Commit transaction
        $conn->commit();
        
        echo json_encode(['success' => true, 'message' => 'ລຶບໃບສັ່ງຊື້ສຳເລັດແລ້ວ']);
        
    } catch (Exception $e) {
        // Rollback transaction ถ้าມີຂໍ້ຜິດພາດ
        $conn->rollback();
        error_log("Error deleting order: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage()]);
    }
} else {
    error_log("Invalid or missing order ID");
    echo json_encode(['success' => false, 'message' => 'ຂໍ້ມູນບໍ່ຖືກຕ້ອງ']);
}

$conn->close();
?>

