<?php
require_once("auth.php");
require_once("db_con.php");

// ตรวจสอบว่ามีการส่ง ID มาหรือไม่
if(isset($_POST['id'])) {
    $product_id = $_POST['id'];
    
    // ดึงข้อมูลรูปภาพก่อนลบ
    $sql = "SELECT product_image FROM products WHERE pro_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $product_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($result->num_rows > 0) {
        $product = $result->fetch_assoc();
        $image_file = $product['product_image'];
        
        // ลบข้อมูลสินค้า
        $delete_sql = "DELETE FROM products WHERE pro_id = ?";
        $delete_stmt = $conn->prepare($delete_sql);
        $delete_stmt->bind_param("s", $product_id);
        
        if($delete_stmt->execute()) {
            // ลบไฟล์รูปภาพถ้ามี
            if(!empty($image_file)) {
                $image_path = "img/products/" . $image_file;
                if(file_exists($image_path)) {
                    unlink($image_path);
                }
            }
            
            echo json_encode(["success" => true]);
        } else {
            echo json_encode(["success" => false, "message" => $delete_stmt->error]);
        }
        
        $delete_stmt->close();
    } else {
        echo json_encode(["success" => false, "message" => "ບໍ່ພົບຂໍ້ມູນສິນຄ້າ"]);
    }
    
    $stmt->close();
} else {
    echo json_encode(["success" => false, "message" => "ກະລຸນາລະບຸລະຫັດສິນຄ້າ"]);
}

$conn->close();
?>