<?php
// delete_invoice.php
require_once("auth.php"); 
require_once("db_con.php");
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);
$order_id = $data['order_id'] ?? '';
$pass_unlock = $data['pass_unlock'] ?? '';

if (!$order_id || !$pass_unlock) {
    echo json_encode(['status' => 'error', 'message' => 'ຂໍ້ມູນບໍ່ຄົບຖ້ວນ']);
    exit;
}

// ตรวจสอบรหัสผ่าน
$stmt = $conn->prepare("SELECT id FROM unlock_delate WHERE pass_unlock = ? LIMIT 1");
$stmt->bind_param('s', $pass_unlock);
$stmt->execute();
$stmt->store_result();
if ($stmt->num_rows === 0) {
    echo json_encode(['status' => 'error', 'message' => 'ລະຫັດຜ່ານບໍ່ຖືກຕ້ອง']);
    exit;
}
$stmt->close();

// ดึงสถานะล่าสุดของ order
$order = $conn->query("SELECT payment_status FROM orders WHERE order_id = '$order_id'")->fetch_assoc();
if ($order && $order['payment_status'] !== 'ຍົກເລີກ' && strtolower($order['payment_status']) !== 'cancelled') {
    // คืน stock เฉพาะถ้าไม่ใช่ "ຍົກເລີກ"
    $res = $conn->query("SELECT product_id, quantity FROM order_items WHERE order_id = '$order_id'");
    while ($row = $res->fetch_assoc()) {
        $conn->query("UPDATE products SET quantity = quantity + {$row['quantity']} WHERE product_id = {$row['product_id']}");
    }
}

// ลบ order_items
$stmt_items = $conn->prepare("DELETE FROM order_items WHERE order_id = ?");
$stmt_items->bind_param('s', $order_id);
$stmt_items->execute();
$stmt_items->close();

// ลบ order
$stmt = $conn->prepare("DELETE FROM orders WHERE order_id = ?");
$stmt->bind_param('s', $order_id);
if ($stmt->execute()) {
    echo json_encode(['status' => 'success']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'ລົບບໍ່ສຳເລັດ']);
}
$stmt->close();
$conn->close();
