<?php
require_once("auth.php");
require_once("db_con.php");

// ตั้งค่า header เป็น JSON
header('Content-Type: application/json');

// ตรวจสอบว่าส่ง ID มาหรือไม่
if(isset($_POST['id'])) {
    $category_id = $_POST['id'];
    
    // ตรวจสอบว่าค้าใช้หมวดนี้อยู่หรือไม่
    $check_sql = "SELECT COUNT(*) as count FROM products WHERE category_id = ?";
    $check_stmt = $conn->prepare($check_sql);
    $check_stmt->bind_param("s", $category_id);
    $check_stmt->execute();
    $check_result = $check_stmt->get_result();
    $check_row = $check_result->fetch_assoc();
    
    if($check_row['count'] > 0) {
        // ค้าใช้หมวดนี้อยู่ ไม่สามารถลบได้
        echo json_encode(["success" => false, "message" => "ບໍ່ສາມາດລຶບໄດ້ເນື່ອງຈາກມີສິນຄ້າທີ່ໃຊ້ປະເພດນີ້ຢູ່"]);
    } else {
        // ลบข้อมูลหมวด
        $delete_sql = "DELETE FROM product_category WHERE category_id = ?";
        $delete_stmt = $conn->prepare($delete_sql);
        $delete_stmt->bind_param("s", $category_id);
        
        if($delete_stmt->execute()) {
            echo json_encode(["success" => true]);
        } else {
            echo json_encode(["success" => false, "message" => $delete_stmt->error]);
        }
        
        $delete_stmt->close();
    }
    
    $check_stmt->close();
} else {
    echo json_encode(["success" => false, "message" => "ກະລຸນາລະບຸລະຫັດປະເພດສິນຄ້າ"]);
}

$conn->close();
?>
