<?php
require_once("db_con.php");

// Check the date format in the database vs the format used in the query
echo "<h2>Date Format Debug</h2>";

// Get the order we just inserted
$sql = "SELECT order_id, order_date, created_at, updated_at, payment_status FROM orders WHERE order_id = 'order_01'";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    echo "Order found:<br>";
    echo "Order ID: " . $row["order_id"] . "<br>";
    echo "Order Date: " . $row["order_date"] . " (Format: " . date('Y-m-d', strtotime($row["order_date"])) . ")<br>";
    echo "Created At: " . $row["created_at"] . " (Format: " . date('Y-m-d', strtotime($row["created_at"])) . ")<br>";
    echo "Updated At: " . $row["updated_at"] . " (Format: " . date('Y-m-d', strtotime($row["updated_at"])) . ")<br>";
    echo "Payment Status: " . $row["payment_status"] . "<br><br>";
    
    // Check if the date is in the range used in summary_income
    $default_start = date('Y-m-01'); // First day of current month
    $default_end = date('Y-m-t');    // Last day of current month
    
    echo "Default date range in summary_income:<br>";
    echo "Start Date: " . $default_start . "<br>";
    echo "End Date: " . $default_end . "<br><br>";
    
    // Check if our order date falls within this range
    $order_date = date('Y-m-d', strtotime($row["order_date"]));
    if ($order_date >= $default_start && $order_date <= $default_end) {
        echo "Order date is within the default range.<br>";
    } else {
        echo "Order date is NOT within the default range.<br>";
        echo "You need to set the date range in summary_income to include " . $order_date . "<br>";
    }
    
    // Test the SQL query directly
    echo "<h3>Testing SQL Query</h3>";
    $test_start = date('Y-m-d', strtotime('2025-05-01'));
    $test_end = date('Y-m-d', strtotime('2025-05-31'));
    
    echo "Test date range: " . $test_start . " to " . $test_end . "<br>";
    
    $sql = "SELECT o.order_id, o.order_date, o.payment_status, o.created_at, o.updated_at,
            CASE 
                WHEN o.payment_status = 'ຈ່າຍເເລ້ວ' THEN (o.subtotal - o.discount)
                WHEN o.payment_status = 'ມັດຈຳ' THEN o.deposit_amount
                ELSE 0
            END as amount
            FROM orders o
            WHERE (DATE(o.order_date) BETWEEN ? AND ? OR DATE(o.created_at) BETWEEN ? AND ?)
            AND (o.payment_status = 'ຈ່າຍເເລ້ວ' OR o.payment_status = 'ມັດຈຳ')";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssss", $test_start, $test_end, $test_start, $test_end);
    $stmt->execute();
    $result = $stmt->get_result();
    
    echo "Query results: " . $result->num_rows . " rows<br>";
    if ($result->num_rows > 0) {
        echo "<table border='1'><tr><th>Order ID</th><th>Order Date</th><th>Payment Status</th><th>Amount</th><th>Created At</th><th>Updated At</th></tr>";
        while($row = $result->fetch_assoc()) {
            echo "<tr><td>" . $row["order_id"] . "</td><td>" . $row["order_date"] . "</td><td>" . $row["payment_status"] . "</td><td>" . $row["amount"] . "</td><td>" . $row["created_at"] . "</td><td>" . $row["updated_at"] . "</td></tr>";
        }
        echo "</table>";
    } else {
        echo "No results found with the test query.<br>";
        
        // Check if there's a typo in the payment status
        $sql = "SELECT DISTINCT payment_status FROM orders";
        $result = $conn->query($sql);
        echo "<br>Available payment statuses in the database:<br>";
        while($row = $result->fetch_assoc()) {
            echo "- " . $row["payment_status"] . "<br>";
        }
    }
} else {
    echo "Order with ID 'order_01' not found.";
}

$conn->close();
?>