<?php
require_once("auth.php");
require_once("db_con.php");

// รับค่าจาก AJAX
$limit = 100;
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset = ($page - 1) * $limit;
$search = isset($_GET['search']) ? trim($_GET['search']) : '';

$where = '';
if ($search !== '') {
    $search_sql = $conn->real_escape_string($search);
    $where = "WHERE customer_id LIKE '%$search_sql%' OR name LIKE '%$search_sql%' OR phone LIKE '%$search_sql%'";
}

// Get total rows
$total_sql = "SELECT COUNT(*) as total FROM customers $where";
$total_result = $conn->query($total_sql);
$total_row = $total_result->fetch_assoc();
$total_customers = $total_row['total'];
$total_pages = ceil($total_customers / $limit);

// Fetch customers for current page
$sql = "SELECT * FROM customers $where ORDER BY customer_id ASC LIMIT $limit OFFSET $offset";
$result = $conn->query($sql);

?>
<tbody id="customer-table-body">
<?php
if ($result->num_rows > 0) {
    $counter = $offset + 1;
    while($row = $result->fetch_assoc()) {
        echo "<tr data-id='".$row['customer_id']."'>";
        echo "<td>" . $counter . "</td>";
        echo "<td>" . $row['customer_id'] . "</td>";
        echo "<td>" . $row['name'] . "</td>";
        echo "<td>" . $row['phone'] . "</td>";
        echo "<td class='comment-cell' data-comment='" . htmlspecialchars($row['comment'] ?? '') . "'>" 
            . "<span class='comment-text'>" . ($row['comment'] ?? '') . "</span>"
            . "<button type='button' class='edit-comment-btn' data-id='" . $row['customer_id'] . "'>"
            . "<i class='fas fa-edit'></i></button></td>";
        echo "<td class='action-buttons'>";
        echo "<button class='history-btn' data-id='".$row['customer_id']."'><i class='fas fa-history'></i> ເບິ່ງປະຫວັດ</button>";
        echo "</td>";
        echo "</tr>";
        $counter++;
    }
} else {
    echo "<tr><td colspan='6' style='text-align:center'>ບໍ່ພົບຂໍ້ມູນລູກຄ້າ</td></tr>";
}
?>
</tbody>
