<?php
require_once("auth.php");
require_once("db_con.php");
?>
<!DOCTYPE html>
<html lang="en"> 
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"> 
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/data_customer.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <title>ຂໍ້ມູນລູກຄ້າ</title>
    <link rel="icon" type="image/png" href="/test01/favicon.png">

</head>
<body>
    <?php include('home.php'); ?>

    <div class="content-area">
        <div class="customer-table-container">
            <div class="sticky-header-wrapper">
                <div class="table-header">
                    <h1><i class="fas fa-users"></i> ຂໍ້ມູນລູກຄ້າ</h1>
                    <!-- Search form -->
<form class="search-filter-form" method="get" style="width:100%;margin-bottom:0;">
    <div class="search-container">
        <input type="text" id="customer-search" name="search" value="<?php echo isset($_GET['search']) ? htmlspecialchars($_GET['search']) : ''; ?>" placeholder="ຄົ້ນຫາລູກຄ້າ..." class="search-input" style="width:300px;">
        <button type="submit" class="btn search-btn"><i class="fas fa-search"></i> ຄົ້ນຫາ</button>
        <?php if(isset($_GET['search']) && $_GET['search'] !== ''): ?>
            <a href="data_customer.php" class="btn reset-btn"><i class="fas fa-times"></i> ກັບຄືນ</a>
        <?php endif; ?>
    </div>
</form>

                </div>
                
                <div class="table-header-row">
                    <table class="customer-table">
                        <thead>
                            <tr>
                                <th>ລຳດັບ</th>
                                <th>ລະຫັດໄອດີ</th>
                                <th>ຊື່</th>
                                <th>ເບີໂທ</th>
                                <th>ຄອມເມັ້ນ</th>
                                <th>ປະຫວັດການສັ່ງຊື້</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
            
            <div class="table-body-container">
                <table class="customer-table">
                    <thead style="visibility: hidden; position: absolute;">
                        <tr>
                            <th>ລຳດັບ</th>
                            <th>ລະຫັດໄອດີ</th>
                            <th>ຊື່</th>
                            <th>ເບີໂທ</th>
                            <th>ຄອມເມັ້ນ</th>
                            <th>ປະຫວັດການສັ່ງຊື້</th>
                        </tr>
                    </thead>
                    <tbody id="customer-table-body">
                        <!-- ข้อมูลลูกค้าจะถูกโหลดด้วย AJAX -->
                    </tbody>
                </table>
            </div>
        </div>

        <div class="pagination"></div>
    </div>

    <!-- Modal for viewing customer history -->
    <div id="history-modal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>ປະຫວັດການສັ່ງຊື້ຂອງລູກຄ້າ</h2>
            <div id="customer-history-content">
                <div class="loading">
                    <i class="fas fa-spinner fa-spin"></i>
                    <p>ກຳລັງໂຫຼດຂໍ້ມູນ...</p>
                </div>
            </div>
        </div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        function loadCustomerTable(page, search) {
            fetch(`data_customer_table.php?page=${page}&search=${encodeURIComponent(search)}`)
                .then(res => res.text())
                .then(html => {
                    document.getElementById('customer-table-body').outerHTML = html;
                    setupCommentEdit();
                    setupHistoryModal();
                });
        }

        function loadPagination(page, search) {
            fetch(`data_customer_pagination.php?page=${page}&search=${encodeURIComponent(search)}`)
                .then(res => res.text())
                .then(html => {
                    document.querySelector('.pagination').outerHTML = html;
                    setupPaginationLinks();
                });
        }

        function setupPaginationLinks() {
            document.querySelectorAll('.pagination .page-btn').forEach(btn => {
                btn.addEventListener('click', function(e) {
                    e.preventDefault();
                    const page = this.getAttribute('data-page');
                    const search = document.getElementById('customer-search').value;
                    loadCustomerTable(page, search);
                    loadPagination(page, search);
                });
            });
        }

        // ฟังก์ชันสำหรับ comment modal (เหมือนเดิม)
        function setupCommentEdit() {
            document.querySelectorAll('.edit-comment-btn').forEach(btn => {
                btn.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    const customerId = this.getAttribute('data-id');
                    const commentCell = this.closest('.comment-cell');
                    const currentComment = commentCell.getAttribute('data-comment') || '';
                    openCommentModal(commentCell, customerId, currentComment);
                });
            });
        }

        // ฟังก์ชันสำหรับ history modal (เหมือนเดิม)
        function setupHistoryModal() {
            document.querySelectorAll('.history-btn').forEach(btn => {
                btn.addEventListener('click', function() {
                    const customerId = this.getAttribute('data-id');
                    const historyModal = document.getElementById('history-modal');
                    const historyContent = document.getElementById('customer-history-content');
                    historyModal.style.display = 'block';
                    setTimeout(() => historyModal.classList.add('show'), 10);
                    historyContent.innerHTML = `
                        <div class="loading">
                            <i class="fas fa-spinner fa-spin"></i>
                            <p>ກຳລັງໂຫຼດຂໍ້ມູນ...</p>
                        </div>
                    `;
                    fetch('get_customer_history?customer_id=' + customerId)
                        .then(response => response.text())
                        .then(data => {
                            historyContent.innerHTML = data;
                        })
                        .catch(error => {
                            historyContent.innerHTML = `
                                <div class="error">
                                    <i class="fas fa-exclamation-circle"></i>
                                    <p>ເກີດຂໍ້ຜິດພາດໃນການດຶງຂໍ້ມູນ</p>
                                </div>
                            `;
                        });
                });
            });
        }

        // ฟังก์ชัน modal comment (เหมือนเดิม)
        let currentCommentCell = null;
        let currentCustomerId = null;
        const commentModal = document.getElementById('commentModal');
        const commentTextarea = document.getElementById('commentText');
        const closeModalBtn = commentModal.querySelector('.close-modal');
        const saveCommentBtn = commentModal.querySelector('.save-comment-btn');
        const cancelCommentBtn = commentModal.querySelector('.cancel-comment-btn');
        function openCommentModal(commentCell, customerId, currentComment) {
            currentCommentCell = commentCell;
            currentCustomerId = customerId;
            commentTextarea.value = currentComment;
            commentModal.style.display = 'flex';
            setTimeout(() => {
                commentModal.classList.add('active');
                commentTextarea.focus();
            }, 10);
        }
        function closeCommentModal() {
            commentModal.classList.remove('active');
            setTimeout(() => {
                commentModal.style.display = 'none';
            }, 300);
            currentCommentCell = null;
            currentCustomerId = null;
        }
        closeModalBtn.addEventListener('click', closeCommentModal);
        cancelCommentBtn.addEventListener('click', closeCommentModal);
        commentModal.addEventListener('click', function(e) {
            if (e.target === commentModal) closeCommentModal();
        });
        saveCommentBtn.addEventListener('click', function() {
            if (!currentCommentCell || !currentCustomerId) return;
            const newComment = commentTextarea.value.trim();
            saveCommentBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> ກຳລັງບັນທຶກ...';
            saveCommentBtn.disabled = true;
            fetch('update_comment', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `customer_id=${currentCustomerId}&comment=${encodeURIComponent(newComment)}`
            })
            .then(response => response.json())
            .then(data => {
                if(data.success) {
                    const commentSpan = currentCommentCell.querySelector('.comment-text');
                    commentSpan.textContent = newComment;
                    currentCommentCell.setAttribute('data-comment', newComment);
                    currentCommentCell.classList.add('comment-success');
                    setTimeout(() => {
                        currentCommentCell.classList.remove('comment-success');
                    }, 1500);
                    closeCommentModal();
                } else {
                    alert('ເກີດຂໍ້ຜິດພາດໃນການອັບເດດຄອມເມັ້ນ');
                }
            })
            .catch(() => {
                alert('ເກີດຂໍ້ຜິດພາດໃນການອັບເດດຄອມເມັ້ນ');
            })
            .finally(() => {
                saveCommentBtn.innerHTML = 'ບັນທຶກ';
                saveCommentBtn.disabled = false;
            });
        });
        commentTextarea.addEventListener('keydown', function(e) {
            if ((e.ctrlKey || e.metaKey) && e.key === 'Enter') saveCommentBtn.click();
            if (e.key === 'Escape') closeCommentModal();
        });

        // โหลดข้อมูลครั้งแรก
        const search = document.getElementById('customer-search').value;
        loadCustomerTable(1, search);
        loadPagination(1, search);

        // handle search submit
        document.querySelector('.search-filter-form').addEventListener('submit', function(e) {
            e.preventDefault();
            const search = document.getElementById('customer-search').value;
            loadCustomerTable(1, search);
            loadPagination(1, search);
        });

        const historyModal = document.getElementById('history-modal');
        const closeBtn = historyModal.querySelector('.close');
        if (closeBtn) {
            closeBtn.addEventListener('click', function() {
                historyModal.classList.remove('show');
                setTimeout(() => {
                    historyModal.style.display = 'none';
                }, 300);
            });
        }
        // ปิด modal เมื่อคลิกนอก modal-content
        historyModal.addEventListener('click', function(e) {
            if (e.target === historyModal) {
                historyModal.classList.remove('show');
                setTimeout(() => {
                    historyModal.style.display = 'none';
                }, 300);
            }
        });
    });
    </script>
    <!-- Pagination controls -->

</body>
</html>

<div class="comment-modal" id="commentModal">
    <div class="comment-modal-content">
        <div class="comment-modal-header">
            <h3>ແກ້ໄຂຄອມເມັ້ນ</h3>
            <button class="close-modal">&times;</button>
        </div>
        <textarea class="comment-textarea" id="commentText" placeholder="ພິມຄອມເມັ້ນຂອງທ່ານທີ່ນີ້..."></textarea>
        <div class="comment-modal-footer">
            <button class="cancel-comment-btn">ຍົກເລີກ</button>
            <button class="save-comment-btn">ບັນທຶກ</button>
        </div>
    </div>
</div>

<script>
// Add this script at the end of your file, right before the closing </body> tag
document.addEventListener('DOMContentLoaded', function() {
    console.log('DOM loaded, setting up comment edit functionality');
    
    // Setup edit buttons
    const editButtons = document.querySelectorAll('.edit-comment-btn');
    console.log('Found ' + editButtons.length + ' edit buttons');
    
    // Modal elements
    const commentModal = document.getElementById('commentModal');
    if (!commentModal) {
        console.error('Comment modal not found!');
        return;
    }
    
    const commentTextarea = document.getElementById('commentText');
    const closeModalBtn = commentModal.querySelector('.close-modal');
    const saveCommentBtn = commentModal.querySelector('.save-comment-btn');
    const cancelCommentBtn = commentModal.querySelector('.cancel-comment-btn');
    
    let currentCommentCell = null;
    let currentCustomerId = null;
    
    // Function to open the modal
    function openCommentModal(commentCell, customerId, currentComment) {
        console.log('Opening modal for customer ID: ' + customerId);
        currentCommentCell = commentCell;
        currentCustomerId = customerId;
        commentTextarea.value = currentComment;
        
        // Show modal with animation
        commentModal.style.display = 'flex';
        setTimeout(() => {
            commentModal.classList.add('active');
            commentTextarea.focus();
        }, 10);
    }
    
    // Function to close the modal
    function closeCommentModal() {
        commentModal.classList.remove('active');
        setTimeout(() => {
            commentModal.style.display = 'none';
        }, 300);
        currentCommentCell = null;
        currentCustomerId = null;
    }
    
    // Close modal events
    closeModalBtn.addEventListener('click', closeCommentModal);
    cancelCommentBtn.addEventListener('click', closeCommentModal);
    
    // Close modal when clicking outside
    commentModal.addEventListener('click', function(e) {
        if (e.target === commentModal) {
            closeCommentModal();
        }
    });
    
    // Save comment
    saveCommentBtn.addEventListener('click', function() {
        if (!currentCommentCell || !currentCustomerId) {
            console.error('No current comment cell or customer ID');
            return;
        }
        
        const newComment = commentTextarea.value.trim();
        console.log('Saving comment for customer ID: ' + currentCustomerId);
        
        // Show loading state
        saveCommentBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> ກຳລັງບັນທຶກ...';
        saveCommentBtn.disabled = true;
        
        fetch('update_comment', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: `customer_id=${currentCustomerId}&comment=${encodeURIComponent(newComment)}`
        })
        .then(response => response.json())
        .then(data => {
            if(data.success) {
                console.log('Comment updated successfully');
                // Update the text content of the cell
                const commentSpan = currentCommentCell.querySelector('.comment-text');
                commentSpan.textContent = newComment;
                currentCommentCell.setAttribute('data-comment', newComment);
                
                // Add success animation
                currentCommentCell.classList.add('comment-success');
                setTimeout(() => {
                    currentCommentCell.classList.remove('comment-success');
                }, 1500);
                
                // Close modal
                closeCommentModal();
            } else {
                console.error('Error updating comment:', data.error);
                alert('ເກີດຂໍ້ຜິດພາດໃນການອັບເດດຄອມເມັ້ນ');
            }
        })
        .catch(error => {
            console.error('Error updating comment:', error);
            alert('ເກີດຂໍ້ຜິດພາດໃນການອັບເດດຄອມເມັ້ນ');
        })
        .finally(() => {
            // Reset button state
            saveCommentBtn.innerHTML = 'ບັນທຶກ';
            saveCommentBtn.disabled = false;
        });
    });
    
    // Add click event to each edit button
    editButtons.forEach(btn => {
        btn.addEventListener('click', function(e) {
            console.log('Edit button clicked');
            e.preventDefault();
            e.stopPropagation();
            
            const customerId = this.getAttribute('data-id');
            const commentCell = this.closest('.comment-cell');
            
            if (!commentCell) {
                console.error('Comment cell not found');
                return;
            }
            
            const currentComment = commentCell.getAttribute('data-comment') || '';
            console.log('Current comment:', currentComment);
            
            openCommentModal(commentCell, customerId, currentComment);
        });
    });
    
    // Add keyboard shortcuts
    commentTextarea.addEventListener('keydown', function(e) {
        // Ctrl+Enter or Cmd+Enter to save
        if ((e.ctrlKey || e.metaKey) && e.key === 'Enter') {
            saveCommentBtn.click();
        }
        // Escape to cancel
        if (e.key === 'Escape') {
            closeCommentModal();
        }
    });
});
</script>
</body>
</html>







