<?php
file_put_contents('debug.txt', print_r($_POST, true));
session_start();
require("db_con.php");

// ปิด error display ใน production
ini_set('display_errors', 0);
error_reporting(0);

// Force HTTPS (ถ้าเซิร์ฟเวอร์รองรับ)
if (empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] === "off") {
    $redirect = 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    header('HTTP/1.1 301 Moved Permanently');
    header('Location: ' . $redirect);
    exit;
}

// ป้องกัน brute force
if (!isset($_SESSION['login_attempts'])) $_SESSION['login_attempts'] = 0;
if ($_SESSION['login_attempts'] > 5) {
    $_SESSION["error"] = htmlspecialchars("Too many failed attempts. Please try again later.");
    header("Location: index");
    exit;
}

// ตรวจสอบ request method
if ($_SERVER["REQUEST_METHOD"] != "POST") {
    $_SESSION["error"] = htmlspecialchars("Invalid request method.");
    header("Location: index");
    exit;
}

// ตรวจสอบ CSRF token
if (!isset($_POST['csrf_token']) || !isset($_SESSION['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    $_SESSION["error"] = htmlspecialchars("Invalid CSRF token.");
    header("Location: index");
    exit;
}

// ตรวจสอบ input
if (!isset($_POST["em_email"]) || !isset($_POST["password"])) {
    $_SESSION["error"] = htmlspecialchars("Please enter both email and password.");
    header("Location: index");
    exit;
}

// Validate email
$em_email = filter_var(trim($_POST['em_email']), FILTER_VALIDATE_EMAIL);
$password = $_POST['password'];

if (!$em_email || strlen($password) < 6) {
    $_SESSION["error"] = htmlspecialchars("Invalid email or password format.");
    header("Location: index");
    exit;
}

// Query SQL Command with prepared statements
$sql = "SELECT * FROM employee WHERE em_email = ?";
$stmt = $conn->prepare($sql);

if ($stmt === false) {
    $_SESSION["error"] = htmlspecialchars("Database error.");
    header("Location: index");
    exit;
}

$stmt->bind_param("s", $em_email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();

    // Verify password with the hashed password in the database
    if (password_verify($password, $row['em_pass'])) {
        // Regenerate session id to prevent session fixation
        session_regenerate_id(true);

        // Set session variables for authenticated user
        $_SESSION['id_em'] = $row['em_id'];
        $_SESSION['email_em'] = $row['em_email'];
        $_SESSION['username_em'] = $row['em_username'];
        $_SESSION['clinic_em'] = $row['em_clinic'];
        $_SESSION['position'] = $row['em_position'];
        $_SESSION['authen'] = true;

        // Reset login attempts
        $_SESSION['login_attempts'] = 0;

        // ลบ CSRF token หลัง login สำเร็จ
        unset($_SESSION['csrf_token']);

        // Redirect based on position (ไม่มี .php)
        switch($row['em_position']) {
            case 'Boss':
                header("Location: home");
                break;
            case 'Admin':
                header("Location: pos_system");
                break;
            case 'representative':
                header("Location: representative");
                break;
            default:
                header("Location: home");
                break;
        }
        exit;
    } else {
        $_SESSION['login_attempts'] += 1;
        $_SESSION["error"] = htmlspecialchars("Incorrect email or password!");
        header("Location: index");
        exit;
    }
} else {
    $_SESSION['login_attempts'] += 1;
    $_SESSION["error"] = htmlspecialchars("Incorrect email or password!");
    header("Location: index");
    exit;
}

$stmt->close();
$conn->close();
?>
