<?php
require_once("db_con.php");

// Check if updated_at column exists
$sql = "SHOW COLUMNS FROM orders LIKE 'updated_at'";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    echo "Column updated_at exists in orders table";
} else {
    echo "Column updated_at does NOT exist in orders table";
    
    // Add the column if it doesn't exist
    $sql = "ALTER TABLE orders ADD COLUMN updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP";
    if ($conn->query($sql) === TRUE) {
        echo "<br>Column updated_at added successfully";
        
        // Update existing records
        $sql = "UPDATE orders SET updated_at = created_at";
        if ($conn->query($sql) === TRUE) {
            echo "<br>Existing records updated successfully";
        } else {
            echo "<br>Error updating records: " . $conn->error;
        }
    } else {
        echo "<br>Error adding column: " . $conn->error;
    }
}

// Check a sample order to see its values
$sql = "SELECT order_id, payment_status, created_at, updated_at FROM orders LIMIT 5";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    echo "<br><br>Sample orders:<br>";
    echo "<table border='1'><tr><th>Order ID</th><th>Payment Status</th><th>Created At</th><th>Updated At</th></tr>";
    while($row = $result->fetch_assoc()) {
        echo "<tr><td>" . $row["order_id"] . "</td><td>" . $row["payment_status"] . "</td><td>" . $row["created_at"] . "</td><td>" . $row["updated_at"] . "</td></tr>";
    }
    echo "</table>";
} else {
    echo "<br>No orders found";
}

$conn->close();
?>