<?php
session_start();

// Check if the user is logged in (authen session variable is set)
if (!isset($_SESSION['authen']) || $_SESSION['authen'] !== true) {
    // If not logged in, redirect to the login page
    $_SESSION["error"] = "ກະລຸນາ ປ້ອນ email ເເລະ password ກ່ອນ!";
    header("Location: index");
    exit;
}

// Get current page (remove .php if present)
$current_page = basename($_SERVER['PHP_SELF'], '.php');
$position = isset($_SESSION['position']) ? $_SESSION['position'] : '';

// Check access permissions based on position
if ($position === 'Admin') {
    // Allow Admin to access all POS and invoice related files
    $allowed_pages = [
        'pos_system', 
        'invoice_history',
        'invoice_history_table',
        'invoice_history_pagination',
        'get_products',
        'get_categories',
        'get_invoice_details',
        'update_payment_status',
        'print_multiple_invoices',
        'print_invoice',
        'edit_invoice',
        'delete_invoice',
        'update_printed_status',
        'home'
    ];
    
    // Check if current page is in the allowed list
    if (!in_array($current_page, $allowed_pages)) {
        header("Location: pos_system");
        exit;
    }
} elseif ($position === 'representative') {
    // Allow representative to access product data
    $allowed_pages = [
        'representative',
        'get_products',
        'get_categories',
        'get_best_selling',
        'get_product',
        'get_low_stock',
        'get_sold_products',
        'best_selling',
        'home',
        'db_con'
    ];
    
    if (!in_array($current_page, $allowed_pages)) {
        header("Location: representative");
        exit;
    }
}
// Boss has access to all pages, so no additional restrictions
?>
