<?php
// Turn off all error reporting to prevent HTML output in AJAX responses
error_reporting(0);
ini_set('display_errors', 0); 
ini_set('log_errors', 0);

require_once("auth.php");
require_once("db_con.php");

// Clean any output that might have been generated
if (ob_get_level()) {
    ob_clean();
}

// Start output buffering to catch any stray output
ob_start();

// รับค่าจาก GET
$search_query = isset($_GET['search']) ? $_GET['search'] : "";
$operation_type = isset($_GET['operation_type']) ? $_GET['operation_type'] : "";
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : "";
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : "";
$page = (isset($_GET['page']) && is_numeric($_GET['page']) && $_GET['page'] > 0) ? intval($_GET['page']) : 1;
$per_page = 50;

// ตั้งค่าเริ่มต้นวันที่ถ้าไม่ได้รับจาก GET
if(empty($date_from)) {
    $date_from = date('Y-m-d') . 'T00:00';
}
if(empty($date_to)) {
    $date_to = date('Y-m-d') . 'T23:59';
}

// ตรวจสอบว่าตารางมีอยู่หรือไม่
$tables_exist = true;
$error_message = "";

// ตรวจสอบตาราง orders_history
$check_orders = "SHOW TABLES LIKE 'orders_history'";
$result_orders = mysqli_query($conn, $check_orders);
if (mysqli_num_rows($result_orders) == 0) {
    $tables_exist = false;
    $error_message .= "ตาราง orders_history ไม่มีอยู่ในฐานข้อมูล<br>";
}

// ตรวจสอบตาราง order_items_history
$check_items = "SHOW TABLES LIKE 'order_items_history'";
$result_items = mysqli_query($conn, $check_items);
if (mysqli_num_rows($result_items) == 0) {
    $tables_exist = false;
    $error_message .= "ตาราง order_items_history ไม่มีอยู่ในฐานข้อมูล<br>";
}

if (!$tables_exist) {
    echo "<tr><td colspan='14' class='no-data' style='color: red;'>";
    echo "<i class='fas fa-exclamation-triangle'></i> ຂໍ້ຜິດພາດ: $error_message";
    echo "<br><br>ກະລຸນາຕິດຕັ້ງລະບົບ Audit ກ່ອນດ້ວຍການໃຊ້ໄຟລ໌ audit_system_setup.sql";
    echo "</td></tr>";
    exit;
}

// สร้าง SQL Query - แสดงหนึ่งแถวต่อหนึ่งการแก้ไข (จัดกลุ่มตาม operation_time)
$sql = "SELECT 
    operation_time,
    operation_type,
    'orders' as table_name,
    COALESCE(operation_user, 'System') as operation_user,
    COALESCE(old_order_id, new_order_id) as order_id,
    
    -- ข้อมูลเก่า (OLD) - เอาแค่ค่าแรกในกลุ่ม
    MAX(old_order_date) as old_order_date,
    MAX(old_sale_type) as old_sale_type,
    MAX(old_customer_id) as old_customer_id,
    MAX(old_payment_status) as old_payment_status,
    MAX(old_total_amount) as old_total_amount,
    MAX(old_discount) as old_discount,
    MAX(old_deposit_amount) as old_deposit_amount,
    MAX(old_shipping_company) as old_shipping_company,
    MAX(old_shipping_branch) as old_shipping_branch,
    MAX(old_shipping_code) as old_shipping_code,
    MAX(old_store_id) as old_store_id,
    
    -- ข้อมูลใหม่ (NEW) - เอาแค่ค่าแรกในกลุ่ม
    MAX(new_order_date) as new_order_date,
    MAX(new_sale_type) as new_sale_type,
    MAX(new_customer_id) as new_customer_id,
    MAX(new_payment_status) as new_payment_status,
    MAX(new_total_amount) as new_total_amount,
    MAX(new_discount) as new_discount,
    MAX(new_deposit_amount) as new_deposit_amount,
    MAX(new_shipping_company) as new_shipping_company,
    MAX(new_shipping_branch) as new_shipping_branch,
    MAX(new_shipping_code) as new_shipping_code,
    MAX(new_store_id) as new_store_id
    
FROM orders_history 
WHERE 1=1";

$params = [];
$types = "";

// เงื่อนไขการค้นหา
if(!empty($search_query)) {
    $sql .= " AND (old_order_id LIKE ? OR new_order_id LIKE ?)";
    $params[] = "%" . $search_query . "%";
    $params[] = "%" . $search_query . "%";
    $types .= "ss";
}

// กรองตาม operation type
if(!empty($operation_type)) {
    $sql .= " AND operation_type = ?";
    $params[] = $operation_type;
    $types .= "s";
}

// กรองตามวันที่
if(!empty($date_from)) {
    $sql .= " AND operation_time >= ?";
    $params[] = str_replace('T', ' ', $date_from);
    $types .= "s";
}
if(!empty($date_to)) {
    $sql .= " AND operation_time <= ?";
    $params[] = str_replace('T', ' ', $date_to);
    $types .= "s";
}

$sql .= " ORDER BY operation_time DESC";

// เพิ่ม GROUP BY เพื่อแสดงเพียงแถวเดียวต่อการแก้ไขแต่ละครั้ง
$sql = str_replace("WHERE 1=1", "WHERE 1=1 GROUP BY operation_time, operation_type, COALESCE(old_order_id, new_order_id)", $sql);

// เพิ่ม LIMIT และ OFFSET
$offset = ($page - 1) * $per_page;
$sql .= " LIMIT ? OFFSET ?";
$params[] = $per_page;
$params[] = $offset;
$types .= "ii";

// เตรียมและประมวลผล query
try {
    $stmt = $conn->prepare($sql);
    if(!empty($params)) {
        $stmt->bind_param($types, ...$params);
    }
    $stmt->execute();
    $result = $stmt->get_result();
    
    // สร้าง <tbody>
    if ($result->num_rows > 0) {
        $count = $offset + 1;
        while($row = $result->fetch_assoc()) {
            // แสดงแถวเดียวสำหรับทุก operation type
            $operation_class = 'row-' . strtolower($row['operation_type']);
            echo '<tr class="' . $operation_class . '">';
            
            // แสดง operation type badge
            $operation_badge = 'badge-' . strtolower($row['operation_type']);
            switch($row['operation_type']) {
                case 'UPDATE':
                    $operation_text = 'ແກ້ໄຂຂໍ້ມູນ';
                    break;
                case 'INSERT':
                    $operation_text = 'ເພີ່ມຂໍ້ມູນ';
                    break;
                case 'DELETE':
                    $operation_text = 'ລົບຂໍ້ມູນ';
                    break;
                default:
                    $operation_text = $row['operation_type'];
            }
            
            // สำหรับ UPDATE ใช้ข้อมูลใหม่, สำหรับ INSERT ใช้ new_, สำหรับ DELETE ใช้ old_
            if ($row['operation_type'] == 'UPDATE' || $row['operation_type'] == 'INSERT') {
                $data_prefix = 'new_';
            } else {
                $data_prefix = 'old_';
            }
            
            // 1. ลำดับ
            echo '<td>' . $count . '</td>';
            
            // 2. ประเภทการดำเนินการ
            echo '<td><span class="status-badge ' . $operation_badge . '">' . $operation_text . '</span></td>';
            
            // 3. เลขที่ใบบิล (Order ID)
            echo '<td><strong>' . htmlspecialchars($row['order_id']) . '</strong></td>';
            
            // 4. วันที่
            echo '<td>' . date('d/m/Y H:i', strtotime($row['operation_time'])) . '</td>';
            
            // 5. ลูกค้า
            $customer_id = htmlspecialchars($row[$data_prefix . 'customer_id'] ?? '-');
            echo '<td title="' . $customer_id . '">' . (mb_strlen($customer_id) > 15 ? mb_substr($customer_id,0,12).'…' : $customer_id) . '</td>';
            
            // 6. เบอร์ติดต่อลูกค้า (จะแสดงเป็น - เพราะไม่มีข้อมูลในตาราง audit)
            echo '<td>-</td>';
            
            // 7. ร้านค้า
            $store_id = htmlspecialchars($row[$data_prefix . 'store_id'] ?? '-');
            echo '<td title="' . $store_id . '">' . (mb_strlen($store_id) > 10 ? mb_substr($store_id,0,8).'…' : $store_id) . '</td>';
            
            // 8. บริษัทขนส่ง
            $shipping_company = htmlspecialchars($row[$data_prefix . 'shipping_company'] ?? '-');
            echo '<td title="' . $shipping_company . '">' . (mb_strlen($shipping_company) > 10 ? mb_substr($shipping_company,0,8).'…' : $shipping_company) . '</td>';
            
            // 9. สาขาขนส่ง
            $shipping_branch = htmlspecialchars($row[$data_prefix . 'shipping_branch'] ?? '-');
            echo '<td title="' . $shipping_branch . '">' . (mb_strlen($shipping_branch) > 12 ? mb_substr($shipping_branch,0,10).'…' : $shipping_branch) . '</td>';
            
            // 10. ไอดีขนส่ง
            echo '<td>' . htmlspecialchars($row[$data_prefix . 'shipping_code'] ?? '-') . '</td>';
            
            // 11. สถานะการจ่าย
            $payment_status = htmlspecialchars($row[$data_prefix . 'payment_status'] ?? '-');
            echo '<td title="' . $payment_status . '">' . (mb_strlen($payment_status) > 12 ? mb_substr($payment_status,0,10).'…' : $payment_status) . '</td>';
            
            // 12. ยอดเงินรวม
            echo '<td>' . ($row[$data_prefix . 'total_amount'] ? '₭' . number_format($row[$data_prefix . 'total_amount'], 0) : '-') . '</td>';
            
            // 13. Print สำเร็จ (จะแสดงเป็น - เพราะไม่มีข้อมูลใน audit table)
            echo '<td>-</td>';
            
            // 14. จัดการ
            echo '<td class="action-buttons"><button class="view-btn" onclick="viewAuditDetails(\'' . $row['order_id'] . '\', \'' . $row['operation_type'] . '\', \'' . $row['operation_time'] . '\')"><i class="fas fa-eye"></i></button></td>';
            echo '</tr>';
            
            $count++;
        }
    } else {
        echo "<tr><td colspan='14' class='no-data'>ບໍ່ພົບຂໍ້ມູນປະຫວັດ</td></tr>";
    }
    
    $stmt->close();
    
} catch (Exception $e) {
    echo "<tr><td colspan='14' class='no-data' style='color: red;'>";
    echo "<i class='fas fa-exclamation-triangle'></i> ຂໍ້ຜິດພາດ: " . htmlspecialchars($e->getMessage());
    echo "<br><br>ກະລຸນາຕິດຕັ້ງລະບົບ Audit ກ່ອນດ້ວຍການໃຊ້ໄຟລ໌ audit_system_setup.sql";
    echo "</td></tr>";
}

// End output buffering and send content
ob_end_flush();
?>
