<?php 
require_once("auth.php"); 
require_once("db_con.php");

// ตรวจสอบการค้นหา
$search_query = "";
if(isset($_GET['search']) && !empty($_GET['search'])) {
    $search_query = $_GET['search']; 
}

// ตรวจสอบการกรองวันที่
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : "";
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : "";

// ตรวจสอบการกรอง operation type
$operation_type = isset($_GET['operation_type']) ? $_GET['operation_type'] : "";

// ถ้าไม่ได้เลือกวันที่ ให้ default เป็นวันนี้
if (empty($date_from) || empty($date_to)) {
    if (count($_GET) === 0 || (!isset($_GET['date_from']) && !isset($_GET['date_to']))) {
        $params = $_GET;
        $params['date_from'] = date('Y-m-d') . 'T00:00';
        $params['date_to'] = date('Y-m-d') . 'T23:59';
        $query = http_build_query($params);
        header("Location: audit_history_clean.php?$query");
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/invoice_history.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <title>ປະຫວັດການເປລີ່ຍນແປງຂໍ້ມູນ - ຮ້ານ Touk</title>
    <link rel="icon" type="image/png" href="/test01/favicon.png">
</head> 
<style>
    *{
        font-family: 'Noto Sans Lao';
    }
    
    /* เพิ่ม styling สำหรับการเปรียบเทียบข้อมูล */
    .row-update {
        background-color: #e3f0ff !important; /* สีฟ้าอ่อนสำหรับแก้ไขข้อมูล */
        border-left: 4px solid #007bff;
    }
    
    .row-insert {
        background-color: #d4edda !important; /* สีเขียวอ่อนสำหรับเพิ่มข้อมูล */
        border-left: 4px solid #155724;
    }
    
    .row-delete {
        background-color: #f8d7da !important; /* สีแดงอ่อนสำหรับลบข้อมูล */
        border-left: 4px solid #721c24;
    }
    
    /* เก็บ row-old และ row-new ไว้สำหรับใช้ใน modal */
    .row-old {
        background-color: #fff3cd !important; /* สีเหลืองอ่อนสำหรับข้อมูลเก่า */
        border-left: 4px solid #856404;
    }
    
    .row-new {
        background-color: #d1edff !important; /* สีฟ้าอ่อนสำหรับข้อมูลใหม่ */
        border-left: 4px solid #0c5460;
    }
    
    /* Badge styling สำหรับ operations */
    .badge-update {
        background-color: #007bff;
        color: white;
    }
    
    .badge-insert {
        background-color: #28a745;
        color: white;
    }
    
    .badge-delete {
        background-color: #dc3545;
        color: white;
    }
    
    /* เก็บ badge เก่าไว้สำหรับใช้ใน modal */
    .badge-update-old {
        background-color: #856404;
        color: white;
    }
    
    .badge-update-new {
        background-color: #0c5460;
        color: white;
    }
    
    /* รองรับ status badge ปกติ */
    .status-badge {
        padding: 4px 8px;
        border-radius: 12px;
        font-size: 0.85em;
        font-weight: 500;
        white-space: nowrap;
    }
    
    .bg-info {
        background-color: #17a2b8;
        color: white;
    }
    
    /* การปรับปรุงตาราง audit ให้เหมือน invoice table */
    .invoice-table {
        border-collapse: separate;
        border-spacing: 0;
        width: 100%;
        min-width: 1600px;
        background: #fff;
        border-radius: 16px;
        box-shadow: 0 4px 24px rgba(0,0,0,0.07);
    }
    
    .invoice-table thead th {
        position: sticky;
        top: 0;
        background: linear-gradient(90deg, #e3f0ff 0%, #f7fafc 100%);
        color: #222;
        font-weight: 700;
        font-size: 1.08em;
        padding: 12px 10px;
        border-bottom: 2px solid #ee4035;
        z-index: 2;
        text-align: left;
        white-space: nowrap;
    }
    
    .invoice-table tbody tr {
        transition: background 0.18s;
    }
    
    .invoice-table tbody tr:nth-child(even) {
        background: rgb(247, 247, 247);
    }
    
    .invoice-table tbody tr:nth-child(odd) {
        background: #fff;
    }
    
    .invoice-table tbody tr:hover {
        background: rgb(240, 248, 255) !important;
    }
    
    .invoice-table th, .invoice-table td {
        padding: 10px 12px;
        border: none;
        text-overflow: ellipsis;
        overflow: hidden;
        white-space: nowrap;
        max-width: 120px;
        vertical-align: middle;
    }
    
    .invoice-table td {
        font-size: 1em;
        color: #333;
        border-bottom: 1px solid #e6e6e6;
    }
    
    /* View button styling */
    .view-btn {
        width: 36px;
        height: 36px;
        border-radius: 8px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        color: white;
        cursor: pointer;
        transition: all 0.3s;
        border: none;
        background-color: #4a90e2;
    }
    
    .view-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.15);
    }
    
    /* ป้องกันปุ่มซ้ำ */
    .action-buttons {
        text-align: center;
        white-space: nowrap;
    }
    
    .action-buttons .view-btn:not(:first-child) {
        display: none !important;
    }
    
    /* Tooltip styling */
    .invoice-table td[title] {
        cursor: help;
        position: relative;
    }
    
    .invoice-table td[title]:hover::after {
        content: attr(title);
        position: absolute;
        left: 0;
        top: 120%;
        background: #222;
        color: #fff;
        padding: 4px 10px;
        border-radius: 6px;
        font-size: 0.98em;
        white-space: pre;
        z-index: 10;
        box-shadow: 0 2px 8px rgba(0,0,0,0.18);
    }
    
    /* No data styling */
    .no-data {
        text-align: center;
        padding: 50px;
        color: #666;
        font-style: italic;
    }
    
    /* Modal styling - expanded for better visibility */
    .modal {
        display: none;
        position: fixed;
        z-index: 25000;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        overflow: auto;
        background-color: rgba(0,0,0,0.4);
    }
    
    .modal-content {
        background-color: #fefefe;
        margin: 2% auto;
        padding: 30px;
        border: none;
        border-radius: 12px;
        width: 95%;
        max-width: 1400px;
        max-height: 90vh;
        overflow-y: auto;
        box-shadow: 0 8px 32px rgba(0,0,0,0.15);
        position: relative;
    }
    
    .close {
        color: #aaa;
        float: right;
        font-size: 32px;
        font-weight: bold;
        position: absolute;
        right: 20px;
        top: 15px;
        cursor: pointer;
        transition: color 0.3s;
    }
    
    .close:hover,
    .close:focus {
        color: #ee4035;
        text-decoration: none;
    }
    
    /* Invoice title styling in modal */
    .invoice-title {
        color: #ee4035;
        margin-bottom: 20px;
        font-size: 1.4em;
        font-weight: 600;
        border-bottom: 2px solid #ee4035;
        padding-bottom: 10px;
    }
    
    /* Invoice info styling */
    .invoice-info {
        margin-bottom: 25px;
    }
    
    .info-group {
        margin-bottom: 15px;
    }
    
    .info-group p {
        margin: 8px 0;
        font-size: 1.02em;
    }
</style>
<body>
    <?php include_once('home.php'); ?>

    <style>
        /* Ensure sidebar appears in front of other elements */
        .sidebar {
            z-index: 1100 !important;
        }
        
        .toggle-btn {
            z-index: 1101 !important;
        }
        
        .content-area {
            animation: fadeIn 0.5s ease;
            z-index: 900;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .sticky-header-wrapper {
            z-index: 950; 
        }
    </style>

    <div class="content-area">
        <div class="invoice-history-container">
            <div class="table-header">
                <h1><i class="fas fa-history"></i> ປະຫວັດການເປລີ່ຍນແປງຂໍ້ມູນ</h1>
                
                <div class="search-filter-form">
                    <div class="search-container">
                        <input type="text" id="audit-search" placeholder="ຄົ້ນຫາ Order ID..." 
                               value="<?= htmlspecialchars($search_query) ?>" style="width: 300px;">
                    </div>
                    
                    <div class="date-filter">
                        <label>ປະເພດການດຳເນີນການ:</label>
                        <select id="operation-filter" style="width: 150px;">
                            <option value="">ທຸກການດຳເນີນການ</option>
                            <option value="INSERT" <?= $operation_type == 'INSERT' ? 'selected' : '' ?>>ເພີ່ມຂໍ້ມູນ</option>
                            <option value="UPDATE" <?= $operation_type == 'UPDATE' ? 'selected' : '' ?>>ແກ້ໄຂຂໍ້ມູນ</option>
                            <option value="DELETE" <?= $operation_type == 'DELETE' ? 'selected' : '' ?>>ລົບຂໍ້ມູນ</option>
                        </select>
                        
                        <label>ຈາກວັນທີ:</label>
                        <input type="datetime-local" id="date-from" value="<?= $date_from ?>" style="width: 200px;">
                        
                        <label>ຫາວັນທີ:</label>
                        <input type="datetime-local" id="date-to" value="<?= $date_to ?>" style="width: 200px;">
                        
                        <button class="btn search-btn" onclick="filterAuditData()">
                            <i class="fas fa-search"></i> ຄົ້ນຫາ
                        </button>
                        
                        <a href="audit_history_clean.php" class="btn reset-btn">
                            <i class="fas fa-times"></i> ລ້າງຕົວກອງ
                        </a>
                    </div>
                </div>
            </div>

            <div class="table-body-container">
                <table class="invoice-table" id="audit-table">
                    <thead>
                        <tr>
                            <th>ລຳດັບ</th>
                            <th>ປະເພດການດຳເນີນການ</th>
                            <th>ເລກທີໃບບິນ</th>
                            <th>ວັນທີ</th>
                            <th>ລູກຄ້າ</th>
                            <th>ເບີຕິດຕໍ່ລູກຄ້າ</th>
                            <th>ຮ້ານຄ້າ</th>
                            <th>ບໍລິສັດຂົນສົ່ງ</th>
                            <th>ສາຂາຂົນສົ່ງ</th>
                            <th>ໄອດີຂົນສົ່ງ</th>
                            <th>ສະຖານະການຈ່າຍ</th>
                            <th>ຍອດເງິນລວມ</th>
                            <th>Print ສຳເລັດ</th>
                            <th>ຈັດການ</th>
                        </tr>
                    </thead>
                    <tbody id="audit-table-body">
                        <!-- ข้อมูลจะถูกโหลดด้วย AJAX -->
                    </tbody>
                </table>
            </div>
            
            <div class="pagination" id="pagination"></div>
        </div>
    </div>

    <!-- Modal สำหรับแสดงรายละเอียดการเปลี่ยนแปลง -->
    <div id="audit-modal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <div id="audit-details"></div>
        </div>
    </div>

    <script>
        // ตัวแปรสำหรับจัดการ pagination
        let currentPage = 1;
        
        // โหลดข้อมูลเมื่อเริ่มต้น
        document.addEventListener('DOMContentLoaded', function() {
            loadAuditData();
            
            // Modal event listeners
            const modal = document.getElementById('audit-modal');
            const closeBtn = document.querySelector('.close');
            
            closeBtn.addEventListener('click', () => modal.style.display = 'none');
            window.addEventListener('click', (event) => {
                if (event.target === modal) modal.style.display = 'none';
            });
        });
        
        // ฟังก์ชันสำหรับการกรองข้อมูล
        function filterAuditData() {
            currentPage = 1;
            loadAuditData();
        }
        
        // ฟังก์ชันโหลดข้อมูล audit - ปรับปรุงให้เรียบง่าย
        function loadAuditData(page = 1) {
            const params = new URLSearchParams({
                page: page,
                search: document.getElementById('audit-search').value,
                operation_type: document.getElementById('operation-filter').value,
                date_from: document.getElementById('date-from').value,
                date_to: document.getElementById('date-to').value
            });
            
            showLoading();
            
            fetch(`audit_history_table.php?${params}`)
                .then(response => response.text())
                .then(html => {
                    document.getElementById('audit-table-body').innerHTML = html;
                    updatePagination(page);
                })
                .catch(error => showError('ເກີດຂໍ້ຜິດພາດໃນການໂຫຼດຂໍ້ມູນ: ' + error.message));
        }
        
        // ฟังก์ชันแสดง loading
        function showLoading() {
            document.getElementById('audit-table-body').innerHTML = `
                <tr><td colspan="14" style="text-align: center; padding: 50px;">
                    <i class="fas fa-spinner fa-spin"></i> ກຳລັງໂຫຼດຂໍ້ມູນ...
                </td></tr>
            `;
        }
        
        // ฟังก์ชันแสดง error
        function showError(message) {
            document.getElementById('audit-table-body').innerHTML = `
                <tr><td colspan="14" style="text-align: center; padding: 50px; color: red;">
                    <i class="fas fa-exclamation-triangle"></i> ${message}
                </td></tr>
            `;
        }
        
        // ฟังก์ชันสำหรับ pagination - placeholder
        function updatePagination(currentPage) {
            // TODO: Implement pagination logic
            console.log('Current page:', currentPage);
        }
        
        // ฟังก์ชันแสดงรายละเอียดการเปลี่ยนแปลง - ปรับปรุงให้เรียบง่าย
        function viewAuditDetails(orderId, operationType, operationTime) {
            const modal = document.getElementById('audit-modal');
            const details = document.getElementById('audit-details');
            
            // แสดง loading
            details.innerHTML = `
                <div style="text-align: center; padding: 50px;">
                    <i class="fas fa-spinner fa-spin"></i> ກຳລັງໂຫຼດລາຍລະອຽດ...
                </div>
            `;
            modal.style.display = 'block';
            
            // โหลดข้อมูลรายละเอียด
            const url = `get_audit_details.php?order_id=${encodeURIComponent(orderId)}&operation_type=${encodeURIComponent(operationType)}&operation_time=${encodeURIComponent(operationTime)}`;
            
            fetch(url)
                .then(response => {
                    if (!response.ok) {
                        throw new Error(`HTTP error! Status: ${response.status}`);
                    }
                    return response.json();
                })
                .then(data => {
                    console.log('=== DEBUG: Audit Details Data ===');
                    console.log('Operation Type:', data.operation_type);
                    console.log('Old Data:', data.old_data);
                    console.log('New Data:', data.new_data);
                    if (data.debug_info) {
                        console.log('=== DEBUG: Raw Database Data ===');
                        console.log('Audit ID:', data.debug_info.audit_id);
                        console.log('Found Records:', data.debug_info.found_records);
                        console.log('Raw Old Shipping Code:', data.debug_info.raw_old_shipping_code);
                        console.log('Raw New Shipping Code:', data.debug_info.raw_new_shipping_code);
                        console.log('Raw Old Shipping Company:', data.debug_info.raw_old_shipping_company);
                        console.log('Raw New Shipping Company:', data.debug_info.raw_new_shipping_company);
                        console.log('Raw Old Store ID:', data.debug_info.raw_old_store_id);
                        console.log('Raw New Store ID:', data.debug_info.raw_new_store_id);
                    }
                    console.log('================================');
                    
                    if (data.success) {
                        renderAuditDetails(data);
                    } else {
                        details.innerHTML = createErrorDisplay(data.message || 'ເກີດຂໍ້ຜິດພາດທີ່ບໍ່ຮູ້ຈັກ');
                    }
                })
                .catch(error => {
                    console.error('Error loading audit details:', error);
                    details.innerHTML = createErrorDisplay('ເກີດຂໍ້ຜິດພາດໃນການໂຫຼດຂໍ້ມູນ: ' + error.message);
                });
        }
        
        // ฟังก์ชันສร้าง error display
        function createErrorDisplay(message) {
            return `
                <div style="text-align: center; padding: 50px; color: red;">
                    <i class="fas fa-exclamation-triangle"></i> ${message}
                </div>
            `;
        }
        
        // ฟังก์ชันสำหรับแสดงรายละเอียดในรูปแบบเปรียบเทียบ
        function renderAuditDetails(data) {
            const details = document.getElementById('audit-details');
            let html = '';
            
            if (data.operation_type === 'UPDATE') {
                html = `
                    <h2 class="invoice-title">ລາຍລະອຽດການແກ້ໄຂ: ${data.order_id}</h2>
                    <div class="invoice-info">
                        <div class="info-group">
                            <p><strong>ວັນທີ/ເວລາ:</strong> ${data.operation_time}</p>
                            <p><strong>ຜູ້ດຳເນີນການ:</strong> ${data.operation_user || 'System'}</p>
                            <p><strong>ຕາຕະລາງ:</strong> ${data.table_name}</p>
                        </div>
                    </div>
                    
                    <h3 style="color: #ee4035; margin: 20px 0;">ການເປຍນເເປງຂໍ້ມູນ:</h3>
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                        <div>
                            <h4 style="background: #fff3cd; padding: 10px; border-radius: 8px; color: #856404;">
                                <i class="fas fa-arrow-left"></i> ຂໍ້ມູນເກົ່າ
                            </h4>
                            ${createAuditDataDisplay(data.old_data, 'old')}
                        </div>
                        <div>
                            <h4 style="background: #d1edff; padding: 10px; border-radius: 8px; color: #0c5460;">
                                <i class="fas fa-arrow-right"></i> ຂໍ້ມູນໃໝ່
                            </h4>
                            ${createAuditDataDisplay(data.new_data, 'new')}
                        </div>
                    </div>
                    ${data.items ? createAuditItemsComparison(data.items, 'UPDATE') : ''}
                `;
            } else {
                const dataToShow = data.operation_type === 'INSERT' ? data.new_data : data.old_data;
                const bgColor = data.operation_type === 'INSERT' ? '#d4edda' : '#f8d7da';
                const textColor = data.operation_type === 'INSERT' ? '#155724' : '#721c24';
                const icon = data.operation_type === 'INSERT' ? 'plus' : 'trash';
                const title = data.operation_type === 'INSERT' ? 'ເພີ່ມຂໍ້ມູນ' : 'ລົບຂໍ້ມູນ';
                
                html = `
                    <h2 class="invoice-title">ລາຍລະອຽດການ${title}: ${data.order_id}</h2>
                    <div class="invoice-info">
                        <div class="info-group">
                            <p><strong>ວັນທີ/ເວລາ:</strong> ${data.operation_time}</p>
                            <p><strong>ຜູ້ດຳເນີນການ:</strong> ${data.operation_user || 'System'}</p>
                            <p><strong>ຕາຕະລາງ:</strong> ${data.table_name}</p>
                        </div>
                    </div>
                    
                    <div>
                        <h4 style="background: ${bgColor}; padding: 10px; border-radius: 8px; color: ${textColor};">
                            <i class="fas fa-${icon}"></i> ${title}
                        </h4>
                        ${createAuditDataDisplay(dataToShow, data.operation_type === 'INSERT' ? 'new' : 'old')}
                    </div>
                    ${data.items ? createAuditItemsTable(data.items, data.operation_type) : ''}
                `;
            }
            
            details.innerHTML = html;
        }
        
        // ฟังก์ชันสร้างการแสดงข้อมูลแบบละเอียด
        function createAuditDataDisplay(data, type) {
            if (!data) return '<p>ບໍ່ມີຂໍ້ມູນ</p>';
            
            // กำหนดสีพื้นหลังตาม type
            const bgColor = type === 'old' ? '#fff3cd' : '#d1edff';
            const borderColor = type === 'old' ? '#856404' : '#0c5460';
            
            return `
                <div style="background: #f8f9fa; padding: 20px; border-radius: 10px; margin-bottom: 15px; border-left: 4px solid ${borderColor};">
                    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 20px; margin-bottom: 20px;">
                        <div>
                            <p style="margin: 8px 0;"><strong>ວັນທີສັ່ງຊື້:</strong><br>
                                <span style="background: ${type === 'old' ? '#fff3cd' : '#d1edff'}; padding: 4px 8px; border-radius: 4px; display: inline-block; border: 1px solid ${borderColor};">
                                    ${formatDateTime(data.order_date)}
                                </span>
                            </p>
                            <p style="margin: 8px 0;"><strong>ລູກຄ້າ:</strong><br>
                                <span style="background: ${type === 'old' ? '#fff3cd' : '#d1edff'}; padding: 4px 8px; border-radius: 4px; display: inline-block; border: 1px solid ${borderColor};">
                                    ${data.customer_id || '-'}
                                </span>
                            </p>
                            <p style="margin: 8px 0;"><strong>ປະເພດການຂາຍ:</strong><br>
                                <span style="background: ${type === 'old' ? '#fff3cd' : '#d1edff'}; padding: 4px 8px; border-radius: 4px; display: inline-block; border: 1px solid ${borderColor};">
                                    ${data.sale_type || '-'}
                                </span>
                            </p>
                        </div>
                        <div>
                            <p style="margin: 8px 0;"><strong>ຮ້ານ:</strong><br>
                                <span style="background: ${type === 'old' ? '#fff3cd' : '#d1edff'}; padding: 4px 8px; border-radius: 4px; display: inline-block; border: 1px solid ${borderColor};">
                                    ${data.store_id || '-'}
                                </span>
                            </p>
                            <p style="margin: 8px 0;"><strong>ສະຖານະການຈ່າຍ:</strong><br>
                                <span style="background: ${type === 'old' ? '#fff3cd' : '#d1edff'}; padding: 4px 8px; border-radius: 4px; display: inline-block; border: 1px solid ${borderColor};">
                                    ${data.payment_status || '-'}
                                </span>
                            </p>
                            <p style="margin: 8px 0;"><strong>ວິທີການຈ່າຍ:</strong><br>
                                <span style="background: ${type === 'old' ? '#fff3cd' : '#d1edff'}; padding: 4px 8px; border-radius: 4px; display: inline-block; border: 1px solid ${borderColor};">
                                    ${data.payment_method || '-'}
                                </span>
                            </p>
                        </div>
                        <div>
                            <p style="margin: 8px 0;"><strong>ປະເພດ COD:</strong><br>
                                <span style="background: ${type === 'old' ? '#fff3cd' : '#d1edff'}; padding: 4px 8px; border-radius: 4px; display: inline-block; border: 1px solid ${borderColor};">
                                    ${data.cod_type || '-'}
                                </span>
                            </p>
                            <p style="margin: 8px 0;"><strong>ບໍລິສັດຂົນສົ່ງ:</strong><br>
                                <span style="background: ${type === 'old' ? '#fff3cd' : '#d1edff'}; padding: 4px 8px; border-radius: 4px; display: inline-block; border: 1px solid ${borderColor};">
                                    ${data.shipping_company || '-'}
                                </span>
                            </p>
                            <p style="margin: 8px 0;"><strong>ສາຂາຂົນສົ່ງ:</strong><br>
                                <span style="background: ${type === 'old' ? '#fff3cd' : '#d1edff'}; padding: 4px 8px; border-radius: 4px; display: inline-block; border: 1px solid ${borderColor};">
                                    ${data.shipping_branch || '-'}
                                </span>
                            </p>
                        </div>
                    </div>
                    
                    <div style="padding: 15px; background: ${bgColor}; border-radius: 8px; border: 1px solid ${borderColor};">
                        <h5 style="color: #ee4035; margin-bottom: 15px; font-size: 1.1em;">ຂໍ້ມູນການຈ່າຍເງິນ & ການຂົນສົ່ງ</h5>
                        <div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 15px; margin-bottom: 15px;">
                            <div style="text-align: center; padding: 10px; background: #fff; border-radius: 6px; border: 1px solid #dee2e6;">
                                <strong style="color: #28a745;">ຍອດຍ່ອຍ</strong><br>
                                <span style="font-size: 1.1em; font-weight: 600;">${formatCurrency(data.subtotal)}</span>
                            </div>
                            <div style="text-align: center; padding: 10px; background: #fff; border-radius: 6px; border: 1px solid #dee2e6;">
                                <strong style="color: #ffc107;">ສ່ວນຫຼຸດ</strong><br>
                                <span style="font-size: 1.1em; font-weight: 600;">${formatCurrency(data.discount)}</span>
                            </div>
                            <div style="text-align: center; padding: 10px; background: #fff; border-radius: 6px; border: 1px solid #dee2e6;">
                                <strong style="color: #ee4035;">ຍອດລວມ</strong><br>
                                <span style="font-size: 1.2em; font-weight: 700;">${formatCurrency(data.total_amount)}</span>
                            </div>
                            <div style="text-align: center; padding: 10px; background: #fff; border-radius: 6px; border: 1px solid #dee2e6;">
                                <strong style="color: #17a2b8;">ເງິນມັດຈຳ</strong><br>
                                <span style="font-size: 1.1em; font-weight: 600;">${formatCurrency(data.deposit_amount)}</span>
                            </div>
                        </div>
                        
                        <div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 15px;">
                            <div style="background: #fff; padding: 10px; border-radius: 6px; border: 1px solid #dee2e6;">
                                <p style="margin: 5px 0;"><strong>ເງິນທີ່ຮັບ:</strong><br>${formatCurrency(data.cash_received)}</p>
                            </div>
                            <div style="background: #fff; padding: 10px; border-radius: 6px; border: 1px solid #dee2e6;">
                                <p style="margin: 5px 0;"><strong>ເງິນທອນ:</strong><br>${formatCurrency(data.cash_change)}</p>
                            </div>
                            <div style="background: #fff; padding: 10px; border-radius: 6px; border: 1px solid #dee2e6;">
                                <p style="margin: 5px 0;"><strong>ສາຂາຂົນສົ່ງ:</strong><br>${data.shipping_branch || '-'}</p>
                            </div>
                            <div style="background: #fff; padding: 10px; border-radius: 6px; border: 1px solid #dee2e6;">
                                <p style="margin: 5px 0;"><strong>ໄອດີຂົນສົ່ງ:</strong><br>${data.shipping_code || '-'}</p>
                            </div>
                        </div>
                        
                        <div style="margin-top: 15px; padding-top: 15px; border-top: 1px solid #dee2e6; display: flex; justify-content: space-between; align-items: center;">
                            <div>
                                <strong>ສະຖານະການພິມ:</strong>
                                <span style="margin-left: 10px;">
                                    <span style="background: ${data.printed_shop ? '#28a745' : '#6c757d'}; color: white; padding: 4px 8px; border-radius: 4px; margin-right: 5px;">
                                        ຮ້ານ: ${data.printed_shop ? 'ແມ່ນ' : 'ບໍ່'}
                                    </span>
                                    <span style="background: ${data.printed_online ? '#28a745' : '#6c757d'}; color: white; padding: 4px 8px; border-radius: 4px;">
                                        ອອນລາຍ: ${data.printed_online ? 'ແມ່ນ' : 'ບໍ່'}
                                    </span>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            `;
        }
        
        // ฟังก์ชันສร้างตารางเปรียบเทียบสินค้าสำหรับ UPDATE
        function createAuditItemsComparison(items, operation_type) {
            if (!items || items.length === 0) return '';
            
            return `
                <div style="margin-top: 30px;">
                    <h3 style="color: #ee4035; margin: 20px 0;">ລາຍການສິນຄ້າ:</h3>
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                        <div>
                            <h4 style="background: #fff3cd; padding: 10px; border-radius: 8px; color: #856404;">
                                <i class="fas fa-arrow-left"></i> ສິນຄ້າເກົ່າ
                            </h4>
                            ${createItemsTable(items.map(item => item.old).filter(item => item), 'old')}
                        </div>
                        <div>
                            <h4 style="background: #d1edff; padding: 10px; border-radius: 8px; color: #0c5460;">
                                <i class="fas fa-arrow-right"></i> ສິນຄ້າໃໝ່
                            </h4>
                            ${createItemsTable(items.map(item => item.new).filter(item => item), 'new')}
                        </div>
                    </div>
                </div>
            `;
        }
        
        // ฟังก์ชันสร้างตารางสินค้าสำหรับ INSERT/DELETE
        function createAuditItemsTable(items, operation_type) {
            if (!items || items.length === 0) return '';
            
            const bgColor = operation_type === 'INSERT' ? '#d4edda' : '#f8d7da';
            const textColor = operation_type === 'INSERT' ? '#155724' : '#721c24';
            const title = operation_type === 'INSERT' ? 'ສິນຄ້າທີ່ເພີ່ມ' : 'ສິນຄ້າທີ່ລົບ';
            
            return `
                <div style="margin-top: 30px;">
                    <h4 style="background: ${bgColor}; padding: 10px; border-radius: 8px; color: ${textColor};">
                        <i class="fas fa-${operation_type === 'INSERT' ? 'plus' : 'trash'}"></i> ${title}
                    </h4>
                    ${createItemsTable(items, operation_type)}
                </div>
            `;
        }
        
        // ฟังก์ชันสร้างตารางสินค้า
        function createItemsTable(items, type) {
            if (!items || items.length === 0) {
                return '<p style="text-align: center; padding: 30px; color: #666; font-style: italic; background: #f8f9fa; border-radius: 8px;">ບໍ່ມີລາຍການສິນຄ້າ</p>';
            }
            
            return `
                <div style="background: #fff; border-radius: 10px; overflow: hidden; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
                    <table style="width: 100%; border-collapse: collapse;">
                        <thead>
                            <tr style="background: linear-gradient(90deg, #e3f0ff 0%, #f7fafc 100%);">
                                <th style="padding: 15px 12px; border: 1px solid #dee2e6; text-align: center; font-weight: 600; color: #2c3e50; width: 80px;">ລຳດັບ</th>
                                <th style="padding: 15px 12px; border: 1px solid #dee2e6; text-align: left; font-weight: 600; color: #2c3e50;">ລາຍການສິນຄ້າ</th>
                                <th style="padding: 15px 12px; border: 1px solid #dee2e6; text-align: right; font-weight: 600; color: #2c3e50; width: 120px;">ລາຄາ</th>
                                <th style="padding: 15px 12px; border: 1px solid #dee2e6; text-align: center; font-weight: 600; color: #2c3e50; width: 100px;">ຈຳນວນ</th>
                                <th style="padding: 15px 12px; border: 1px solid #dee2e6; text-align: right; font-weight: 600; color: #2c3e50; width: 140px;">ລວມ</th>
                            </tr>
                        </thead>
                        <tbody>
                            ${items.map((item, index) => `
                                <tr style="transition: background-color 0.2s; ${index % 2 === 0 ? 'background: #f8f9fa;' : 'background: #fff;'}">
                                    <td style="padding: 12px; border: 1px solid #dee2e6; text-align: center; font-weight: 500;">${index + 1}</td>
                                    <td style="padding: 12px; border: 1px solid #dee2e6;">
                                        <div style="font-weight: 500; color: #2c3e50; margin-bottom: 4px;">${item.product_name || '-'}</div>
                                        <small style="color: #6c757d; font-size: 0.9em;">Product ID: ${item.product_id || '-'}</small>
                                    </td>
                                    <td style="padding: 12px; border: 1px solid #dee2e6; text-align: right; font-weight: 500; color: #28a745;">${formatCurrency(item.price)}</td>
                                    <td style="padding: 12px; border: 1px solid #dee2e6; text-align: center; font-weight: 500;">
                                        <span style="background: #e9ecef; padding: 4px 8px; border-radius: 4px;">${item.quantity || '-'}</span>
                                    </td>
                                    <td style="padding: 12px; border: 1px solid #dee2e6; text-align: right; font-weight: 600; font-size: 1.05em; color: #ee4035;">${formatCurrency(item.total)}</td>
                                </tr>
                            `).join('')}
                        </tbody>
                    </table>
                </div>
            `;
        }
        
        // ฟังก์ชันแปลงชื่อคอลัมน์เป็นภาษาลาว
        function translateColumnName(key) {
            const translations = {
                'order_id': 'Order ID',
                'order_date': 'ວັນທີສັ່ງຊື້',
                'sale_type': 'ປະເພດການຂາຍ',
                'customer_id': 'ລູກຄ້າ',
                'customer_name': 'ຊື່ລູກຄ້າ',
                'customer_phone': 'ເບີໂທລູກຄ້າ',
                'payment_status': 'ສະຖານະການຈ່າຍ',
                'payment_method': 'ວິທີການຈ່າຍ',
                'total_amount': 'ຍອດເງິນລວມ',
                'subtotal': 'ຍອດຍ່ອຍ',
                'discount': 'ສ່ວນຫຼຸດ',
                'deposit_amount': 'ເງິນມັດຈຳ',
                'cod_type': 'ປະເພດ COD',
                'cash_received': 'ເງິນທີ່ຮັບ',
                'cash_change': 'ເງິນທອນ',
                'shipping_company': 'ບໍລິສັດຂົນສົ່ງ',
                'shipping_name': 'ຊື່ບໍລິສັດຂົນສົ່ງ',
                'shipping_branch': 'ສາຂາຂົນສົ່ງ',
                'shipping_code': 'ໄອດີຂົນສົ່ງ',
                'store_id': 'ຮ້ານ',
                'store_name': 'ຊື່ຮ້ານ',
                'product_id': 'ສິນຄ້າ',
                'product_name': 'ຊື່ສິນຄ້າ',
                'quantity': 'ຈຳນວນ',
                'price': 'ລາຄາ',
                'total': 'ລວມ',
                'printed_shop': 'ພິມຮ້ານ',
                'printed_online': 'ພິມອອນລາຍ'
            };
            return translations[key] || key;
        }
        
        // ฟังก์ชันจัดรูปแบบค่า
        function formatValue(key, value) {
            if (value === null || value === undefined || value === '') {
                return '-';
            }
            
            if (key.includes('amount') || key === 'price' || key === 'discount' || key === 'subtotal' || key === 'total' || key.includes('cash')) {
                return formatCurrency(value);
            }
            
            if (key.includes('date') && value) {
                return formatDateTime(value);
            }
            
            if (key.includes('printed')) {
                return value ? 'ແມ່ນ' : 'ບໍ່';
            }
            
            return value;
        }
        
        // ฟังก์ชันจัดรูปแบบสกุลเงิน
        function formatCurrency(value) {
            if (!value || value === 0) return '₭0';
            return '₭' + parseFloat(value).toLocaleString();
        }
        
        // ฟังก์ชันจัดรูปแบบวันที่และเวลา
        function formatDateTime(dateStr) {
            if (!dateStr) return '-';
            try {
                const date = new Date(dateStr);
                return date.toLocaleString('lo-LA', {
                    year: 'numeric',
                    month: '2-digit',
                    day: '2-digit',
                    hour: '2-digit',
                    minute: '2-digit',
                    second: '2-digit'
                });
            } catch (e) {
                return dateStr;
            }
        }
    </script>
</body>
</html>
