<?php
require_once("db_con.php");

// สร้าง store_id ให้อักษรนำหน้า 
function generateStoreID($conn) {
    $prefix = "ST"; // กำหนดอักษรนำหน้า "ST" (Store)
    
    $sql = "SELECT MAX(CAST(SUBSTRING(store_id, 3) AS UNSIGNED)) as max_num FROM stores WHERE store_id LIKE '$prefix%'";
    $result = $conn->query($sql);
    $row = $result->fetch_assoc();
    
    $next_num = 1; // ค่าเริ่มต้น
    if ($row['max_num']) {
        $next_num = $row['max_num'] + 1;
    }
    
    // สร้างใหม่โดยใช้อักษรนำหน้าและเลขลำดับ
    $new_id = $prefix . sprintf('%03d', $next_num); // เช่น ST001, ST002, ...
    
    return $new_id;
}

$alert_message = "";
$new_store_id = generateStoreID($conn); // สร้าง ID ใหม่

// เมื่อส่งฟอร์ม
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $store_name = $_POST['store_name'];
    $shop_owner_name = $_POST['shop_owner_name'];
    $store_phone = $_POST['store_phone']; // เรียกค่า store_phone
    
    // ตรวจสอบว่าส่ง store_id มา lemma ไม่ (แก้ไข)
    if(isset($_POST['store_id']) && !empty($_POST['store_id'])) {
        // แก้ไขข้อมูล
        $store_id = $_POST['store_id'];
        
        // ตรวจสอบว่าชื่อร้านซ้ำ lemma ร้านอื่น lemma ไม่
        $check_sql = "SELECT * FROM stores WHERE store_name = ? AND store_id != ?";
        $check_stmt = $conn->prepare($check_sql);
        $check_stmt->bind_param("ss", $store_name, $store_id);
        $check_stmt->execute();
        $check_result = $check_stmt->get_result();
        
        if ($check_result->num_rows > 0) {
            $alert_message = "<div class='alert error'>ຊື່ຮ້ານນີ້ມີໃນລະບົບແລ້ວ</div>";
        } else {
            $sql = "UPDATE stores SET store_name = ?, shop_owner_name = ?, store_phone = ? WHERE store_id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ssss", $store_name, $shop_owner_name, $store_phone, $store_id);
            
            if ($stmt->execute()) {
                $alert_message = "<div class='alert success'>ອັບເດດຂໍ້ມູນຮ້ານສຳເລັດແລ້ວ</div>";
            } else {
                $alert_message = "<div class='alert error'>ເກີດຂໍ້ຜິດພາດໃນການອັບເດດ: " . $stmt->error . "</div>";
            }
        }
    } else {
        // ข้อมูลใหม่
        $store_id = $new_store_id; // ใช้ ID สร้างใหม่
        $check_sql = "SELECT * FROM stores WHERE store_name = ?";
        $check_stmt = $conn->prepare($check_sql);
        $check_stmt->bind_param("s", $store_name);
        $check_stmt->execute();
        $check_result = $check_stmt->get_result();
        
        if ($check_result->num_rows > 0) {
            $alert_message = "<div class='alert error'>ຊື່ຮ້ານນີ້ມີໃນລະບົບແລ້ວ</div>";
        } else {
            $sql = "INSERT INTO stores (store_id, store_name, shop_owner_name, store_phone) VALUES (?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ssss", $store_id, $store_name, $shop_owner_name, $store_phone);
            
            if ($stmt->execute()) {
                $alert_message = "<div class='alert success'>ບັນທຶກຂໍ້ມູນຮ້ານສຳເລັດແລ້ວ</div>";
                $new_store_id = generateStoreID($conn); // สร้าง ID ใหม่
            } else {
                $alert_message = "<div class='alert error'>ເກີດຂໍ້ຜິດພາດໃນການບັນທຶກ: " . $stmt->error . "</div>";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/add_forms.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <title>ຂໍ້ມູນຊື່ຮ້ານ</title>
    <link rel="icon" type="image/png" href="/test01/favicon.png">
</head>
<style>
    *{
        font-family: 'Noto Sans Lao';
    } 
</style>
<body>
    <?php include('home.php'); ?>

    <div class="content-area">
        <div class="store-table-container">
            <div class="table-header">
                <h1><i class="fas fa-store"></i> ຂໍ້ມູນຊື່ຮ້ານ</h1>
                <div class="search-container">
                    <input type="text" id="store-search" placeholder="ຄົ້ນຫາຊື່ຮ້ານ...">
                    <button class="btn primary-btn" id="add-store-btn"><i class="fas fa-plus"></i> ເພີ່ມຊື່ຮ້ານໃໝ່</button>
                </div>
            </div>
            
            <?php 
            if (!empty($alert_message)) {
                echo $alert_message;
            }
            ?>
            
            <table class="store-table">
                <thead>
                    <tr>
                        <th>ລຳດັບ</th>
                        <th>ລະຫັດໄອດີ</th>
                        <th>ຊື່ຮ້ານ</th>
                        <th>ຊື່ເຈົ້າຂອງຮ້ານ</th>
                        <th>ເບີໂທຮ້ານ</th>
                        <th>ຈັດການ</th>
                    </tr>
                </thead>
                <tbody id="store-table-body">
                    <?php
                    $sql = "SELECT * FROM stores ORDER BY store_id ASC";
                    $result = $conn->query($sql);
                    
                    if ($result->num_rows > 0) {
                        $count = 1;
                        while($row = $result->fetch_assoc()) {
                            echo "<tr>";
                            echo "<td>" . $count . "</td>";
                            echo "<td>" . $row["store_id"] . "</td>";
                            echo "<td>" . $row["store_name"] . "</td>";
                            echo "<td>" . $row["shop_owner_name"] . "</td>";
                            echo "<td>" . $row["store_phone"] . "</td>";
                            echo "<td class='action-buttons'>
                                    <button class='edit-btn' data-id='" . $row["store_id"] . "' data-name='" . $row["store_name"] . "' data-owner='" . $row["shop_owner_name"] . "' data-phone='" . $row["store_phone"] . "'><i class='fas fa-edit'></i></button>
                                    <button class='delete-btn' data-id='" . $row["store_id"] . "'><i class='fas fa-trash'></i></button>
                                  </td>";
                            echo "</tr>";
                            $count++;
                        }
                    } else {
                        echo "<tr><td colspan='6' class='no-data'>ບໍ່ມີຂໍ້ມູນຊື່ຮ້ານ</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
    
    <!-- Modal เຟີ່ມ/แก้ไขข้อมูลร้าน -->
    <div id="store-modal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2 id="modal-title">ເພີ່ມຊື່ຮ້ານໃໝ່</h2>
            <form id="store-form" method="POST" action="">
                <input type="hidden" id="store_id" name="store_id">
                <div class="form-group">
                    <label for="store_name">ຊື່ຮ້ານ:</label>
                    <input type="text" id="store_name" name="store_name" required>
                </div>
                <div class="form-group">
                    <label for="shop_owner_name">ຊື່ເຈົ້າຂອງຮ້ານ:</label>
                    <input type="text" id="shop_owner_name" name="shop_owner_name" required>
                </div>
                <div class="form-group">
                    <label for="store_phone">ເບີໂທຮ້ານ:</label>
                    <input type="text" id="store_phone" name="store_phone">
                </div>
                <div class="form-actions" style="display: flex; justify-content: flex-end; gap: 10px;">
                    <button type="submit" class="btn primary-btn">ບັນທຶກ</button>
                    <button type="button" class="btn cancel-btn" onclick="document.getElementById('store-modal').style.display='none'">ຍົກເລີກ</button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Modalërërການລຶບ -->
    <div id="confirm-delete-modal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>ຢືນຢັນການລຶບ</h2>
            <p>ທ່ານແນ່ໃຈບໍ່ວ່າຕ້ອງການລຶບຂໍ້ມູນນີ້?</p>
            <form id="delete-form" method="POST" action="delete_store.php">
                <input type="hidden" id="delete-store-id" name="delete_store_id">
                <div class="form-buttons">
                    <button type="submit" class="btn delete-confirm-btn">ລຶບ</button>
                    <button type="button" class="btn cancel-btn" id="delete-cancel-btn">ຍົກເລີກ</button>
                </div>
            </form>
        </div>
    </div>

    <script>
    // ຢູກົວລຶບຂໍ້ມູນຮ້ານ
    function deleteStore(storeId) {
        if(confirm("ທ່ານຕ້ອງການລຶບຂໍ້ມູນຮ້ານນີ້ແທ້ບໍ?")) {
            // ใช้ Fetch API
            fetch('delete_store.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: 'delete_store_id=' + storeId
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok: ' + response.statusText);
                }
                return response.text();
            })
            .then(text => {
                console.log('Response text:', text);
                try {
                    const data = JSON.parse(text);
                    if(data.success) {
                        alert(data.message || "ລຶບຂໍ້ມູນຮ້ານສຳເລັດແລ້ວ");
                        location.reload();
                    } else {
                        alert("ເກີດຂໍ້ຜິດພາດ: " + data.message);
                    }
                } catch (e) {
                    console.error('Error parsing JSON:', e);
                    alert("ເກີດຂໍ້ຜິດພາດໃນການແປລງຂໍ້ມູນ JSON: " + e.message + "\nข้อมูลຢູກົວຢູກົວ: " + text);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert("ເກີດຂໍ້ຜິດພາດໃນການລຶບຂໍ້ມູນ: " + error.message);
            });
        }
    }

    function showModal(modal) {
        modal.style.display = "block";
        setTimeout(() => {
            modal.classList.add("show");
        }, 10);
    }
    function hideModal(modal) {
        modal.classList.remove("show");
        setTimeout(() => {
            modal.style.display = "none";
        }, 300);
    }

    document.addEventListener("DOMContentLoaded", function() {
        // ปุ่ມ: ปุ่ມເພີ່ມຮ້ານ
        const addStoreBtn = document.getElementById("add-store-btn");
        if (addStoreBtn) {
            addStoreBtn.addEventListener("click", function() {
                document.getElementById("store-form").reset();
                document.getElementById("store_id").value = "";
                document.getElementById("modal-title").textContent = "ເພີ່ມຊື່ຮ້ານໃໝ່";
                showModal(document.getElementById("store-modal"));
            });
        }
        
        // ปุ่ມ: ปุ่ມແກ້ໄຂ
        const editButtons = document.querySelectorAll(".edit-btn");
        editButtons.forEach(button => {
            button.addEventListener("click", function() {
                const storeId = this.getAttribute("data-id");
                const storeName = this.getAttribute("data-name");
                const ownerName = this.getAttribute("data-owner");
                const storePhone = this.getAttribute("data-phone");
                document.getElementById("store_id").value = storeId;
                document.getElementById("store_name").value = storeName;
                document.getElementById("shop_owner_name").value = ownerName;
                document.getElementById("store_phone").value = storePhone;
                document.getElementById("modal-title").textContent = "ແກ້ໄຂຂໍ້ມູນຮ້ານ";
                showModal(document.getElementById("store-modal"));
            });
        });
        
        // ปุ่ມ: ปุ่ມລຶບ
        const deleteButtons = document.querySelectorAll(".delete-btn");
deleteButtons.forEach(button => {
    button.addEventListener("click", function() {
        const storeId = this.getAttribute("data-id");
        Swal.fire({
            title: 'ຢືນຢັນການລຶບຮ້ານ',
            text: 'ທ່ານແນ່ໃຈບໍ່ວ່າຕ້ອງການລຶບຮ້ານນີ້?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'ຕົກລົງ',
            cancelButtonText: 'ຍົກເລີກ'
        }).then((result) => {
            if (result.isConfirmed) {
                fetch('delete_store.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: 'delete_store_id=' + storeId
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Network response was not ok: ' + response.statusText);
                    }
                    return response.text();
                })
                .then(text => {
                    try {
                        const data = JSON.parse(text);
                        if(data.success) {
                            // ลบแถวออกจากตาราง
                            button.closest('tr').remove();
                            Swal.fire('ສຳເລັດ!', data.message || "ລຶບຮ້ານສຳເລັດແລ້ວ", 'success');
                        } else {
                            Swal.fire('ຜິດພາດ', "ເກີດຂໍ້ຜິດພາດ: " + data.message, 'error');
                        }
                    } catch (e) {
                        console.error('Error parsing JSON:', e);
                        Swal.fire('ຜິດພາດ', "ເກີດຂໍ້ຜິດພາດໃນການແປລະຫວ່າງ JSON: " + e.message, 'error');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    Swal.fire('ຜິດພາດ', "ເກີດຂໍ້ຜິດພາດໃນການລຶບຂໍ້ມູນ: " + error.message, 'error');
                });
            }
        });
    });
});
        
        // ปุ่ม close ทุก modal
        const closeButtons = document.querySelectorAll(".close");
        closeButtons.forEach(btn => {
            btn.addEventListener("click", function() {
                const modal = btn.closest(".modal");
                hideModal(modal);
            });
        });
        
        // ปุ่ม cancel ใน modal
        const cancelBtns = document.querySelectorAll(".cancel-btn");
        cancelBtns.forEach(btn => {
            btn.addEventListener("click", function() {
                const modal = btn.closest(".modal");
                hideModal(modal);
            });
        });
        
        // ปิด modal เมื่อคลิกนอก modal-content
        const modals = document.querySelectorAll(".modal");
        modals.forEach(modal => {
            window.addEventListener("click", function(event) {
                if (event.target == modal) {
                    hideModal(modal);
                }
            });
        });
        
        // ค้นหาร້ານ
const storeSearch = document.getElementById("store-search");
if (storeSearch) {
    storeSearch.addEventListener("keyup", function() {
        const searchValue = this.value.toLowerCase();
        const tableRows = document.querySelectorAll("#store-table-body tr");
        let visibleCount = 0;

        tableRows.forEach(row => {
            // ข้ามแถว "no data" ถ้ามี
            if (row.id === 'no-data-row') return;
            const storeName = row.cells[2].textContent.toLowerCase();
            if(storeName.includes(searchValue)) {
                row.style.display = "";
                visibleCount++;
            } else {
                row.style.display = "none";
            }
        });

        // ลบแถว "no data" เดิมถ้ามี
        let noDataRow = document.getElementById('no-data-row');
        if (noDataRow) noDataRow.remove();

        // ถ้าไม่พบข้อมูล ให้เพิ่มแถว "ບໍ່ພົບສິນຄ້າ"
        if (visibleCount === 0) {
            const tbody = document.getElementById('store-table-body');
            const tr = document.createElement('tr');
            tr.id = 'no-data-row';
            const td = document.createElement('td');
            td.colSpan = 6;
            td.style.textAlign = 'center';
            td.textContent = 'ບໍ່ພົບສິນຄ້າ';
            tr.appendChild(td);
            tbody.appendChild(tr);
        }
    });
}
    });
    </script>
</body>
</html>























