<?php
require_once("auth.php");
require_once("db_con.php");

// Function to generate shipping ID
function generateShippingID($conn) {
    $sql = "SELECT MAX(CAST(SUBSTRING(shipping_id, 5) AS UNSIGNED)) as max_id FROM shipping_company WHERE shipping_id LIKE 'SHP%'";
    $result = $conn->query($sql);
    $row = $result->fetch_assoc(); 
    
    $next_id = 1;
    if ($row['max_id']) {
        $next_id = $row['max_id'] + 1;
    }
    
    return 'SHP' . sprintf('%03d', $next_id);
}

$new_shipping_id = generateShippingID($conn);
$alert_message = "";

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['shipping_name'])) {
    $shipping_id = $_POST['shipping_id'];
    $shipping_name = $_POST['shipping_name'];
    
    $check_sql = "SELECT * FROM shipping_company WHERE shipping_id = ?";
    $check_stmt = $conn->prepare($check_sql);
    $check_stmt->bind_param("s", $shipping_id);
    $check_stmt->execute();
    $check_result = $check_stmt->get_result();
    
    if ($check_result->num_rows > 0) {
        $sql = "UPDATE shipping_company SET shipping_name = ? WHERE shipping_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ss", $shipping_name, $shipping_id);
        
        if ($stmt->execute()) {
            $alert_message = "<div class='alert success'>ອັບເດດຂໍ້ມູນບໍລິສັດຂົນສົ່ງສຳເລັດແລ້ວ</div>";
        } else {
            $alert_message = "<div class='alert error'>ເກີດຂໍ້ຜິດພາດໃນການອັບເດດ: " . $stmt->error . "</div>";
        }
    } else {
        $sql = "INSERT INTO shipping_company (shipping_id, shipping_name) VALUES (?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ss", $shipping_id, $shipping_name);
        
        if ($stmt->execute()) {
            $alert_message = "<div class='alert success'>ບັນທຶກຂໍ້ມູນບໍລິສັດຂົນສົ່ງສຳເລັດແລ້ວ</div>";
        } else {
            $alert_message = "<div class='alert error'>ເກີດຂໍ້ຜິດພາດໃນການບັນທຶກ: " . $stmt->error . "</div>";
        }
    }
    
    $new_shipping_id = generateShippingID($conn);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/add_shipping.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <title>ຂໍ້ມູນບໍລິສັດຂົນສົ່ງ</title>
    <link rel="icon" type="image/png" href="/test01/favicon.png">
</head> 
<style>
    *{
        font-family: 'Noto Sans Lao'; 
    }
</style>
<body>
    <?php include_once('home.php'); ?>

    <div class="content-area">
        <div class="shipping-table-container">
            <div class="table-header">
                <h1><i class="fas fa-truck"></i> ຂໍ້ມູນບໍລິສັດຂົນສົ່ງ</h1>
                <div class="search-container">
                    <input type="text" id="shipping-search" placeholder="ຄົ້ນຫາບໍລິສັດຂົນສົ່ງ...">
                    <button class="btn primary-btn" id="add-shipping-btn"><i class="fas fa-plus"></i> ເພີ່ມບໍລິສັດຂົນສົ່ງໃໝ່</button>
                </div>
            </div>
            
            <?php 
            if (!empty($alert_message)) {
                echo $alert_message;
            }
            ?>
            
            <table class="category-table">
                <thead>
                    <tr>
                        <th>ລຳດັບ</th>
                        <th>ລະຫັດໄອດີ</th>
                        <th>ຊື່ບໍລິສັດຂົນສົ່ງ</th>
                        <th>ຈັດການ</th>
                    </tr>
                </thead>
                <tbody id="category-table-body">
                    <?php
                    $sql = "SELECT * FROM shipping_company ORDER BY shipping_id ASC";
                    $result = $conn->query($sql);
                    
                    if ($result->num_rows > 0) {
                        $counter = 1;
                        while($row = $result->fetch_assoc()) {
                            echo "<tr data-id='".$row['shipping_id']."'>";
                            echo "<td>" . $counter . "</td>";
                            echo "<td>" . $row['shipping_id'] . "</td>";
                            echo "<td>" . $row['shipping_name'] . "</td>";
                            echo "<td class='action-buttons'>";
                            echo "<button class='edit-btn' data-id='".$row['shipping_id']."' data-name='".$row['shipping_name']."'><i class='fas fa-edit'></i></button>";
                            echo "<button class='delete-btn' data-id='".$row['shipping_id']."'><i class='fas fa-trash'></i></button>";
                            echo "</td>";
                            echo "</tr>";
                            $counter++;
                        }
                    } else {
                        echo "<tr><td colspan='4' style='text-align:center'>ບໍ່ພົບຂໍ້ມູນບໍລິສັດຂົນສົ່ງ</td></tr>";
                    }
                    ?>
                </tbody> 
            </table> 
        </div>
    </div>

    <input type="hidden" id="new_shipping_id" value="<?php echo $new_shipping_id; ?>">

    <div id="shippingModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2 class="modal-title"><i class="fas fa-truck"></i> ເພີ່ມຂໍ້ມູນບໍລິສັດຂົນສົ່ງ</h2>
            
            <form method="post" action="">
                <div class="form-grid">
                    <div class="form-group">
                        <label for="shipping_id">ລະຫັດບໍລິສັດຂົນສົ່ງ</label>
                        <input type="text" id="shipping_id" name="shipping_id" value="<?php echo $new_shipping_id; ?>" readonly>
                    </div>
                    
                    <div class="form-group">
                        <label for="shipping_name">ຊື່ບໍລິສັດຂົນສົ່ງ</label>
                        <input type="text" id="shipping_name" name="shipping_name" required>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="reset" class="btn secondary-btn"><i class="fas fa-undo"></i> ລ້າງຂໍ້ມູນ</button>
                    <button type="submit" class="btn primary-btn"><i class="fas fa-save"></i> ບັນທຶກຂໍ້ມູນ</button>
                </div>
            </form>
        </div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Modal functionality
        const modal = document.getElementById("shippingModal");
        const addBtn = document.getElementById("add-shipping-btn");
        const closeBtn = document.getElementsByClassName("close")[0];

        function showModal() {
            modal.style.display = "block";
            setTimeout(() => {
                modal.classList.add("show");
            }, 10);
        }

        function hideModal() {
            modal.classList.remove("show");
            setTimeout(() => {
                modal.style.display = "none";
            }, 300);
        }

        // Open modal when add button is clicked
        addBtn.onclick = function() {
            showModal();
            document.querySelector('.modal-title').innerHTML = '<i class="fas fa-truck"></i> ເພີ່ມຂໍ້ມູນບໍລິສັດຂົນສົ່ງ';
            document.querySelector('form').reset();
            document.getElementById('shipping_id').value = document.getElementById('new_shipping_id').value;
            document.getElementById('shipping_name').value = '';
        }

        // Close modal when X is clicked
        if (closeBtn) {
            closeBtn.onclick = function() {
                hideModal();
            }
        }

        // Close modal when clicking outside
        window.onclick = function(event) {
            if (event.target == modal) {
                hideModal();
            }
        }
        
        // Edit button functionality
        const editButtons = document.querySelectorAll('.edit-btn');
        editButtons.forEach(button => {
            button.addEventListener('click', function() {
                const shippingId = this.getAttribute('data-id');
                const shippingName = this.getAttribute('data-name');
                document.querySelector('.modal-title').innerHTML = '<i class="fas fa-edit"></i> ແກ້ໄຂຂໍ້ມູນບໍລິສັດຂົນສົ່ງ';
                document.getElementById('shipping_id').value = shippingId;
                document.getElementById('shipping_name').value = shippingName;
                showModal();
            });
        });
        
        // Delete button functionality

const deleteButtons = document.querySelectorAll('.delete-btn');
deleteButtons.forEach(button => {
    button.addEventListener('click', function() {
        const shippingId = this.getAttribute('data-id');
        Swal.fire({
            title: 'ຢືນຢັນການລຶບປະເພດສິນຄ້າ',
            text: 'ທ່ານແນ່ໃຈບໍ່ວ່າຕ້ອງການລຶບປະເພດສິນຄ້ານີ້?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'ຕົກລົງ',
            cancelButtonText: 'ຍົກເລີກ'
        }).then((result) => {
            if (result.isConfirmed) {
                fetch('delete_shipping', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: 'id=' + encodeURIComponent(shippingId)
                })
                .then(response => {
                    const contentType = response.headers.get('content-type');
                    if (contentType && contentType.includes('application/json')) {
                        return response.json();
                    } else {
                        throw new Error('ไม่ได้รับข้อมูล JSON จากเซิร์ฟเวอร์');
                    }
                })
                .then(data => {
                    if (data.success) {
                        const row = button.closest('tr');
                        row.remove();
                        Swal.fire('ສຳເລັດ!', 'ລຶບປະເພດສິນຄ້າສຳເລັດແລ້ວ', 'success');
                    } else {
                        Swal.fire('ຜິດພາດ', 'ເກີດຂໍ້ຜິດພາດ: ' + data.message, 'error');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    Swal.fire('ຜິດພາດ', 'ເກີດຂໍ້ຜິດພາດໃນການລຶບຂໍ້ມູນ: ' + error.message, 'error');
                });
            }
        });
    });
});
        
        // Search functionality

// ...existing code...
const searchInput = document.getElementById('shipping-search');
searchInput.addEventListener('keyup', function() {
    const searchValue = this.value.toLowerCase();
    const rows = document.querySelectorAll('#category-table-body tr');
    let visibleCount = 0;

    rows.forEach(row => {
        if (row.id === 'no-data-row') return;
        const shippingName = row.cells[2].textContent.toLowerCase();
        const shippingId = row.cells[1].textContent.toLowerCase();

        if (shippingName.includes(searchValue) || shippingId.includes(searchValue)) {
            row.style.display = '';
            visibleCount++;
        } else {
            row.style.display = 'none';
        }
    });

    // ลบแถว "no data" เดิมถ้ามี
    let noDataRow = document.getElementById('no-data-row');
    if (noDataRow) noDataRow.remove();

    // ถ้าไม่พบข้อมูล ให้เพิ่มแถว "ບໍ່ພົບສິນຄ້າ"
    if (visibleCount === 0) {
        const tbody = document.getElementById('category-table-body');
        const tr = document.createElement('tr');
        tr.id = 'no-data-row';
        const td = document.createElement('td');
        td.colSpan = 4;
        td.style.textAlign = 'center';
        td.textContent = 'ບໍ່ພົບສິນຄ້າ';
        tr.appendChild(td);
        tbody.appendChild(tr);
    }
});
// ...existing code...

    });
    </script>
</body>
</html>

