<?php require_once("auth.php"); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/add_product.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <link rel="icon" type="image/png" href="/test01/favicon.png">
    <title>ຂໍ້ມູນສິນຄ້າ - ຮ້ານ Jຕຸກຂາຍເຄື່ອງໃຊ້ໄຟຟ້າ</title>
</head>
<style>
    *{
        font-family: 'Noto Sans Lao';
    }
</style>
<body>
    <?php include_once('home.php'); ?>

    <div class="content-area">
        <div class="product-table-container">
            <div class="table-header">
                <h1><i class="fas fa-box"></i> ຂໍ້ມູນສິນຄ້າ</h1>
                <div class="search-container">
                    <input type="text" id="product-search" placeholder="ຄົ້ນຫາສິນຄ້າ...">
                    <button class="btn primary-btn" id="add-product-btn"><i class="fas fa-plus"></i> ເພີ່ມສິນຄ້າໃໝ່</button>
                </div>
            </div>
            
            <?php
            // เชื่อมต่อฐานข้อมูล
            require_once("db_con.php");
            
            // สร้างລະຫັດສິນຄ້າ
            function generateProductID($conn) {
                $sql = "SELECT MAX(CAST(SUBSTRING(pro_id, 5) AS UNSIGNED)) as max_id FROM products WHERE pro_id LIKE 'Pro_%'";
                $result = $conn->query($sql);
                $row = $result->fetch_assoc();
                
                $next_id = 1; // ค่าเริ่มต้น
                if ($row['max_id']) {
                    $next_id = $row['max_id'] + 1;
                }
                
                $new_id = 'Pro_' . sprintf('%03d', $next_id);
                
                // ตรวจสอบว่ารหัสนี้<lemma>อยู่แล้ว<lemma>ไม่
                $check_sql = "SELECT COUNT(*) as count FROM products WHERE pro_id = ?";
                $stmt = $conn->prepare($check_sql);
                $stmt->bind_param("s", $new_id);
                $stmt->execute();
                $check_result = $stmt->get_result();
                $check_row = $check_result->fetch_assoc();
                
                // ถ้า<lemma>รหัสนี้อยู่แล้ว ให้<lemma>่มไป<lemma> 1
                if ($check_row['count'] > 0) {
                    $next_id++;
                    $new_id = 'Pro_' . sprintf('%03d', $next_id);
                }
                
                return $new_id;
            }
            
            $new_pro_id = generateProductID($conn);
            
            // ตรวจสอบการส่งฟอร์ม
            if ($_SERVER["REQUEST_METHOD"] == "POST") {
                //  MessageLookupจากฟอร์ม
                $pro_id = $_POST['pro_id'];
                $product_type = $_POST['product_type'];
                $category_id = $_POST['category_id']; // เปลี่ยนจาก product_category เป็น category_id
                $product_name = $_POST['product_name'];
                $quantity = $_POST['quantity'];
                $cost_price = $_POST['cost_price'];
                $selling_price = $_POST['selling_price'];
                $supplier_phone = $_POST['supplier_phone'];
                
                // ตรวจสอบสถานะ<lemma>ค้าใกล้หมด
                $low_stock_status = ($quantity <= 20) ? 1 : 0;
                
                //  MessageLookup
                $product_image = "";
                $update_image = false;
                
                if(isset($_FILES['product_image']) && $_FILES['product_image']['error'] == 0) {
                    $target_dir = "img/products/";
                    
                    // สร้างโฟลเดอร์ถ้าไม่
                    if (!file_exists($target_dir)) {
                        mkdir($target_dir, 0777, true);
                    }
                    
                    $file_extension = pathinfo($_FILES["product_image"]["name"], PATHINFO_EXTENSION);
                    $new_filename = $pro_id . "_" . time() . "." . $file_extension;
                    $target_file = $target_dir . $new_filename;
                    
                    // ตรวจสอบว่าเป็นไฟล์ภาพ MessageLookup
                    $check = getimagesize($_FILES["product_image"]["tmp_name"]);
                    if($check !== false) {
                        // ย้ายไฟล์ MessageLookupไปโฟลเดอร์ปลายทาง
                        if (move_uploaded_file($_FILES["product_image"]["tmp_name"], $target_file)) {
                            $product_image = $new_filename;
                            $update_image = true;
                        }
                    }
                }
                
                // ตรวจสอบว่า<lemma><lemma>ค้านี้อยู่แล้ว<lemma>ไม่ (เพื่อ<lemma>ว่าจะ INSERT<lemma> UPDATE)
                $check_sql = "SELECT * FROM products WHERE pro_id = ?";
                $check_stmt = $conn->prepare($check_sql);
                $check_stmt->bind_param("s", $pro_id);
                $check_stmt->execute();
                $check_result = $check_stmt->get_result();
                
                if ($check_result->num_rows > 0) {
                    // ถ้า<lemma>รหัสนี้อยู่แล้ว ให้อัปเดตข้อมูล
                    $product_data = $check_result->fetch_assoc();
                    
                    // ถ้าไม่ได้อัปโหลด<lemma>ภาพใหม่ ให้ใช้<lemma>ภาพ
                    if (!$update_image) {
                        $product_image = $product_data['product_image'];
                    } else {
                        // ลบรูปภาพเก่าถ้า<lemma>ปโหลด<lemma>ใหม่
                        if (!empty($product_data['product_image'])) {
                            $old_image_path = "img/products/" . $product_data['product_image'];
                            if (file_exists($old_image_path)) {
                                unlink($old_image_path);
                            }
                        }
                    }
                    
                    //  MessageLookup
                    $sql = "UPDATE products SET 
                            product_type = ?, 
                            category_id = ?, 
                            product_name = ?, 
                            quantity = ?, 
                            cost_price = ?, 
                            selling_price = ?, 
                            product_image = ?, 
                            low_stock_status = ?, 
                            supplier_phone = ? 
                            WHERE pro_id = ?";
                    
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("sssiddsiss", 
                                    $product_type, 
                                    $category_id, 
                                    $product_name, 
                                    $quantity, 
                                    $cost_price, 
                                    $selling_price, 
                                    $product_image, 
                                    $low_stock_status, 
                                    $supplier_phone,
                                    $pro_id);
                    
                    if ($stmt->execute()) {
                        echo "<div class='alert success'>ອັບເດດຂໍ້ມູນສິນຄ້າສຳເລັດແລ້ວ</div>";
                        echo "<script>
                                setTimeout(function() {
                                    scrollToProduct('".$pro_id."');
                                }, 500);
                              </script>";
                    } else {
                        echo "<div class='alert error'>ເກີດຂໍ້ຜິດພາດໃນການອັບເດດ: " . $stmt->error . "</div>";
                    }
                } else {
                    // ถ้าไม่<lemma>รหัสนี้ ให้ບັນທຶກ<lemma>ข้อมูลใหม่
                    $sql = "INSERT INTO products (pro_id, product_type, category_id, product_name, 
                            quantity, cost_price, selling_price, product_image, low_stock_status, supplier_phone) 
                            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("ssssiddsis", $pro_id, $product_type, $category_id, $product_name, 
                                    $quantity, $cost_price, $selling_price, $product_image, $low_stock_status, $supplier_phone);
                    
                    if ($stmt->execute()) {
                        echo "<div class='alert success'>ບັນທຶກຂໍ້ມູນສິນຄ້າສຳເລັດແລ້ວ</div>";
                        echo "<script>
                                setTimeout(function() {
                                    scrollToProduct('".$pro_id."');
                                }, 500);
                              </script>";
                    } else {
                        echo "<div class='alert error'>ເກີດຂໍ້ຜິດພາດໃນການບັນທຶກ: " . $stmt->error . "</div>";
                    }
                }
                
                // สร้าง MessageLookupค้าใหม่
                $new_pro_id = generateProductID($conn);
                
                $stmt->close();
                $check_stmt->close();
            }
            
            //  MessageLookupประเภท MessageLookupค้าจากฐานข้อมูล
            $categories = array();
            $sql = "SELECT * FROM product_category ORDER BY category_name";
            $result = $conn->query($sql);
            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    $categories[] = $row;
                }
            }
            ?>
            
            <!-- ตารางแสดงข้อมูล MessageLookupค้า -->
            <table class="product-table">
                <thead>
                    <tr>
                        <th>ລຳດັບ</th>
                        <th>ລະຫັດສິນຄ້າ</th>
                        <th>ຮູບສິນຄ້າ</th>
                        <th>ຊື່ສິນຄ້າ</th>
                        <th>ປະເພດສິນຄ້າຂາຍ</th>
                        <th>ປະເພດເຄື່ອງສິນຄ້າ</th>
                        <th>ຈໍານວນ</th>
                        <th>ລາຄາຕົ້ນທຶນ</th>
                        <th>ລາຄາຂາຍ</th>
                        <th>ເບີຮ້ານທີ່ສັ່ງ</th>
                        <!-- <th>ສະຖານະ</th> -->
                        <th>ການຈັດການ</th>
                        
                    </tr>
                </thead>
                <tbody id="product-table-body">
                    <?php
                    //  MessageLookup MessageLookupค้า<|im_start|>้งหมด โดย<|im_start|>้งตาม pro_id แบบ ASC (เก่าไปใหม่)
                    $sql = "SELECT p.*, pc.category_name 
                            FROM products p 
                            LEFT JOIN product_category pc ON p.category_id = pc.category_id 
                            ORDER BY p.pro_id ASC";
                    $result = $conn->query($sql);

                    if ($result->num_rows > 0) {
                        $sequence = 1; // เพิ่มตัวแปรลำดับ
                        while($row = $result->fetch_assoc()) {
                            // กำหนดสถานะ MessageLookupค้าตามจำนวน
                            if ($row['quantity'] <= 0) {
                                $status_class = 'out-of-stock'; // MessageLookupค้าหมด
                                $status_text = 'ສິນຄ້າໝົດ';
                                $status_icon = 'fa-times-circle';
                            } else if ($row['quantity'] <= 20) {
                                $status_class = 'low-stock'; // MessageLookupค้าใกล้หมด
                                $status_text = 'ສິນຄ້າໃກ້ຈະໝົດ';
                                $status_icon = 'fa-exclamation-triangle';
                            } else {
                                $status_class = 'normal-stock'; // MessageLookupค้า
                                $status_text = 'ມີສິນຄ້າ';
                                $status_icon = 'fa-check-circle';
                            }
                            
                            echo "<tr data-id='".$row['pro_id']."'>";
                            echo "<td>".$sequence."</td>"; // เพิ่มลำดับ
                            echo "<td>".$row['pro_id']."</td>";
                            
                            // ตรวจสอบรูปภาพ ถ้าไม่มีให้ใช้รูป default
                            $image_src = !empty($row['product_image']) ? 'img/products/'.$row['product_image'] : 'img/Logo.png';
                            echo "<td><img src='".$image_src."' alt='".$row['product_name']."' width='50' onerror=\"this.src='img/Logo.png'\"></td>";
                            
                            echo "<td>".$row['product_name']."</td>";

                            echo "<td>".$row['product_type']."</td>";

                            echo "<td>".$row['category_name']."</td>";

                            echo "<td>".$row['quantity']."</td>";

                            echo "<td>₭".number_format($row['cost_price'], 0)."</td>";

                            echo "<td>₭".number_format($row['selling_price'], 0)."</td>";

                            echo "<td>".$row['supplier_phone']."</td>";

                            echo "<td class='".$status_class."'><i class='fas ".$status_icon."'></i> ".$status_text."</td>";

                            echo "<td class='action-buttons'>";
                            echo "<button class='edit-btn' data-id='".$row['pro_id']."' onclick='editProduct(\"".$row['pro_id']."\");'><i class='fas fa-edit'></i></button>";
                            echo "<button class='delete-btn' data-id='".$row['pro_id']."'><i class='fas fa-trash'></i></button>";
                            echo "</td>";

                            echo "</tr>";
                            
                            $sequence++; // เพิ่มลำดับไปอีก 1
                        }
                    } else {
                        echo "<tr><td colspan='12' style='text-align:center'>ບໍ່ພົບຂໍ້ມູນສິນຄ້າ</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal MessageLookupค้า -->
    <!-- เรื่อง hidden input เก็บค้าใหม่ -->
    <input type="hidden" id="new_pro_id" value="<?php echo $new_pro_id; ?>">

    <div id="productModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2 class="modal-title"><i class="fas fa-box"></i> ເພີ່ມຂໍ້ມູນສິນຄ້າ</h2>
            
            <form method="post" action="" enctype="multipart/form-data">
                <div class="form-grid">
                    <div class="form-group">
                        <label for="pro_id">ລະຫັດສິນຄ້າ</label>
                        <input type="text" id="pro_id" name="pro_id" value="<?php echo $new_pro_id; ?>" readonly>
                        <small class="form-text">ສະຖານະສິນຄ້າ: <span id="stockStatusText">ປົກກະຕິ</span></small>
                    </div>
                    
                    <div class="form-group">
                        <label for="product_type">ປະເພດສິນຄ້າຂາຍ</label>
                        <select id="product_type" name="product_type" required>
                            <option value="">ເລືອກປະເພດສິນຄ້າຂາຍ</option>
                            <option value="ສິນຄ້າທົ່ວໄປ">ສິນຄ້າທົ່ວໄປ (ສິນຄ້າ)</option>
                            <option value="ສິນຄ້າຕົວແທນ">ສິນຄ້າຕົວແທນ (ສິນຄ້າ)</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="product_category">ປະເພດເຄື່ອງສິນຄ້າ</label>
                        <select id="product_category" name="category_id" required>
                            <option value="">ເລືອກປະເພດເຄື່ອງສິນຄ້າ</option>
                            <?php foreach($categories as $category): ?>
                                <option value="<?php echo $category['category_id']; ?>"><?php echo $category['category_name']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="product_name">ຊື່ສິນຄ້າ</label>
                        <input type="text" id="product_name" name="product_name" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="quantity">ຈໍານວນ</label>
                        <input type="number" id="quantity" name="quantity" min="0" required>
                        <small class="form-text">ຫາກຈຳນວນນ້ອຍກວ່າ 20 ຈະຕັ້ງເປັນຄ່າໃກ້ໝົດ</small>
                    </div>
                    
                    <div class="form-group">
                        <label for="cost_price">ລາຄາຕົ້ນທຶນ (₭)</label>
                        <input type="number" id="cost_price" name="cost_price" min="0" step="0.01" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="selling_price">ລາຄາຂາຍ (₭)</label>
                        <input type="number" id="selling_price" name="selling_price" min="0" step="0.01" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="supplier_phone">ເບີຮ້ານທີ່ສັ່ງ</label>
                        <input type="text" id="supplier_phone" name="supplier_phone">
                    </div> 
                    
                    <div class="form-group low-stock-indicator">
                        <label for="stockStatus">ສະຖານະສິນຄ້າ</label>
                        <div class="stock-status" id="stockStatus">
                            <i class="fas fa-check-circle"></i>
                            <span>ສະຖານະສິນຄ້າ: <span id="stockStatusText">ມີສິນຄ້າ</span></span>
                        </div>
                    </div>
                    
                    <div class="form-group full-width">
                        <label for="product_image">ຮູບສິນຄ້າ</label>
                        <input type="file" id="product_image" name="product_image" accept="image/*">
                        <div class="image-preview" id="imagePreview">
                            <img src="" alt="ຕົວຢ່າງຮູບພາບ" class="preview-image">
                            <span class="preview-text">ກະລຸນາເລືອກຮູບພາບ</span>
                        </div>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="reset" class="btn secondary-btn"><i class="fas fa-undo"></i> ລ້າງຂໍ້ມູນ</button>
                    <button type="submit" class="btn primary-btn"><i class="fas fa-save"></i> ບັນທຶກຂໍ້ມູນ</button>
                </div>
            </form>
        </div>
    </div>

    <!-- เรียกใช้ไฟล์ JavaScript แยกออกมา -->
    <script src="js/product.js"></script>
</body>
</html>





































