<?php
require_once("auth.php");
require_once("db_con.php");

// ໍ້າ: ກັບສະຫຼັດ 
function generateCategoryID($conn) {
    $sql = "SELECT MAX(CAST(SUBSTRING(category_id, 4) AS UNSIGNED)) as max_id FROM product_category WHERE category_id LIKE 'CAT%'";
    $result = $conn->query($sql);
    $row = $result->fetch_assoc();
    
    $next_id = 1;
    if ($row['max_id']) {
        $next_id = $row['max_id'] + 1;
    }
    
    return 'CAT' . sprintf('%03d', $next_id);
}

// ย้าย code การแสดง alert ออกจากตรง
$new_category_id = generateCategoryID($conn);
$alert_message = "";

// ໍ້າ: ກັບສະຫຼັດ
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['category_name'])) {
    $category_id = $_POST['category_id'];
    $category_name = $_POST['category_name'];
    
    // ໍ້າ: ກັບສະຫຼັດ
    $check_sql = "SELECT * FROM product_category WHERE category_id = ?";
    $check_stmt = $conn->prepare($check_sql);
    $check_stmt->bind_param("s", $category_id);
    $check_stmt->execute();
    $check_result = $check_stmt->get_result();
    
    if ($check_result->num_rows > 0) {
        // ໍ້າ: ກັບສະຫຼັດ
        $sql = "UPDATE product_category SET category_name = ? WHERE category_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ss", $category_name, $category_id);
        
        if ($stmt->execute()) {
            $alert_message = "<div class='alert success'>ອັບເດດຂໍ້ມູນປະເພດສິນຄ້າສຳເລັດແລ້ວ</div>";
        } else {
            $alert_message = "<div class='alert error'>ເກີດຂໍ້ຜິດພາດໃນການອັບເດດ: " . $stmt->error . "</div>";
        }
    } else {
        // ໍ້າ: ກັບສະຫຼັດ
        $sql = "INSERT INTO product_category (category_id, category_name) VALUES (?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ss", $category_id, $category_name);
        
        if ($stmt->execute()) {
            $alert_message = "<div class='alert success'>ບັນທຶກຂໍ້ມູນປະເພດສິນຄ້າສຳເລັດແລ້ວ</div>";
        } else {
            $alert_message = "<div class='alert error'>ເກີດຂໍ້ຜິດພາດໃນການບັນທຶກ: " . $stmt->error . "</div>";
        }
    }
    
    // ໍ້າ: ກັບສະຫຼັດ
    $new_category_id = generateCategoryID($conn);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="css/add_category.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">
    <title>ຂໍ້ມູນປະເພດສິນຄ້າ</title>
    <link rel="icon" type="image/png" href="/test01/favicon.png">
</head>

<body> 
    <?php include_once('home.php'); ?>
 
    <div class="content-area">
        <div class="category-table-container">
            <div class="table-header">
                <h1><i class="fas fa-tags"></i> ຂໍ້ມູນປະເພດສິນຄ້າ</h1>
                <div class="search-container">
                    <input type="text" id="category-search" placeholder="ຄົ້ນຫາປະເພດສິນຄ້າ...">
                    <button class="btn primary-btn" id="add-category-btn"><i class="fas fa-plus"></i> ເພີ່ມປະເພດສິນຄ້າໃໝ່</button>
                </div>
            </div>
            
            <?php 
            // แสดง alert message ตรง
            if (!empty($alert_message)) {
                echo $alert_message;
            }
            ?>
            
            <table class="category-table">
                <thead>
                    <tr>
                        <th>ລຳດັບ</th>
                        <th>ລະຫັດໄອດີ</th>
                        <th>ຊື່ປະເພດສິນຄ້າ</th>
                        <th>ຈັດການ</th>
                    </tr>
                </thead>
                <tbody id="category-table-body">
                    <?php
                    // ໍ້າ: ກັບສະຫຼັດ
                    $sql = "SELECT * FROM product_category ORDER BY category_id ASC";
                    $result = $conn->query($sql);
                    
                    if ($result->num_rows > 0) {
                        $counter = 1;
                        while($row = $result->fetch_assoc()) {
                            echo "<tr data-id='".$row['category_id']."'>";
                            echo "<td>" . $counter . "</td>";
                            echo "<td>" . $row['category_id'] . "</td>";
                            echo "<td>" . $row['category_name'] . "</td>";
                            echo "<td class='action-buttons'>";
                            echo "<button class='edit-btn' data-id='".$row['category_id']."' data-name='".$row['category_name']."'><i class='fas fa-edit'></i></button>";
                            echo "<button class='delete-btn' data-id='".$row['category_id']."'><i class='fas fa-trash'></i></button>";
                            echo "</td>";
                            echo "</tr>";
                            $counter++;
                        }
                    } else {
                        echo "<tr><td colspan='4' style='text-align:center'>ບໍ່ພົບຂໍ້ມູນປະເພດສິນຄ້າ</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- ໍ້າ: ກັບສະຫຼັດ -->
    <input type="hidden" id="new_category_id" value="<?php echo $new_category_id; ?>">

    <!-- Modal ໍ້າ: ກັບສະຫຼັດ -->
    <div id="categoryModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2 class="modal-title"><i class="fas fa-tags"></i> ເພີ່ມຂໍ້ມູນປະເພດສິນຄ້າ</h2>
            
            <form method="post" action="">
                <div class="form-grid">
                    <div class="form-group">
                        <label for="category_id">ລະຫັດປະເພດສິນຄ້າ</label>
                        <input type="text" id="category_id" name="category_id" value="<?php echo $new_category_id; ?>" readonly>
                    </div>
                    
                    <div class="form-group">
                        <label for="category_name">ຊື່ປະເພດສິນຄ້າ</label>
                        <input type="text" id="category_name" name="category_name" required>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="reset" class="btn secondary-btn"><i class="fas fa-undo"></i> ລ້າງຂໍ້ມູນ</button>
                    <button type="submit" class="btn primary-btn"><i class="fas fa-save"></i> ບັນທຶກຂໍ້ມູນ</button>
                </div>
            </form>
        </div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Modal functionality
        const modal = document.getElementById("categoryModal");
        const addBtn = document.getElementById("add-category-btn");
        const closeBtn = document.getElementsByClassName("close")[0];

        function showModal() {
            modal.style.display = "block";
            setTimeout(() => {
                modal.classList.add("show");
            }, 10);
        }
        function hideModal() {
            modal.classList.remove("show");
            setTimeout(() => {
                modal.style.display = "none";
            }, 300);
        }

        // Open modal when add button is clicked
        addBtn.onclick = function() {
            showModal();
            document.querySelector('.modal-title').innerHTML = '<i class="fas fa-tags"></i> ເພີ່ມຂໍ້ມູນປະເພດສິນຄ້າ';
            document.querySelector('form').reset();
            document.getElementById('category_id').value = document.getElementById('new_category_id').value;
            document.getElementById('category_name').value = '';
        }

        // Close modal when X is clicked
        if (closeBtn) {
            closeBtn.onclick = function() {
                hideModal();
            }
        }

        // Close modal when clicking outside
        window.onclick = function(event) {
            if (event.target == modal) {
                hideModal();
            }
        }
        

const searchInput = document.getElementById('category-search');
searchInput.addEventListener('keyup', function() {
    const searchValue = this.value.toLowerCase();
    const rows = document.querySelectorAll('#category-table-body tr');
    let visibleCount = 0;

    rows.forEach(row => {
        // ข้ามแถว "no data" ถ้ามี
        if (row.id === 'no-data-row') return;
        const categoryName = row.cells[2].textContent.toLowerCase();
        const categoryId = row.cells[1].textContent.toLowerCase();

        if (categoryName.includes(searchValue) || categoryId.includes(searchValue)) {
            row.style.display = '';
            visibleCount++;
        } else {
            row.style.display = 'none';
        }
    });

    // ลบแถว "no data" เดิมถ้ามี
    let noDataRow = document.getElementById('no-data-row');
    if (noDataRow) noDataRow.remove();

    // ถ้าไม่พบข้อมูล ให้เพิ่มแถว "ບໍ່ພົບສິນຄ້າ"
    if (visibleCount === 0) {
        const tbody = document.getElementById('category-table-body');
        const tr = document.createElement('tr');
        tr.id = 'no-data-row';
        const td = document.createElement('td');
        td.colSpan = 4;
        td.style.textAlign = 'center';
        td.textContent = 'ບໍ່ພົບສິນຄ້າ';
        tr.appendChild(td);
        tbody.appendChild(tr);
    }
});

        
        // ໍ້າ: ກັບສະຫຼັດ
        const editButtons = document.querySelectorAll('.edit-btn');
        editButtons.forEach(button => {
            button.addEventListener('click', function() {
                const categoryId = this.getAttribute('data-id');
                const categoryName = this.getAttribute('data-name');
                document.querySelector('.modal-title').innerHTML = '<i class="fas fa-edit"></i> ແກ້ໄຂຂໍ້ມູນປະເພດສິນຄ້າ';
                document.getElementById('category_id').value = categoryId;
                document.getElementById('category_name').value = categoryName;
                showModal();
            });
        });
        
        
        
const deleteButtons = document.querySelectorAll('.delete-btn');
deleteButtons.forEach(button => {
    button.addEventListener('click', function() {
        const categoryId = this.getAttribute('data-id');
        Swal.fire({
            title: 'ຢືນຢັນການລຶບປະເພດສິນຄ້າ',
            text: 'ທ່ານແນ່ໃຈບໍ່ວ່າຕ້ອງການລຶບປະເພດສິນຄ້ານີ້?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'ຕົກລົງ',
            cancelButtonText: 'ຍົກເລີກ'
        }).then((result) => {
            if (result.isConfirmed) {
                fetch('delete_category', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: 'id=' + encodeURIComponent(categoryId)
                })
                .then(response => {
                    const contentType = response.headers.get('content-type');
                    if (contentType && contentType.includes('application/json')) {
                        return response.json();
                    } else {
                        throw new Error('ไม่ได้รับข้อมูล JSON จากเซิร์ฟเวอร์');
                    }
                })
                .then(data => {
                    if (data.success) {
                        const row = button.closest('tr');
                        row.remove();
                        Swal.fire('ສຳເລັດ!', 'ລຶບປະເພດສິນຄ້າສຳເລັດແລ້ວ', 'success');
                    } else {
                        Swal.fire('ຜິດພາດ', 'ເກີດຂໍ້ຜິດພາດ: ' + data.message, 'error');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    Swal.fire('ຜິດພາດ', 'ເກີດຂໍ້ຜິດພາດໃນການລຶບຂໍ້ມູນ: ' + error.message, 'error');
                });
            }
        });
    });
});

    });
    </script>
</body>
</html>






