<?php
require("db_con.php");

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $em_email = $_POST['em_email'];
    $em_username = $_POST['em_username'];
    $em_lastname = $_POST['em_lastname'];
    $password = $_POST['password'];
    $em_clinic = $_POST['em_clinic'];
    $em_tel = $_POST['em_tel'];
    $em_position = $_POST['em_position'];

    // ตรวจสอบ email ซ้ำ
    $check_sql = "SELECT em_id FROM employee WHERE em_email = ?";
    $check_stmt = $conn->prepare($check_sql);
    $check_stmt->bind_param("s", $em_email);
    $check_stmt->execute();
    $check_stmt->store_result();
    if ($check_stmt->num_rows > 0) {
        echo "มี email นี้อยู่ในระบบแล้ว กรุณาใช้อีเมลอื่น";
        $check_stmt->close();
        $conn->close();
        exit;
    }
    $check_stmt->close();

    $hashedPassword = password_hash($password, PASSWORD_BCRYPT);

    $sql = "INSERT INTO employee (em_email, em_username, em_lastname, em_pass, em_clinic, em_tel, em_position) VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssssss", $em_email, $em_username, $em_lastname, $hashedPassword, $em_clinic, $em_tel, $em_position);

    if ($stmt->execute()) {
        echo "ผู้ใช้ใหม่ถูกเพิ่มเรียบร้อยแล้ว!";
    } else {
        echo "เกิดข้อผิดพลาดในการเพิ่มผู้ใช้ใหม่: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();
} else {
    echo "คำขอไม่ถูกต้อง";
}
?>
