<?php
$page_title = 'ລາຍຮັບອື່ນໆ';

// Handle AJAX requests BEFORE any HTML output
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    @ob_end_clean();
    @ini_set('display_errors', 0);
    @error_reporting(0);
    if (session_status() === PHP_SESSION_NONE)
        @session_start();

    // Try multiple paths for database connection
    $db_paths = [__DIR__ . '/../includes/con_database.php', dirname(__FILE__) . '/../includes/con_database.php', $_SERVER['DOCUMENT_ROOT'] . '/epcommerce/includes/con_database.php'];
    foreach ($db_paths as $path) {
        if (file_exists($path)) {
            require_once $path;
            break;
        }
    }
    require_once __DIR__ . '/../includes/secondary_ids.php';

    header('Content-Type: application/json');

    $shop_id = $_SESSION['shop_id'] ?? null;
    $user_id = $_SESSION['user_id'] ?? null;
    $user_secondary_id = getUserSecondaryId($conn, $user_id);
    $action = $_POST['action'] ?? '';

    if (!$shop_id) {
        echo json_encode(['success' => false, 'message' => 'ກະລຸນາເລືອກຮ້ານກ່ອນ']);
        exit;
    }

    if ($action === 'add') {
        $stmt = $conn->prepare("INSERT INTO other_income (shop_id, category, amount, income_date, description, created_by) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("isdsss", $shop_id, $_POST['title'], $_POST['amount'], $_POST['income_date'], $_POST['description'], $user_secondary_id);
        echo json_encode(['success' => $stmt->execute(), 'message' => 'ເພີ່ມສຳເລັດ']);
        exit;
    }

    if ($action === 'edit') {
        $stmt = $conn->prepare("UPDATE other_income SET category = ?, amount = ?, income_date = ?, description = ?, updated_by = ? WHERE id = ? AND shop_id = ?");
        $stmt->bind_param("sdsssii", $_POST['title'], $_POST['amount'], $_POST['income_date'], $_POST['description'], $user_secondary_id, $_POST['id'], $shop_id);
        echo json_encode(['success' => $stmt->execute(), 'message' => 'ແກ້ໄຂສຳເລັດ']);
        exit;
    }

    if ($action === 'delete') {
        $stmt = $conn->prepare("UPDATE other_income SET deleted_at = NOW(), deleted_by = ? WHERE id = ? AND shop_id = ?");
        $stmt->bind_param("sii", $user_secondary_id, $_POST['id'], $shop_id);
        echo json_encode(['success' => $stmt->execute(), 'message' => 'ລຶບສຳເລັດ']);
        exit;
    }
}

require_once 'includes/header.php';

$shop_id = $_SESSION['shop_id'] ?? null;
$user_id = $_SESSION['user_id'] ?? null;

$start = $_GET['start'] ?? date('Y-m-01');
$end = $_GET['end'] ?? date('Y-m-d');
$items = [];
$total = 0;

if ($shop_id) {
    $stmt = $conn->prepare("SELECT * FROM other_income WHERE shop_id = ? AND deleted_at IS NULL AND income_date BETWEEN ? AND ? ORDER BY income_date ASC");
    $stmt->bind_param("iss", $shop_id, $start, $end);
    $stmt->execute();
    $items = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $total = array_sum(array_column($items, 'amount'));
}
?>

<style>
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px
    }

    .page-header h1 {
        font-size: 24px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 12px;
        margin: 0
    }

    .page-header h1 i {
        color: #28a745
    }

    .stats-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 16px;
        margin-bottom: 24px
    }

    .mini-stat {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 12px;
        padding: 20px;
        display: flex;
        align-items: center;
        gap: 16px
    }

    .mini-stat .icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        color: #fff;
        background: linear-gradient(135deg, #28a745, #1e7e34)
    }

    .mini-stat .info h3 {
        font-size: 24px;
        margin: 0;
        color: #28a745
    }

    .mini-stat .info p {
        color: var(--text-secondary);
        margin: 0;
        font-size: 13px
    }

    .filter-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 12px;
        padding: 20px;
        margin-bottom: 24px
    }

    .filter-row {
        display: flex;
        gap: 16px;
        flex-wrap: wrap;
        align-items: flex-end
    }

    .filter-row .form-group {
        flex: 1;
        min-width: 150px
    }

    .filter-row label {
        display: block;
        margin-bottom: 8px;
        font-size: 13px;
        color: var(--text-secondary)
    }

    .filter-row input {
        width: 100%;
        padding: 10px 12px;
        border: 1px solid var(--border-color);
        border-radius: 8px;
        background: var(--input-bg);
        color: var(--text-primary)
    }

    .btn-filter {
        padding: 10px 20px;
        background: var(--accent);
        color: #fff;
        border: none;
        border-radius: 8px;
        cursor: pointer
    }

    .data-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        overflow: hidden
    }

    .data-card-header {
        padding: 20px 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center
    }

    .pro-table {
        width: 100%;
        border-collapse: collapse
    }

    .pro-table th {
        background: rgba(40, 167, 69, .1);
        padding: 14px 16px;
        text-align: left;
        font-weight: 600;
        font-size: 13px;
        text-transform: uppercase;
        color: var(--text-secondary)
    }

    .pro-table td {
        padding: 16px;
        border-bottom: 1px solid var(--border-color)
    }

    .pro-table tbody tr:hover {
        background: rgba(40, 167, 69, .05)
    }

    .amount-income {
        color: #28a745;
        font-weight: 600;
        font-size: 16px
    }

    .action-btns {
        display: flex;
        gap: 8px
    }

    .btn-icon {
        width: 36px;
        height: 36px;
        border-radius: 8px;
        border: none;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all .2s;
        font-size: 14px
    }

    .btn-icon.edit {
        background: rgba(255, 193, 7, .15);
        color: #ffc107
    }

    .btn-icon.edit:hover {
        background: #ffc107;
        color: #000
    }

    .btn-icon.delete {
        background: rgba(220, 53, 69, .15);
        color: #dc3545
    }

    .btn-icon.delete:hover {
        background: #dc3545;
        color: #fff
    }

    .btn-pro {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 12px 24px;
        border-radius: 10px;
        border: none;
        font-weight: 600;
        cursor: pointer;
        font-size: 14px
    }

    .btn-pro.primary {
        background: linear-gradient(135deg, #28a745, #1e7e34);
        color: #fff;
        box-shadow: 0 4px 15px rgba(40, 167, 69, .3)
    }

    .pro-modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, .6);
        backdrop-filter: blur(4px);
        z-index: 9999;
        align-items: center;
        justify-content: center;
        padding: 20px
    }

    .pro-modal.show {
        display: flex
    }

    .pro-modal-content {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 20px;
        width: 100%;
        max-width: 500px;
        animation: modalSlide .3s ease
    }

    @keyframes modalSlide {
        from {
            opacity: 0;
            transform: translateY(-20px)
        }

        to {
            opacity: 1;
            transform: translateY(0)
        }
    }

    .pro-modal-header {
        padding: 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center
    }

    .pro-modal-header h3 {
        margin: 0;
        font-size: 20px;
        display: flex;
        align-items: center;
        gap: 10px
    }

    .pro-modal-header h3 i {
        color: #28a745
    }

    .pro-modal-close {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        border: none;
        background: rgba(255, 255, 255, .1);
        color: var(--text-secondary);
        cursor: pointer;
        font-size: 18px
    }

    .pro-modal-body {
        padding: 24px
    }

    .pro-modal-footer {
        padding: 20px 24px;
        border-top: 1px solid var(--border-color);
        display: flex;
        gap: 12px;
        justify-content: flex-end
    }

    .form-pro-group {
        margin-bottom: 20px
    }

    .form-pro-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 500
    }

    .form-pro-group label span {
        color: #dc3545
    }

    .form-pro-input {
        width: 100%;
        padding: 14px 16px;
        border: 2px solid var(--border-color);
        border-radius: 10px;
        background: var(--input-bg);
        color: var(--text-primary);
        font-size: 15px
    }

    .form-pro-input:focus {
        outline: none;
        border-color: #28a745
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: var(--text-secondary)
    }

    .empty-state i {
        font-size: 64px;
        opacity: .3;
        margin-bottom: 20px
    }

    @media(max-width:768px) {
        .page-header {
            flex-direction: column;
            align-items: flex-start
        }

        .filter-row {
            flex-direction: column
        }

        .pro-table {
            display: block;
            overflow-x: auto
        }
    }
</style>

<?php if (!$shop_id): ?>
    <div class="empty-state"><i class="fas fa-store-slash"></i>
        <h4>ກະລຸນາເລືອກຮ້ານກ່ອນ</h4>
    </div>
<?php else: ?>

    <div class="page-header">
        <h1><i class="fas fa-arrow-circle-down"></i> ລາຍຮັບອື່ນໆ</h1>
        <button class="btn-pro primary" onclick="openIncomeModal('add')"><i class="fas fa-plus"></i> ເພີ່ມລາຍຮັບ</button>
    </div>

    <div class="stats-row">
        <div class="mini-stat">
            <div class="icon"><i class="fas fa-coins"></i></div>
            <div class="info">
                <h3>+<?= number_format($total) ?> ₭</h3>
                <p>ລາຍຮັບລວມ (<?= $start ?> - <?= $end ?>)</p>
            </div>
        </div>
    </div>

    <div class="filter-card">
        <form method="GET" class="filter-row">
            <div class="form-group"><label>ວັນທີເລີ່ມ</label><input type="date" name="start" value="<?= $start ?>"></div>
            <div class="form-group"><label>ວັນທີສິ້ນສຸດ</label><input type="date" name="end" value="<?= $end ?>"></div>
            <button class="btn-filter"><i class="fas fa-filter"></i> ກັ່ນຕອງ</button>
        </form>
    </div>

    <div class="data-card">
        <div class="data-card-header">
            <h3><i class="fas fa-list"></i> ລາຍການລາຍຮັບ</h3>
        </div>

        <?php if (empty($items)): ?>
            <div class="empty-state"><i class="fas fa-inbox"></i>
                <h4>ບໍ່ມີຂໍ້ມູນ</h4>
            </div>
        <?php else: ?>
            <div style="overflow-x:auto">
                <table class="pro-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>ວັນທີ</th>
                            <th>ລາຍການ</th>
                            <th>ຈຳນວນເງິນ</th>
                            <th>ໝາຍເຫດ</th>
                            <th>ຈັດການ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($items as $i => $item): ?>
                            <tr>
                                <td><?= $i + 1 ?></td>
                                <td><?= $item['income_date'] ?></td>
                                <td><strong><?= htmlspecialchars($item['title']) ?></strong></td>
                                <td><span class="amount-income">+<?= number_format($item['amount']) ?> ₭</span></td>
                                <td><?= htmlspecialchars($item['description'] ?? '-') ?></td>
                                <td>
                                    <div class="action-btns">
                                        <button class="btn-icon edit"
                                            onclick="openIncomeModal('edit', <?= htmlspecialchars(json_encode($item)) ?>)"><i
                                                class="fas fa-pen"></i></button>
                                        <button class="btn-icon delete"
                                            onclick="confirmDelete(<?= $item['id'] ?>, '<?= htmlspecialchars($item['title']) ?>')"><i
                                                class="fas fa-trash"></i></button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>

    <div class="pro-modal" id="formModal">
        <div class="pro-modal-content">
            <div class="pro-modal-header">
                <h3><i class="fas fa-arrow-circle-down"></i> <span id="modalTitle">ເພີ່ມລາຍຮັບ</span></h3>
                <button class="pro-modal-close" onclick="closeIncomeModal()">&times;</button>
            </div>
            <form id="dataForm">
                <div class="pro-modal-body">
                    <input type="hidden" name="action" id="formAction" value="add">
                    <input type="hidden" name="id" id="formId">
                    <div class="form-pro-group"><label>ລາຍການ <span>*</span></label><input type="text" name="title"
                            id="title" class="form-pro-input" required></div>
                    <div class="form-pro-group"><label>ຈຳນວນເງິນ (₭) <span>*</span></label><input type="number"
                            name="amount" id="amount" class="form-pro-input" required></div>
                    <div class="form-pro-group"><label>ວັນທີ <span>*</span></label><input type="date" name="income_date"
                            id="income_date" class="form-pro-input" required value="<?= date('Y-m-d') ?>"></div>
                    <div class="form-pro-group"><label>ໝາຍເຫດ</label><textarea name="description" id="description"
                            class="form-pro-input" rows="2"></textarea></div>
                </div>
                <div class="pro-modal-footer">
                    <button type="button" class="btn-pro" style="background:var(--border-color);color:var(--text-primary)"
                        onclick="closeIncomeModal()">ຍົກເລີກ</button>
                    <button type="submit" class="btn-pro primary"><i class="fas fa-save"></i> ບັນທຶກ</button>
                </div>
            </form>
        </div>
    </div>

<?php endif; ?>
<?php require_once 'includes/footer.php'; ?>

<?php if ($shop_id): ?>
    <script>
        function openIncomeModal(mode, data = null) {
            document.getElementById('dataForm').reset();
            document.getElementById('formId').value = '';
            document.getElementById('income_date').value = '<?= date('Y-m-d') ?>';
            if (mode === 'add') {
                document.getElementById('modalTitle').textContent = 'ເພີ່ມລາຍຮັບໃໝ່';
                document.getElementById('formAction').value = 'add';
            } else {
                document.getElementById('modalTitle').textContent = 'ແກ້ໄຂລາຍຮັບ';
                document.getElementById('formAction').value = 'edit';
                document.getElementById('formId').value = data.id;
                document.getElementById('title').value = data.title;
                document.getElementById('amount').value = data.amount;
                document.getElementById('income_date').value = data.income_date;
                document.getElementById('description').value = data.description || '';
            }
            document.getElementById('formModal').classList.add('show');
        }

        function closeIncomeModal() { document.getElementById('formModal').classList.remove('show'); }
        document.getElementById('formModal').addEventListener('click', function (e) { if (e.target === this) closeIncomeModal(); });

        document.getElementById('dataForm').addEventListener('submit', async function (e) {
            e.preventDefault();
            closeIncomeModal();
            Swal.fire({ title: 'ກຳລັງບັນທຶກ...', text: 'ກະລຸນາລໍຖ້າ', allowOutsideClick: false, showConfirmButton: false, didOpen: () => Swal.showLoading() });
            try {
                const response = await fetch('income.php', { method: 'POST', body: new FormData(this) });
                const data = await response.json();
                if (data.success) {
                    await Swal.fire({ icon: 'success', title: 'ສຳເລັດ!', timer: 1500, timerProgressBar: true, showConfirmButton: false });
                    location.reload();
                } else {
                    Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: data.message });
                }
            } catch (error) {
                Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: 'ການເຊື່ອມຕໍ່ມີປັນຫາ' });
            }
        });

        async function confirmDelete(id, name) {
            const result = await Swal.fire({
                title: 'ຢືນຢັນການລຶບ?', html: `ລຶບ <strong>"${name}"</strong> ແທ້ບໍ?`, icon: 'warning',
                showCancelButton: true, confirmButtonColor: '#dc3545', confirmButtonText: '<i class="fas fa-trash"></i> ລຶບ', cancelButtonText: 'ຍົກເລີກ', reverseButtons: true
            });
            if (result.isConfirmed) {
                Swal.fire({ title: 'ກຳລັງລຶບ...', allowOutsideClick: false, showConfirmButton: false, didOpen: () => Swal.showLoading() });
                try {
                    const fd = new FormData(); fd.append('action', 'delete'); fd.append('id', id);
                    const response = await fetch('income.php', { method: 'POST', body: fd });
                    const data = await response.json();
                    if (data.success) {
                        await Swal.fire({ icon: 'success', title: 'ລຶບສຳເລັດ!', timer: 1500, showConfirmButton: false });
                        location.reload();
                    } else {
                        Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: data.message });
                    }
                } catch (error) {
                    Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: 'ການເຊື່ອມຕໍ່ມີປັນຫາ' });
                }
            }
        }
    </script>
<?php endif; ?>