<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
date_default_timezone_set('Asia/Vientiane');

// Check if logged in and is admin
if (!isset($_SESSION['user_id']) || $_SESSION['role_code'] !== 'admin') {
    header('Location: ../login.php');
    exit;
}

require_once dirname(__DIR__, 2) . '/includes/con_database.php';

$current_page = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="lo" data-theme="dark">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>
        <?= $page_title ?? 'Admin' ?> - EPCommerce
    </title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@300;400;500;600;700&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <!-- SweetAlert2 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Prevent sidebar flash on page load -->
    <script>
        (function () {
            if (localStorage.getItem('epcommerce_sidebar_collapsed') === 'true') {
                document.documentElement.classList.add('sidebar-preload-collapsed');
                document.documentElement.classList.add('no-transitions');
            }
            if (localStorage.getItem('epcommerce_theme') === 'light') {
                document.documentElement.setAttribute('data-theme', 'light');
            }
            // Color theme preload
            var colorTheme = localStorage.getItem('epcommerce_color_theme');
            if (colorTheme) {
                document.documentElement.setAttribute('data-color-theme', colorTheme);
            }
        })();
    </script>
    <style>
        /* Prevent flash - apply collapsed state immediately */
        .sidebar-preload-collapsed .sidebar {
            width: 70px !important;
            overflow: visible !important;
        }

        .sidebar-preload-collapsed .main-content {
            margin-left: 70px !important;
        }

        /* Hide elements */
        .sidebar-preload-collapsed .sidebar-brand,
        .sidebar-preload-collapsed .menu-label,
        .sidebar-preload-collapsed .menu-item a span,
        .sidebar-preload-collapsed .menu-arrow {
            opacity: 0 !important;
            width: 0 !important;
            pointer-events: none !important;
            transform: translateX(-10px) !important;
        }

        /* Adjust header and logo for collapsed state */
        .sidebar-preload-collapsed .sidebar-header {
            justify-content: center !important;
            padding: 15px !important;
            gap: 0 !important;
        }

        .sidebar-preload-collapsed .sidebar-logo {
            width: 40px !important;
            height: 40px !important;
        }

        /* Adjust menu items alignment */
        .sidebar-preload-collapsed .menu-item>a {
            justify-content: flex-start !important;
            padding: 12px 15px !important;
        }

        .sidebar-preload-collapsed .menu-item a i {
            margin-right: 0 !important;
            text-align: center !important;
            width: 30px !important;
        }

        .sidebar-preload-collapsed .sidebar-menu {
            overflow: visible !important;
            height: auto !important;
        }

        .sidebar-preload-collapsed .sidebar-toggle {
            top: 32px !important;
        }

        .sidebar-preload-collapsed .sidebar-toggle i {
            transform: rotate(180deg) !important;
        }

        @media (max-width: 991px) {
            .sidebar-preload-collapsed .main-content {
                margin-left: 0 !important;
            }
        }

        /* Disable transitions during load */
        .no-transitions * {
            transition: none !important;
        }
    </style>
    <style>
        /* SweetAlert2 z-index fix - ensure it appears above modals */
        .swal2-container {
            z-index: 99999 !important;
        }

        .swal2-popup {
            z-index: 99999 !important;
        }
    </style>
    <style>
        :root {
            --primary: #001E3F;
            --primary-light: #003366;
            --primary-dark: #001529;
            --accent: #4A90D9;
            --accent-light: #6BA3E0;
            --accent-soft: #2D5A87;

            --light-bg: #F5F7FA;
            --light-card: #FFFFFF;
            --light-text: #1A1A2E;
            --light-text-secondary: #5A6370;
            --light-border: #E1E5EB;

            --dark-bg: #001E3F;
            --dark-bg-secondary: #00152B;
            --dark-card: rgba(255, 255, 255, 0.05);
            --dark-text: #FFFFFF;
            --dark-text-secondary: rgba(255, 255, 255, 0.7);
            --dark-border: rgba(255, 255, 255, 0.1);

            --success: #28A745;
            --warning: #FFC107;
            --danger: #DC3545;
            --info: #17A2B8;
        }

        /* ===== Color Themes ===== */
        /* Original / Blue Theme (Default) */
        [data-color-theme="original"],
        [data-color-theme="blue"],
        :root {
            --primary: #001E3F;
            --primary-light: #003366;
            --primary-dark: #001529;
            --accent: #4A90D9;
            --accent-light: #6BA3E0;
            --accent-soft: #2D5A87;
            --dark-bg: #001E3F;
            --dark-bg-secondary: #00152B;
        }

        /* Red Theme */
        [data-color-theme="red"] {
            --primary: #3F0000;
            --primary-light: #5C1010;
            --primary-dark: #2A0000;
            --accent: #D94A4A;
            --accent-light: #E06B6B;
            --accent-soft: #872D2D;
            --dark-bg: #3F0000;
            --dark-bg-secondary: #2A0000;
        }

        /* Yellow Theme */
        [data-color-theme="yellow"] {
            --primary: #3F3000;
            --primary-light: #5C4510;
            --primary-dark: #2A2000;
            --accent: #D9B84A;
            --accent-light: #E0C76B;
            --accent-soft: #87722D;
            --dark-bg: #3F3000;
            --dark-bg-secondary: #2A2000;
        }

        /* Green Theme */
        [data-color-theme="green"] {
            --primary: #003F1E;
            --primary-light: #105C35;
            --primary-dark: #002A14;
            --accent: #4AD97A;
            --accent-light: #6BE095;
            --accent-soft: #2D874A;
            --dark-bg: #003F1E;
            --dark-bg-secondary: #002A14;
        }

        /* Orange Theme */
        [data-color-theme="orange"] {
            --primary: #3F2100;
            --primary-light: #5C3510;
            --primary-dark: #2A1600;
            --accent: #D9874A;
            --accent-light: #E09E6B;
            --accent-soft: #87542D;
            --dark-bg: #3F2100;
            --dark-bg-secondary: #2A1600;
        }

        /* Purple Theme */
        [data-color-theme="purple"] {
            --primary: #2A003F;
            --primary-light: #40105C;
            --primary-dark: #1C002A;
            --accent: #9A4AD9;
            --accent-light: #AD6BE0;
            --accent-soft: #5F2D87;
            --dark-bg: #2A003F;
            --dark-bg-secondary: #1C002A;
        }

        /* Pink Theme - Barbie Style */
        [data-color-theme="pink"] {
            --primary: #FF69B4;
            --primary-light: #FF85C1;
            --primary-dark: #E0559E;
            --accent: #FF1493;
            --accent-light: #FF6EB4;
            --accent-soft: #DB7093;
            --dark-bg: #FF69B4;
            --dark-bg-secondary: #E0559E;
        }

        /* Gray Theme */
        [data-color-theme="gray"] {
            --primary: #2A2A2A;
            --primary-light: #404040;
            --primary-dark: #1A1A1A;
            --accent: #7A7A7A;
            --accent-light: #9A9A9A;
            --accent-soft: #5A5A5A;
            --dark-bg: #2A2A2A;
            --dark-bg-secondary: #1A1A1A;
        }

        /* White Theme - Clean & Minimal */
        [data-color-theme="white"] {
            --primary: #F8F9FA;
            --primary-light: #FFFFFF;
            --primary-dark: #E9ECEF;
            --accent: #6C757D;
            --accent-light: #868E96;
            --accent-soft: #495057;
            --dark-bg: #F8F9FA;
            --dark-bg-secondary: #E9ECEF;
        }

        /* White Theme - Dark Mode (Soft Dark Gray) */
        [data-theme="dark"][data-color-theme="white"] {
            --bg-primary: #1E1E1E;
            --bg-secondary: #2D2D2D;
            --card-bg: rgba(255, 255, 255, 0.08);
            --text-primary: #E8E8E8;
            --text-secondary: rgba(255, 255, 255, 0.6);
            --border-color: rgba(255, 255, 255, 0.12);
            --sidebar-bg: #2D2D2D;
            --primary: #2D2D2D;
            --accent: #AAAAAA;
            --accent-light: #CCCCCC;
        }

        /* White Theme - Light Mode (Clean White) */
        [data-theme="light"][data-color-theme="white"] {
            --bg-primary: #FAFAFA;
            --bg-secondary: #F0F0F0;
            --card-bg: #FFFFFF;
            --text-primary: #333333;
            --text-secondary: #666666;
            --border-color: #E0E0E0;
            --sidebar-bg: #FFFFFF;
            --primary: #FFFFFF;
            --accent: #555555;
            --accent-light: #777777;
        }

        /* White Theme - Sidebar styling */
        [data-color-theme="white"] .sidebar .menu-item>a,
        [data-color-theme="white"] .sidebar .submenu li a {
            color: rgba(0, 0, 0, 0.7);
        }

        [data-color-theme="white"] .sidebar .sidebar-brand h2,
        [data-color-theme="white"] .sidebar .sidebar-brand span {
            color: #333333;
        }

        [data-color-theme="white"] .sidebar .menu-item>a:hover {
            background: rgba(0, 0, 0, 0.05);
            color: #000000;
        }

        [data-color-theme="white"] .sidebar .menu-item>a.active {
            background: #6C757D;
            color: #FFFFFF;
        }

        [data-theme="dark"][data-color-theme="white"] .sidebar .menu-item>a,
        [data-theme="dark"][data-color-theme="white"] .sidebar .submenu li a,
        [data-theme="dark"][data-color-theme="white"] .sidebar .sidebar-brand h2,
        [data-theme="dark"][data-color-theme="white"] .sidebar .sidebar-brand span {
            color: rgba(255, 255, 255, 0.8);
        }

        [data-theme="dark"][data-color-theme="white"] .sidebar .menu-item>a:hover {
            background: rgba(255, 255, 255, 0.1);
            color: #FFFFFF;
        }

        [data-theme="dark"][data-color-theme="white"] .sidebar .menu-item>a.active {
            background: rgba(255, 255, 255, 0.2);
            color: #FFFFFF;
        }

        [data-theme="dark"] {
            --bg-primary: var(--dark-bg);
            --bg-secondary: var(--dark-bg-secondary);
            --card-bg: var(--dark-card);
            --text-primary: var(--dark-text);
            --text-secondary: var(--dark-text-secondary);
            --border-color: var(--dark-border);
            --sidebar-bg: var(--dark-bg-secondary);
        }

        [data-theme="light"] {
            --bg-primary: var(--light-bg);
            --bg-secondary: #E8ECF1;
            --card-bg: var(--light-card);
            --text-primary: var(--light-text);
            --text-secondary: var(--light-text-secondary);
            --border-color: var(--light-border);
            --sidebar-bg: var(--primary);
        }

        /* Pink Theme - BLACKPINK Style for Dark Mode */
        [data-theme="dark"][data-color-theme="pink"] {
            --bg-primary: #0D0D0D;
            --bg-secondary: #1A1A1A;
            --card-bg: rgba(255, 255, 255, 0.05);
            --text-primary: #FFFFFF;
            --text-secondary: rgba(255, 255, 255, 0.7);
            --border-color: rgba(255, 20, 147, 0.3);
            --sidebar-bg: #FF1493;
            --primary: #FF69B4;
            --primary-light: #FF85C1;
            --primary-dark: #E0559E;
            --accent: #FF1493;
            --accent-light: #FF69B4;
            --accent-soft: #DB7093;
        }

        /* Pink Theme - White Pink Style for Light Mode */
        [data-theme="light"][data-color-theme="pink"] {
            --bg-primary: #FFF0F5;
            --bg-secondary: #FFE4EC;
            --card-bg: #FFFFFF;
            --text-primary: #1A1A2E;
            --text-secondary: #5A6370;
            --border-color: #FFB6C1;
            --sidebar-bg: #FF69B4;
            --primary: #FF69B4;
            --primary-light: #FF85C1;
            --primary-dark: #E0559E;
            --accent: #FF1493;
            --accent-light: #FF6EB4;
            --accent-soft: #DB7093;
        }

        /* Pink Theme Dark Mode - Sidebar Text White */
        [data-theme="dark"][data-color-theme="pink"] .sidebar .sidebar-brand,
        [data-theme="dark"][data-color-theme="pink"] .sidebar .sidebar-brand h2,
        [data-theme="dark"][data-color-theme="pink"] .sidebar .sidebar-brand span,
        [data-theme="dark"][data-color-theme="pink"] .sidebar .menu-label,
        [data-theme="dark"][data-color-theme="pink"] .sidebar .menu-item>a,
        [data-theme="dark"][data-color-theme="pink"] .sidebar .menu-item>a span,
        [data-theme="dark"][data-color-theme="pink"] .sidebar .menu-item>a i,
        [data-theme="dark"][data-color-theme="pink"] .sidebar .submenu li a,
        [data-theme="dark"][data-color-theme="pink"] .sidebar .submenu li a i {
            color: #FFFFFF !important;
        }

        [data-theme="dark"][data-color-theme="pink"] .sidebar .menu-item>a:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        [data-theme="dark"][data-color-theme="pink"] .sidebar .menu-item>a.active {
            background: rgba(0, 0, 0, 0.3);
        }

        /* Pink Theme Light Mode - Sidebar Text White */
        [data-theme="light"][data-color-theme="pink"] .sidebar .sidebar-brand,
        [data-theme="light"][data-color-theme="pink"] .sidebar .sidebar-brand h2,
        [data-theme="light"][data-color-theme="pink"] .sidebar .sidebar-brand span,
        [data-theme="light"][data-color-theme="pink"] .sidebar .menu-label,
        [data-theme="light"][data-color-theme="pink"] .sidebar .menu-item>a,
        [data-theme="light"][data-color-theme="pink"] .sidebar .menu-item>a span,
        [data-theme="light"][data-color-theme="pink"] .sidebar .menu-item>a i,
        [data-theme="light"][data-color-theme="pink"] .sidebar .submenu li a,
        [data-theme="light"][data-color-theme="pink"] .sidebar .submenu li a i {
            color: #FFFFFF !important;
        }

        [data-theme="light"][data-color-theme="pink"] .sidebar .menu-item>a:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        [data-theme="light"][data-color-theme="pink"] .sidebar .menu-item>a.active {
            background: rgba(0, 0, 0, 0.2);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Noto Sans Lao', sans-serif;
            background: var(--bg-primary);
            color: var(--text-primary);
            min-height: 100vh;
            transition: all 0.3s ease;
        }

        /* Sidebar */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            width: 260px;
            height: 100vh;
            background: var(--sidebar-bg);
            border-right: 1px solid var(--border-color);
            z-index: 100;
            transition: width 0.35s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .sidebar.collapsed {
            width: 70px;
            overflow: visible;
        }

        /* Smooth hide elements when collapsed */
        .sidebar .sidebar-brand,
        .sidebar .menu-label,
        .sidebar .menu-item a span,
        .sidebar .menu-arrow {
            opacity: 1;
            transform: translateX(0);
            transition: opacity 0.25s ease, transform 0.25s ease;
            white-space: nowrap;
            overflow: hidden;
        }

        .sidebar.collapsed .sidebar-brand,
        .sidebar.collapsed .menu-label,
        .sidebar.collapsed .menu-item a span,
        .sidebar.collapsed .menu-arrow {
            opacity: 0;
            transform: translateX(-10px);
            width: 0;
            pointer-events: none;
        }

        .sidebar-header {
            padding: 20px;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            align-items: center;
            gap: 12px;
            transition: padding 0.35s cubic-bezier(0.4, 0, 0.2, 1), gap 0.35s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .sidebar.collapsed .sidebar-header {
            justify-content: center;
            padding: 15px;
            gap: 0;
        }

        .sidebar-logo {
            width: 45px;
            height: 45px;
            background: linear-gradient(135deg, var(--accent), var(--accent-soft));
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 20px;
            flex-shrink: 0;
            transition: width 0.35s cubic-bezier(0.4, 0, 0.2, 1), height 0.35s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .sidebar.collapsed .sidebar-logo {
            width: 40px;
            height: 40px;
        }

        .menu-item>a {
            transition: padding 0.35s cubic-bezier(0.4, 0, 0.2, 1), justify-content 0.35s ease;
        }

        .sidebar.collapsed .menu-item>a {
            justify-content: flex-start;
            padding: 12px 15px;
        }

        .sidebar.collapsed .menu-item a i {
            font-size: 20px;
            margin-right: 0;
            text-align: center;
            width: 30px;
        }

        /* Collapsed Sidebar - Hover Submenu Popup */
        .sidebar.collapsed .menu-item {
            position: static;
        }

        .sidebar.collapsed .menu-item>a {
            position: relative;
        }

        .sidebar.collapsed .submenu {
            display: none;
            position: fixed;
            left: 60px;
            min-width: 220px;
            background: var(--bg-secondary);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 10px 0;
            padding-left: 15px;
            margin-left: 0;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.3);
            z-index: 9999;
            max-height: none;
            overflow: visible;
            opacity: 1;
            transition: none;
        }

        /* Invisible bridge area to keep hover state */
        .sidebar.collapsed .submenu::before {
            content: '';
            position: absolute;
            left: -15px;
            top: 0;
            width: 20px;
            height: 100%;
            background: transparent;
        }

        .sidebar.collapsed .menu-item:hover .submenu {
            display: block;
        }

        /* Arrow indicator */
        .sidebar.collapsed .submenu::after {
            content: '';
            position: absolute;
            left: 5px;
            top: 15px;
            width: 0;
            height: 0;
            border-top: 8px solid transparent;
            border-bottom: 8px solid transparent;
            border-right: 8px solid var(--bg-secondary);
        }

        .sidebar.collapsed .submenu li a {
            padding: 12px 18px;
            justify-content: flex-start;
            gap: 10px;
        }

        .sidebar.collapsed .submenu li a span {
            display: inline;
        }

        /* Light mode - collapsed submenu popup styling */
        [data-theme="light"] .sidebar.collapsed .submenu {
            background: var(--primary);
            border-color: var(--primary-light);
        }

        [data-theme="light"] .sidebar.collapsed .submenu li a {
            color: rgba(255, 255, 255, 0.85);
        }

        [data-theme="light"] .sidebar.collapsed .submenu li a:hover {
            background: rgba(255, 255, 255, 0.1);
            color: white;
        }

        [data-theme="light"] .sidebar.collapsed .submenu::after {
            border-right-color: var(--primary);
        }

        .sidebar.collapsed .sidebar-menu {
            overflow: visible;
            height: auto;
        }

        /* Sidebar Toggle Button */
        .sidebar-toggle {
            position: absolute;
            right: -14px;
            top: 35px;
            width: 28px;
            height: 28px;
            border-radius: 50%;
            background: var(--accent);
            border: 3px solid var(--bg-primary);
            color: white;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 11px;
            transition: all 0.3s ease;
            z-index: 101;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
        }

        .sidebar-toggle:hover {
            background: var(--accent-light);
            transform: scale(1.15);
        }

        .sidebar.collapsed .sidebar-toggle {
            top: 32px;
        }

        .sidebar.collapsed .sidebar-toggle i {
            transform: rotate(180deg);
        }

        .sidebar-brand {
            color: white;
        }

        .sidebar-brand h2 {
            font-size: 20px;
            font-weight: 700;
        }

        .sidebar-brand span {
            font-size: 13px;
            color: rgba(255, 255, 255, 0.6);
        }

        .sidebar-menu {
            padding: 15px 0;
            list-style: none;
            overflow-y: auto;
            height: calc(100vh - 85px);
        }

        .menu-label {
            padding: 10px 20px;
            font-size: 13px;
            text-transform: uppercase;
            color: rgba(255, 255, 255, 0.4);
            font-weight: 600;
            letter-spacing: 0.5px;
        }

        .menu-item {
            margin: 2px 10px;
        }

        .menu-item>a {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 15px;
            color: rgba(255, 255, 255, 0.7);
            text-decoration: none;
            border-radius: 10px;
            transition: all 0.3s ease;
            font-size: 16px;
        }

        .menu-item>a:hover {
            background: rgba(255, 255, 255, 0.1);
            color: white;
        }

        .menu-item>a.active {
            background: var(--accent);
            color: white;
        }

        .menu-item a i {
            width: 20px;
            text-align: center;
        }

        .menu-arrow {
            margin-left: auto;
            transition: transform 0.3s ease;
        }

        .menu-item.open .menu-arrow {
            transform: rotate(90deg);
        }

        /* Submenu */
        .submenu {
            list-style: none;
            padding-left: 15px;
            margin-top: 5px;
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease-out, opacity 0.3s ease-out;
            opacity: 0;
        }

        .menu-item.open .submenu {
            max-height: 500px;
            opacity: 1;
            transition: max-height 0.4s ease-in, opacity 0.3s ease-in;
        }

        .submenu li a {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 10px 15px;
            color: rgba(255, 255, 255, 0.6);
            text-decoration: none;
            font-size: 15px;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .submenu li a:hover {
            color: white;
            background: rgba(255, 255, 255, 0.05);
        }

        .submenu li a.active {
            color: var(--accent);
        }

        /* Main Content */
        .main-content {
            margin-left: 260px;
            min-height: 100vh;
            transition: margin-left 0.35s cubic-bezier(0.4, 0, 0.2, 1);
        }

        body.sidebar-collapsed .main-content {
            margin-left: 70px;
        }

        /* Top Header */
        .top-header {
            position: sticky;
            top: 0;
            background: var(--bg-primary);
            border-bottom: 1px solid var(--border-color);
            padding: 15px 25px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            z-index: 50;
        }

        .page-title {
            font-size: 24px;
            font-weight: 600;
        }

        .header-actions {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .theme-toggle {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            color: var(--text-primary);
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
        }

        .theme-toggle:hover {
            background: var(--accent);
            color: white;
        }

        .user-dropdown {
            position: relative;
        }

        .user-btn {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 8px 15px;
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 10px;
            color: var(--text-primary);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .user-btn:hover {
            border-color: var(--accent);
        }

        .user-avatar {
            width: 32px;
            height: 32px;
            border-radius: 8px;
            background: var(--accent);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 14px;
        }

        .user-info {
            text-align: left;
        }

        .user-info .name {
            font-size: 15px;
            font-weight: 600;
        }

        .user-info .role {
            font-size: 13px;
            color: var(--text-secondary);
        }

        .dropdown-menu {
            position: absolute;
            top: 100%;
            right: 0;
            margin-top: 8px;
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 10px;
            min-width: 180px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            display: none;
            overflow: hidden;
        }

        .dropdown-menu.show {
            display: block;
        }

        .dropdown-menu a {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 12px 15px;
            color: var(--text-primary);
            text-decoration: none;
            font-size: 15px;
            transition: all 0.3s ease;
        }

        .dropdown-menu a:hover {
            background: var(--accent);
            color: white;
        }

        .dropdown-menu a.danger {
            color: var(--danger);
        }

        .dropdown-menu a.danger:hover {
            background: var(--danger);
            color: white;
        }

        /* Content Area */
        .content {
            padding: 25px;
        }

        /* Cards */
        .card {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 15px;
            overflow: hidden;
        }

        .card-header {
            padding: 18px 20px;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .card-title {
            font-size: 18px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .card-body {
            padding: 20px;
        }

        /* Buttons */
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 18px;
            border: none;
            border-radius: 8px;
            font-size: 15px;
            font-weight: 500;
            font-family: inherit;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--accent), var(--accent-soft));
            color: white;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(74, 144, 217, 0.3);
        }

        /* Stats Cards */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 20px;
            margin-bottom: 25px;
        }

        .stat-card {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 15px;
            padding: 20px;
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .stat-icon {
            width: 55px;
            height: 55px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 22px;
            color: white;
        }

        .stat-icon.blue {
            background: linear-gradient(135deg, #4A90D9, #2D5A87);
        }

        .stat-icon.green {
            background: linear-gradient(135deg, #28A745, #1E7B33);
        }

        .stat-icon.orange {
            background: linear-gradient(135deg, #FD7E14, #E06B10);
        }

        .stat-icon.purple {
            background: linear-gradient(135deg, #6C7AE0, #4A5BC7);
        }

        .stat-info h3 {
            font-size: 28px;
            font-weight: 700;
        }

        .stat-info p {
            font-size: 15px;
            color: var(--text-secondary);
        }

        /* Modal */
        .modal-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.6);
            display: none;
            align-items: center;
            justify-content: center;
            z-index: 1000;
        }

        .modal-overlay.show {
            display: flex;
        }

        .modal {
            background: var(--bg-primary);
            border: 1px solid var(--border-color);
            border-radius: 15px;
            width: 100%;
            max-width: 550px;
            max-height: 90vh;
            overflow-y: auto;
        }

        .modal-header {
            padding: 18px 20px;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .modal-title {
            font-size: 20px;
            font-weight: 600;
        }

        .modal-close {
            width: 35px;
            height: 35px;
            border: none;
            background: var(--card-bg);
            border-radius: 8px;
            color: var(--text-primary);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .modal-close:hover {
            background: var(--danger);
            color: white;
        }

        .modal-body {
            padding: 20px;
        }

        .modal-footer {
            padding: 15px 20px;
            border-top: 1px solid var(--border-color);
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }

        /* Forms */
        .form-group {
            margin-bottom: 18px;
        }

        .form-label {
            display: block;
            font-size: 15px;
            font-weight: 500;
            color: var(--text-secondary);
            margin-bottom: 8px;
        }

        .form-control {
            width: 100%;
            padding: 12px 15px;
            background: var(--bg-secondary);
            border: 1px solid var(--border-color);
            border-radius: 8px;
            color: var(--text-primary);
            font-size: 16px;
            font-family: inherit;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--accent);
            box-shadow: 0 0 0 3px rgba(74, 144, 217, 0.15);
        }

        /* Responsive */
        @media (max-width: 991px) {
            .sidebar {
                transform: translateX(-100%);
                z-index: 1000;
            }

            .sidebar.show {
                transform: translateX(0);
            }

            .sidebar-toggle {
                display: none;
            }

            .main-content {
                margin-left: 0;
            }

            body.sidebar-collapsed .main-content {
                margin-left: 0;
            }

            .mobile-menu-toggle {
                display: flex;
            }

            .sidebar-overlay {
                display: none;
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: rgba(0, 0, 0, 0.5);
                z-index: 999;
            }

            .sidebar-overlay.show {
                display: block;
            }

            .top-header {
                padding: 12px 15px;
            }

            .page-title {
                font-size: 18px;
            }

            .content {
                padding: 15px;
            }

            .stats-grid {
                grid-template-columns: 1fr;
                gap: 12px;
            }

            .stat-card {
                padding: 15px;
            }

            .stat-icon {
                width: 45px;
                height: 45px;
                font-size: 18px;
            }

            .stat-info h3 {
                font-size: 22px;
            }

            .stat-info p {
                font-size: 13px;
            }

            .card {
                border-radius: 12px;
            }

            .card-header {
                padding: 14px 15px;
                flex-wrap: wrap;
                gap: 10px;
            }

            .card-title {
                font-size: 16px;
            }

            .card-body {
                padding: 15px;
            }

            .btn {
                padding: 8px 14px;
                font-size: 14px;
            }

            .user-info {
                display: none;
            }

            .user-btn {
                padding: 8px 10px;
            }

            .header-actions {
                gap: 10px;
            }

            .theme-toggle {
                width: 36px;
                height: 36px;
            }

            .modal {
                margin: 15px;
                max-width: calc(100% - 30px);
            }

            .modal-header {
                padding: 14px 15px;
            }

            .modal-body {
                padding: 15px;
            }

            .modal-footer {
                padding: 12px 15px;
                flex-wrap: wrap;
            }

            .form-control {
                padding: 10px 12px;
                font-size: 15px;
            }
        }

        @media (max-width: 576px) {
            .page-title {
                font-size: 16px;
            }

            .stat-card {
                padding: 12px;
            }

            .stat-icon {
                width: 40px;
                height: 40px;
                font-size: 16px;
            }

            .stat-info h3 {
                font-size: 20px;
            }

            .btn {
                padding: 8px 12px;
                font-size: 13px;
            }

            .card-header {
                padding: 12px;
            }

            .card-body {
                padding: 12px;
            }

            .dropdown-menu {
                min-width: 150px;
            }

            .dropdown-menu a {
                padding: 10px 12px;
                font-size: 14px;
            }
        }

        /* Mobile Menu Toggle Button */
        .mobile-menu-toggle {
            display: none;
            width: 40px;
            height: 40px;
            border-radius: 10px;
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            color: var(--text-primary);
            cursor: pointer;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            transition: all 0.3s ease;
            flex-shrink: 0;
        }

        .mobile-menu-toggle:hover {
            background: var(--accent);
            color: white;
        }

        @media (max-width: 991px) {
            .mobile-menu-toggle {
                display: flex !important;
            }
        }
    </style>
</head>

<body>
    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar">
        <button class="sidebar-toggle" onclick="toggleSidebar()" title="ພັບ/ຂະຫຍາຍເມນູ">
            <i class="fas fa-chevron-left"></i>
        </button>
        <div class="sidebar-header">
            <div class="sidebar-logo">
                <i class="fas fa-store"></i>
            </div>
            <div class="sidebar-brand">
                <h2>EPCommerce</h2>
                <span>Admin Panel</span>
            </div>
        </div>

        <ul class="sidebar-menu">
            <!-- ໜ້າຫຼັກ -->
            <li class="menu-item">
                <a href="dashboard.php" class="<?= $current_page === 'dashboard' ? 'active' : '' ?>">
                    <i class="fas fa-home"></i>
                    <span>ໜ້າຫຼັກ</span>
                </a>
            </li>

            <!-- POS -->
            <li
                class="menu-item <?= in_array($current_page, ['pos', 'sales_history', 'edit_order', 'invoices', 'cancelled_orders']) ? 'open' : '' ?>">
                <a href="#" onclick="toggleSubmenu(this); return false;">
                    <i class="fas fa-cash-register"></i>
                    <span>POS</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <ul class="submenu">
                    <li><a href="pos.php" class="<?= $current_page === 'pos' ? 'active' : '' ?>"><i
                                class="fas fa-shopping-cart"></i> ລະບົບຂາຍ</a></li>
                    <li><a href="sales_history.php"
                            class="<?= in_array($current_page, ['sales_history', 'edit_order']) ? 'active' : '' ?>"><i
                                class="fas fa-history"></i> ປະຫວັດການຂາຍ</a></li>
                    <li><a href="cancelled_orders.php"
                            class="<?= $current_page === 'cancelled_orders' ? 'active' : '' ?>"><i
                                class="fas fa-ban"></i> ອໍເດີຍົກເລີກ/ຕີກັບ</a></li>
                    <li><a href="invoices.php" class="<?= $current_page === 'invoices' ? 'active' : '' ?>"><i
                                class="fas fa-file-invoice"></i> ໃບບິນທັງໝົດ</a></li>
                </ul>
            </li>

            <!-- ເພີ່ມຂໍ້ມູນ -->
            <li
                class="menu-item <?= in_array($current_page, ['customers', 'units', 'categories', 'colors', 'products', 'shipping_companies', 'shipping_branches']) ? 'open' : '' ?>">
                <a href="#" onclick="toggleSubmenu(this); return false;">
                    <i class="fas fa-plus-circle"></i>
                    <span>ເພີ່ມຂໍ້ມູນ</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <ul class="submenu">
                    <li><a href="customers.php" class="<?= $current_page === 'customers' ? 'active' : '' ?>"><i
                                class="fas fa-users"></i> ລູກຄ້າ</a></li>
                    <li><a href="units.php" class="<?= $current_page === 'units' ? 'active' : '' ?>"><i
                                class="fas fa-balance-scale"></i> ຫົວໜ່ວຍສິນຄ້າ</a></li>
                    <li><a href="categories.php" class="<?= $current_page === 'categories' ? 'active' : '' ?>"><i
                                class="fas fa-tags"></i> ປະເພດສິນຄ້າ</a></li>
                    <li><a href="colors.php" class="<?= $current_page === 'colors' ? 'active' : '' ?>"><i
                                class="fas fa-palette"></i> ສີສິນຄ້າ</a></li>
                    <li><a href="products.php" class="<?= $current_page === 'products' ? 'active' : '' ?>"><i
                                class="fas fa-box"></i> ສິນຄ້າ</a></li>
                    <li><a href="shipping_companies.php"
                            class="<?= $current_page === 'shipping_companies' ? 'active' : '' ?>"><i
                                class="fas fa-truck"></i> ບໍລິສັດຂົນສົ່ງ</a></li>
                    <li><a href="shipping_branches.php"
                            class="<?= $current_page === 'shipping_branches' ? 'active' : '' ?>"><i
                                class="fas fa-warehouse"></i> ສາຂາຂົນສົ່ງ</a></li>
                </ul>
            </li>

            <!-- ເພີ່ມລາຍຮັບ-ຈ່າຍອື່ນໆ -->
            <li class="menu-item <?= in_array($current_page, ['income', 'expense']) ? 'open' : '' ?>">
                <a href="#" onclick="toggleSubmenu(this); return false;">
                    <i class="fas fa-money-bill-wave"></i>
                    <span>ເພີ່ມລາຍຮັບ-ຈ່າຍອື່ນໆ</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <ul class="submenu">
                    <li><a href="income.php" class="<?= $current_page === 'income' ? 'active' : '' ?>"><i
                                class="fas fa-arrow-circle-down"></i> ລາຍຮັບ</a></li>
                    <li><a href="expense.php" class="<?= $current_page === 'expense' ? 'active' : '' ?>"><i
                                class="fas fa-arrow-circle-up"></i> ລາຍຈ່າຍ</a></li>
                </ul>
            </li>

            <!-- ສະຫຼຸບລາຍງານ -->
            <li
                class="menu-item <?= in_array($current_page, ['report_income', 'report_best_selling', 'report_not_selling', 'report_low_stock', 'tips']) ? 'open' : '' ?>">
                <a href="#" onclick="toggleSubmenu(this); return false;">
                    <i class="fas fa-chart-bar"></i>
                    <span>ສະຫຼຸບລາຍງານ</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <ul class="submenu">
                    <li><a href="report_income.php" class="<?= $current_page === 'report_income' ? 'active' : '' ?>"><i
                                class="fas fa-file-invoice-dollar"></i> ລາຍຮັບ-ຈ່າຍ</a></li>
                    <li><a href="tips.php" class="<?= $current_page === 'tips' ? 'active' : '' ?>"><i
                                class="fas fa-coins"></i> ເງິນ Tip (ເສດປັດ)</a></li>
                    <li><a href="report_best_selling.php"
                            class="<?= $current_page === 'report_best_selling' ? 'active' : '' ?>"><i
                                class="fas fa-fire"></i> ສິນຄ້າທີ່ຂາຍດີ</a></li>
                    <li><a href="report_not_selling.php"
                            class="<?= $current_page === 'report_not_selling' ? 'active' : '' ?>"><i
                                class="fas fa-ban"></i> ສິນຄ້າທີ່ບໍ່ໄດ້ຂາຍ</a></li>
                    <li><a href="report_low_stock.php"
                            class="<?= $current_page === 'report_low_stock' ? 'active' : '' ?>"><i
                                class="fas fa-exclamation-triangle"></i> ສິນຄ້າທີ່ໃກ້ຈະໝົດ</a></li>
                </ul>
            </li>

            <!-- ສ້າງໃບສັ່ງຊື້ສິນຄ້າ -->
            <li class="menu-item <?= in_array($current_page, ['purchase_order', 'purchase_history']) ? 'open' : '' ?>">
                <a href="#" onclick="toggleSubmenu(this); return false;">
                    <i class="fas fa-file-alt"></i>
                    <span>ສ້າງໃບສັ່ງຊື້ສິນຄ້າ</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <ul class="submenu">
                    <li><a href="purchase_order.php"
                            class="<?= $current_page === 'purchase_order' ? 'active' : '' ?>"><i
                                class="fas fa-print"></i> ພິມລາຍງານໃບສັ່ງຊື້ສິນຄ້າ</a></li>
                    <li><a href="purchase_history.php"
                            class="<?= $current_page === 'purchase_history' ? 'active' : '' ?>"><i
                                class="fas fa-history"></i> ປະຫວັດການສັ່ງຊື້ສິນຄ້າ</a></li>
                </ul>
            </li>

            <!-- ຕັ້ງຄ່າລະບົບ -->
            <li
                class="menu-item <?= in_array($current_page, ['users', 'currencies', 'shop_info', 'theme_settings']) ? 'open' : '' ?>">
                <a href="#" onclick="toggleSubmenu(this); return false;">
                    <i class="fas fa-cog"></i>
                    <span>ຕັ້ງຄ່າລະບົບ</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <ul class="submenu">
                    <li><a href="users.php" class="<?= $current_page === 'users' ? 'active' : '' ?>"><i
                                class="fas fa-user-cog"></i> ຈັດການຂໍ້ມູນຜູ້ໃຊ້</a></li>
                    <li><a href="currencies.php" class="<?= $current_page === 'currencies' ? 'active' : '' ?>"><i
                                class="fas fa-coins"></i> ສະກຸນເງິນຕາ</a></li>
                    <li><a href="shop_info.php" class="<?= $current_page === 'shop_info' ? 'active' : '' ?>"><i
                                class="fas fa-store"></i> ລາຍລະອຽດຮ້ານ</a></li>
                    <li><a href="theme_settings.php"
                            class="<?= $current_page === 'theme_settings' ? 'active' : '' ?>"><i
                                class="fas fa-paint-brush"></i> ຕັ້ມສີລະບົບ</a></li>
                </ul>
            </li>

            <!-- ອອກຈາກລະບົບ -->
            <li class="menu-item">
                <a href="../logout.php" class="danger">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>ອອກຈາກລະບົບ</span>
                </a>
            </li>
        </ul>
    </aside>

    <!-- Sidebar Overlay for Mobile -->
    <div class="sidebar-overlay" id="sidebarOverlay" onclick="closeMobileSidebar()"></div>

    <!-- Main Content -->
    <main class="main-content">
        <!-- Top Header -->
        <header class="top-header">
            <!-- Mobile Menu Toggle -->
            <button class="mobile-menu-toggle" onclick="toggleMobileSidebar()" title="ເມນູ">
                <i class="fas fa-bars"></i>
            </button>

            <h1 class="page-title">
                <?= $page_title ?? 'Dashboard' ?>
            </h1>

            <div class="header-actions">
                <button class="theme-toggle" onclick="toggleTheme()" title="ສະຫຼັບໂໝດສີ">
                    <i class="fas fa-moon" id="theme-icon"></i>
                </button>

                <div class="user-dropdown">
                    <button class="user-btn" onclick="toggleDropdown()">
                        <div class="user-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="user-info">
                            <div class="name">
                                <?= htmlspecialchars($_SESSION['username'] ?? 'Admin') ?>
                            </div>
                            <div class="role">
                                <?= htmlspecialchars($_SESSION['role_name'] ?? 'Admin') ?>
                            </div>
                        </div>
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="dropdown-menu" id="userDropdown">
                        <a href="profile.php"><i class="fas fa-user-circle"></i> ໂປຣໄຟລ໌</a>
                        <a href="settings.php"><i class="fas fa-cog"></i> ຕັ້ງຄ່າ</a>
                        <a href="../logout.php" class="danger"><i class="fas fa-sign-out-alt"></i> ອອກຈາກລະບົບ</a>
                    </div>
                </div>
            </div>
        </header>

        <!-- Page Content -->
        <div class="content" id="app-content">