</div>
</main>

<script src="assets/js/spa-navigation.js"></script>
<script>
    // Theme Management
    function getTheme() {
        return localStorage.getItem('epcommerce_theme') || 'dark';
    }

    function setTheme(theme) {
        document.documentElement.setAttribute('data-theme', theme);
        localStorage.setItem('epcommerce_theme', theme);
        updateThemeIcon(theme);
    }

    function updateThemeIcon(theme) {
        const icon = document.getElementById('theme-icon');
        if (theme === 'dark') {
            icon.className = 'fas fa-moon';
        } else {
            icon.className = 'fas fa-sun';
        }
    }

    function toggleTheme() {
        const currentTheme = getTheme();
        const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
        setTheme(newTheme);
    }

    // Color Theme Management
    function getColorTheme() {
        return localStorage.getItem('epcommerce_color_theme') || 'original';
    }

    function setColorTheme(theme) {
        document.documentElement.setAttribute('data-color-theme', theme);
        localStorage.setItem('epcommerce_color_theme', theme);
    }

    // Dropdown
    function toggleDropdown() {
        document.getElementById('userDropdown').classList.toggle('show');
    }

    // Close dropdown when clicking outside
    document.addEventListener('click', function (e) {
        if (!e.target.closest('.user-dropdown')) {
            document.getElementById('userDropdown').classList.remove('show');
        }
    });

    // Generic Modal functions (for modals that use id as parameter)
    function openGenericModal(modalId) {
        const modal = document.getElementById(modalId);
        if (modal) modal.classList.add('show');
    }

    function closeGenericModal(modalId) {
        const modal = document.getElementById(modalId);
        if (modal) modal.classList.remove('show');
    }

    // Submenu toggle (accordion - only one open at a time)
    function toggleSubmenu(element) {
        const menuItem = element.parentElement;
        const isOpen = menuItem.classList.contains('open');

        // Close all other open submenus first
        const allOpenMenus = document.querySelectorAll('.menu-item.open');
        allOpenMenus.forEach(function (item) {
            if (item !== menuItem) {
                item.classList.remove('open');
            }
        });

        // Toggle the clicked submenu
        menuItem.classList.toggle('open');
    }

    // Initialize theme on page load
    document.addEventListener('DOMContentLoaded', function () {
        setTheme(getTheme());

        // Restore sidebar state
        const sidebarCollapsed = localStorage.getItem('epcommerce_sidebar_collapsed') === 'true';
        if (sidebarCollapsed) {
            document.getElementById('sidebar').classList.add('collapsed');
            document.body.classList.add('sidebar-collapsed');
        }

        // Remove preload class to enable transitions
        // We use double requestAnimationFrame to ensure at least 2 frames have passed
        // This is critical for heavy pages to ensure the browser has fully painted the collapsed state
        requestAnimationFrame(() => {
            requestAnimationFrame(() => {
                document.documentElement.classList.remove('sidebar-preload-collapsed');

                // Increased timeout to 300ms to handle heavy data pages (tables/charts)
                // This gives the main thread time to settle layout before transitions are re-enabled
                setTimeout(() => {
                    document.documentElement.classList.remove('no-transitions');
                }, 300);
            });
        });
    });

    // Sidebar Toggle
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        sidebar.classList.toggle('collapsed');
        document.body.classList.toggle('sidebar-collapsed');

        // Save state
        const isCollapsed = sidebar.classList.contains('collapsed');
        localStorage.setItem('epcommerce_sidebar_collapsed', isCollapsed);
    }

    // Mobile Sidebar Toggle
    function toggleMobileSidebar() {
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebarOverlay');
        sidebar.classList.toggle('show');
        overlay.classList.toggle('show');
        document.body.style.overflow = sidebar.classList.contains('show') ? 'hidden' : '';
    }

    function closeMobileSidebar() {
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebarOverlay');
        sidebar.classList.remove('show');
        overlay.classList.remove('show');
        document.body.style.overflow = '';
    }

    // Close mobile sidebar on window resize (if going to desktop)
    window.addEventListener('resize', function () {
        if (window.innerWidth > 991) {
            closeMobileSidebar();
        }
    });

    // Position collapsed sidebar submenu popups
    document.addEventListener('DOMContentLoaded', function () {
        const menuItems = document.querySelectorAll('.sidebar .menu-item');

        menuItems.forEach(function (item) {
            item.addEventListener('mouseenter', function () {
                const sidebar = document.getElementById('sidebar');
                if (sidebar && sidebar.classList.contains('collapsed')) {
                    const submenu = item.querySelector('.submenu');
                    if (submenu) {
                        const itemRect = item.getBoundingClientRect();
                        submenu.style.top = itemRect.top + 'px';
                    }
                }
            });
        });
    });
</script>
</body>

</html>