<?php
$page_title = 'ລູກຄ້າ';

// Handle AJAX requests BEFORE any HTML output
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    @ob_end_clean();
    @ini_set('display_errors', 0);
    @error_reporting(0);
    if (session_status() === PHP_SESSION_NONE)
        @session_start();

    // Try multiple paths for database connection
    $db_paths = [__DIR__ . '/../includes/con_database.php', dirname(__FILE__) . '/../includes/con_database.php', $_SERVER['DOCUMENT_ROOT'] . '/epcommerce/includes/con_database.php'];
    foreach ($db_paths as $path) {
        if (file_exists($path)) {
            require_once $path;
            break;
        }
    }
    require_once __DIR__ . '/../includes/secondary_ids.php';

    header('Content-Type: application/json');

    $shop_id = $_SESSION['shop_id'] ?? null;
    $user_id = $_SESSION['user_id'] ?? null;
    $user_secondary_id = getUserSecondaryId($conn, $user_id);
    $action = $_POST['action'] ?? '';

    if (!$shop_id) {
        echo json_encode(['success' => false, 'message' => 'ກະລຸນາເລືອກຮ້ານກ່ອນ']);
        exit;
    }

    if ($action === 'add') {
        $stmt = $conn->prepare("INSERT INTO customers (shop_id, name, phone, email, address, notes, created_by) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("issssss", $shop_id, $_POST['name'], $_POST['phone'], $_POST['email'], $_POST['address'], $_POST['notes'], $user_secondary_id);
        echo json_encode(['success' => $stmt->execute(), 'message' => 'ເພີ່ມລູກຄ້າສຳເລັດ']);
        exit;
    }

    if ($action === 'edit') {
        $stmt = $conn->prepare("UPDATE customers SET name = ?, phone = ?, email = ?, address = ?, notes = ?, updated_by = ? WHERE id = ? AND shop_id = ?");
        $stmt->bind_param("ssssssis", $_POST['name'], $_POST['phone'], $_POST['email'], $_POST['address'], $_POST['notes'], $user_secondary_id, $_POST['id'], $shop_id);
        echo json_encode(['success' => $stmt->execute(), 'message' => 'ແກ້ໄຂສຳເລັດ']);
        exit;
    }

    if ($action === 'delete') {
        $stmt = $conn->prepare("UPDATE customers SET deleted_at = NOW(), deleted_by = ? WHERE id = ? AND shop_id = ?");
        $stmt->bind_param("sii", $user_secondary_id, $_POST['id'], $shop_id);
        echo json_encode(['success' => $stmt->execute(), 'message' => 'ລຶບສຳເລັດ']);
        exit;
    }

    // Get customer orders
    if ($action === 'get_orders') {
        $cu_id = $_POST['cu_id'] ?? '';
        if (!$cu_id) {
            echo json_encode(['success' => false, 'message' => 'ບໍ່ພົບ CU_id']);
            exit;
        }

        $stmt = $conn->prepare("
            SELECT o.*, 
                   c.currencys_symbol,
                   sc.company_name as shipping_company_name,
                   sb.branch_name as shipping_branch_name
            FROM orders o
            LEFT JOIN currencys c ON o.currencys_id = c.currencys_id
            LEFT JOIN shipping_companies sc ON o.shipping_company_id = sc.SC_id
            LEFT JOIN shipping_branches sb ON o.shipping_branch_id = sb.SB_id
            WHERE o.customer_id = ? AND o.shop_id = ? AND o.deleted_at IS NULL
            ORDER BY o.order_date DESC
        ");
        $stmt->bind_param("si", $cu_id, $shop_id);
        $stmt->execute();
        $orders = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

        echo json_encode(['success' => true, 'orders' => $orders]);
        exit;
    }
}

require_once 'includes/header.php';

$shop_id = $_SESSION['shop_id'] ?? null;
$user_id = $_SESSION['user_id'] ?? null;

$customers = [];
if ($shop_id) {
    $search = $_GET['q'] ?? '';
    $sql = "SELECT c.*, 
                   COALESCE(order_counts.total_orders, 0) as order_count,
                   COALESCE(order_counts.total_spent, 0) as total_spent
            FROM customers c
            LEFT JOIN (
                SELECT customer_id, 
                       COUNT(*) as total_orders,
                       SUM(total_amount_lak) as total_spent
                FROM orders 
                WHERE shop_id = ? AND deleted_at IS NULL
                GROUP BY customer_id
            ) order_counts ON c.CU_id = order_counts.customer_id
            WHERE c.shop_id = ? AND c.deleted_at IS NULL";
    if ($search)
        $sql .= " AND (c.name LIKE ? OR c.phone LIKE ? OR c.email LIKE ?)";
    $sql .= " ORDER BY c.created_at ASC";

    $stmt = $conn->prepare($sql);
    if ($search) {
        $s = "%$search%";
        $stmt->bind_param("iisss", $shop_id, $shop_id, $s, $s, $s);
    } else {
        $stmt->bind_param("ii", $shop_id, $shop_id);
    }
    $stmt->execute();
    $customers = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}
?>

<style>
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px
    }

    .page-header h1 {
        font-size: 24px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 12px;
        margin: 0
    }

    .page-header h1 i {
        color: var(--accent)
    }

    .stats-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 16px;
        margin-bottom: 24px
    }

    .mini-stat {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 12px;
        padding: 20px;
        display: flex;
        align-items: center;
        gap: 16px
    }

    .mini-stat .icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        color: #fff
    }

    .mini-stat .icon.blue {
        background: linear-gradient(135deg, #4A90D9, #2D5A87)
    }

    .mini-stat .info h3 {
        font-size: 24px;
        margin: 0
    }

    .mini-stat .info p {
        color: var(--text-secondary);
        margin: 0;
        font-size: 13px
    }

    .data-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        overflow: hidden
    }

    .data-card-header {
        padding: 20px 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 16px
    }

    .search-box {
        display: flex;
        align-items: center;
        gap: 8px;
        background: var(--input-bg);
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 8px 12px;
        width: 300px;
        max-width: 100%
    }

    .search-box input {
        border: none;
        background: transparent;
        outline: none;
        color: var(--text-primary);
        width: 100%;
        font-size: 14px
    }

    .pro-table {
        width: 100%;
        border-collapse: collapse
    }

    .pro-table th {
        background: rgba(var(--accent-rgb), 0.1);
        padding: 14px 16px;
        text-align: left;
        font-weight: 600;
        font-size: 13px;
        text-transform: uppercase;
        color: var(--text-secondary);
        white-space: nowrap
    }

    .pro-table td {
        padding: 16px;
        border-bottom: 1px solid var(--border-color);
        vertical-align: middle
    }

    .pro-table tbody tr:hover {
        background: rgba(var(--accent-rgb), 0.05)
    }

    .pro-table tbody tr:last-child td {
        border-bottom: none
    }

    .customer-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: var(--accent);
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        font-weight: 600
    }

    .action-btns {
        display: flex;
        gap: 8px
    }

    .btn-icon {
        width: 36px;
        height: 36px;
        border-radius: 8px;
        border: none;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all .2s;
        font-size: 14px
    }

    .btn-icon.view-orders {
        background: linear-gradient(135deg, rgba(40, 167, 69, .15), rgba(32, 201, 151, .15));
        color: #28a745
    }

    .btn-icon.view-orders:hover {
        background: linear-gradient(135deg, #28a745, #20c997);
        color: #fff;
        transform: scale(1.1)
    }

    .btn-icon.edit {
        background: rgba(255, 193, 7, .15);
        color: #ffc107
    }

    .btn-icon.edit:hover {
        background: #ffc107;
        color: #000
    }

    .btn-icon.delete {
        background: rgba(220, 53, 69, .15);
        color: #dc3545
    }

    .btn-icon.delete:hover {
        background: #dc3545;
        color: #fff
    }

    /* Order Count Badge */
    .order-badge {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 13px;
        font-weight: 600;
        cursor: pointer;
        transition: all .3s;
        background: linear-gradient(135deg, rgba(74, 144, 217, .1), rgba(40, 167, 69, .1));
        border: 1px solid rgba(74, 144, 217, .2);
        color: var(--accent);
        text-decoration: none
    }

    .order-badge:hover {
        background: linear-gradient(135deg, var(--accent), #20c997);
        color: #fff;
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(74, 144, 217, .3)
    }

    .order-badge i {
        font-size: 12px
    }

    .order-badge .count {
        background: rgba(255, 255, 255, .2);
        padding: 2px 8px;
        border-radius: 12px;
        font-size: 12px
    }

    .order-badge:hover .count {
        background: rgba(255, 255, 255, .3)
    }

    .no-orders {
        color: var(--text-secondary);
        font-size: 13px;
        font-style: italic
    }

    .btn-pro {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 12px 24px;
        border-radius: 10px;
        border: none;
        font-weight: 600;
        cursor: pointer;
        transition: all .3s;
        font-size: 14px
    }

    .btn-pro.primary {
        background: linear-gradient(135deg, var(--accent), var(--accent-soft));
        color: #fff;
        box-shadow: 0 4px 15px rgba(74, 144, 217, .3)
    }

    .pro-modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, .6);
        backdrop-filter: blur(4px);
        z-index: 9999;
        align-items: center;
        justify-content: center;
        padding: 20px
    }

    .pro-modal.show {
        display: flex
    }

    .pro-modal-content {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 20px;
        width: 100%;
        max-width: 550px;
        max-height: 90vh;
        overflow-y: auto;
        animation: modalSlide .3s ease
    }

    @keyframes modalSlide {
        from {
            opacity: 0;
            transform: translateY(-20px) scale(.95)
        }

        to {
            opacity: 1;
            transform: translateY(0) scale(1)
        }
    }

    .pro-modal-header {
        padding: 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center
    }

    .pro-modal-header h3 {
        margin: 0;
        font-size: 20px;
        display: flex;
        align-items: center;
        gap: 10px
    }

    .pro-modal-header h3 i {
        color: var(--accent)
    }

    .pro-modal-close {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        border: none;
        background: rgba(255, 255, 255, .1);
        color: var(--text-secondary);
        cursor: pointer;
        font-size: 18px
    }

    .pro-modal-body {
        padding: 24px
    }

    .pro-modal-footer {
        padding: 20px 24px;
        border-top: 1px solid var(--border-color);
        display: flex;
        gap: 12px;
        justify-content: flex-end
    }

    .form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 16px
    }

    .form-pro-group {
        margin-bottom: 20px
    }

    .form-pro-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 500
    }

    .form-pro-group label span {
        color: #dc3545
    }

    .form-pro-input {
        width: 100%;
        padding: 14px 16px;
        border: 2px solid var(--border-color);
        border-radius: 10px;
        background: var(--input-bg);
        color: var(--text-primary);
        font-size: 15px;
        transition: all .2s
    }

    .form-pro-input:focus {
        outline: none;
        border-color: var(--accent)
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: var(--text-secondary)
    }

    .empty-state i {
        font-size: 64px;
        opacity: .3;
        margin-bottom: 20px
    }

    @media(max-width:768px) {
        .page-header {
            flex-direction: column;
            align-items: flex-start
        }

        .search-box {
            width: 100%
        }

        .pro-table {
            display: block;
            overflow-x: auto
        }

        .form-row {
            grid-template-columns: 1fr
        }
    }
</style>

<?php if (!$shop_id): ?>
    <div class="empty-state"><i class="fas fa-store-slash"></i>
        <h4>ກະລຸນາເລືອກຮ້ານກ່ອນ</h4>
    </div>
<?php else: ?>

    <div class="page-header">
        <h1><i class="fas fa-users"></i> ລູກຄ້າ</h1>
        <button class="btn-pro primary" onclick="openModal('add')"><i class="fas fa-plus"></i> ເພີ່ມລູກຄ້າໃໝ່</button>
    </div>

    <div class="stats-row">
        <div class="mini-stat">
            <div class="icon blue"><i class="fas fa-users"></i></div>
            <div class="info">
                <h3><?= count($customers) ?></h3>
                <p>ລູກຄ້າທັງໝົດ</p>
            </div>
        </div>
    </div>

    <div class="data-card">
        <div class="data-card-header">
            <h3><i class="fas fa-list"></i> ລາຍການລູກຄ້າ</h3>
            <form method="GET" class="search-box">
                <i class="fas fa-search"></i>
                <input type="text" name="q" placeholder="ຄົ້ນຫາຊື່, ເບີໂທ, ອີເມວ..."
                    value="<?= htmlspecialchars($_GET['q'] ?? '') ?>">
            </form>
        </div>

        <?php if (empty($customers)): ?>
            <div class="empty-state"><i class="fas fa-inbox"></i>
                <h4>ຍັງບໍ່ມີລູກຄ້າ</h4>
            </div>
        <?php else: ?>
            <div style="overflow-x:auto">
                <table class="pro-table" id="dataTable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>ລູກຄ້າ</th>
                            <th>ເບີໂທ</th>
                            <th>ອີເມວ</th>
                            <th>ທີ່ຢູ່</th>
                            <th>ອໍເດີ</th>
                            <th>ຈັດການ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($customers as $i => $c): ?>
                            <tr>
                                <td><?= $i + 1 ?></td>
                                <td>
                                    <div style="display:flex;align-items:center;gap:12px">
                                        <div class="customer-avatar"><?= strtoupper(substr($c['name'], 0, 1)) ?></div>
                                        <div>
                                            <strong><?= htmlspecialchars($c['name']) ?></strong>
                                            <div style="font-size:12px;color:var(--text-secondary)"><?= $c['CU_id'] ?></div>
                                        </div>
                                    </div>
                                </td>
                                <td><?= htmlspecialchars($c['phone'] ?? '-') ?></td>
                                <td><?= htmlspecialchars($c['email'] ?? '-') ?></td>
                                <td style="max-width:200px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap">
                                    <?= htmlspecialchars($c['address'] ?? '-') ?>
                                </td>
                                <td>
                                    <?php if ($c['order_count'] > 0): ?>
                                        <a href="sales_history.php?search=<?= urlencode($c['CU_id']) ?>&date_from=&date_to="
                                            class="order-badge">
                                            <i class="fas fa-shopping-bag"></i>
                                            <span class="count"><?= $c['order_count'] ?></span>
                                            ອໍເດີ
                                        </a>
                                    <?php else: ?>
                                        <span class="no-orders"><i class="fas fa-inbox"></i> ຍັງບໍ່ມີ</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="action-btns">
                                        <button class="btn-icon edit"
                                            onclick="openModal('edit', <?= htmlspecialchars(json_encode($c)) ?>)"><i
                                                class="fas fa-pen"></i></button>
                                        <button class="btn-icon delete"
                                            onclick="confirmDelete(<?= $c['id'] ?>, '<?= htmlspecialchars($c['name']) ?>')"><i
                                                class="fas fa-trash"></i></button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>

    <div class="pro-modal" id="formModal">
        <div class="pro-modal-content">
            <div class="pro-modal-header">
                <h3><i class="fas fa-user"></i> <span id="modalTitle">ເພີ່ມລູກຄ້າ</span></h3>
                <button class="pro-modal-close" onclick="closeModal()">&times;</button>
            </div>
            <form id="dataForm">
                <div class="pro-modal-body">
                    <input type="hidden" name="action" id="formAction" value="add">
                    <input type="hidden" name="id" id="formId">

                    <div class="form-pro-group">
                        <label>ຊື່ລູກຄ້າ <span>*</span></label>
                        <input type="text" name="name" id="name" class="form-pro-input" required placeholder="ຊື່-ນາມສະກຸນ">
                    </div>

                    <div class="form-row">
                        <div class="form-pro-group">
                            <label>ເບີໂທ</label>
                            <input type="text" name="phone" id="phone" class="form-pro-input" placeholder="020 XXXX XXXX">
                        </div>
                        <div class="form-pro-group">
                            <label>ອີເມວ</label>
                            <input type="email" name="email" id="email" class="form-pro-input"
                                placeholder="email@example.com">
                        </div>
                    </div>

                    <div class="form-pro-group">
                        <label>ທີ່ຢູ່</label>
                        <textarea name="address" id="address" class="form-pro-input" rows="2"
                            placeholder="ບ້ານ, ເມືອງ, ແຂວງ"></textarea>
                    </div>

                    <div class="form-pro-group">
                        <label>ໝາຍເຫດ</label>
                        <textarea name="notes" id="notes" class="form-pro-input" rows="2"
                            placeholder="ບັນທຶກເພີ່ມເຕີມ..."></textarea>
                    </div>
                </div>
                <div class="pro-modal-footer">
                    <button type="button" class="btn-pro" style="background:var(--border-color);color:var(--text-primary)"
                        onclick="closeModal()">ຍົກເລີກ</button>
                    <button type="submit" class="btn-pro primary"><i class="fas fa-save"></i> ບັນທຶກ</button>
                </div>
            </form>
        </div>
    </div>

<?php endif; ?>
<?php require_once 'includes/footer.php'; ?>

<?php if ($shop_id): ?>
    <script>
        function openModal(mode, data = null) {
            document.getElementById('dataForm').reset();
            document.getElementById('formId').value = '';
            if (mode === 'add') {
                document.getElementById('modalTitle').textContent = 'ເພີ່ມລູກຄ້າໃໝ່';
                document.getElementById('formAction').value = 'add';
            } else {
                document.getElementById('modalTitle').textContent = 'ແກ້ໄຂລູກຄ້າ';
                document.getElementById('formAction').value = 'edit';
                document.getElementById('formId').value = data.id;
                document.getElementById('name').value = data.name;
                document.getElementById('phone').value = data.phone || '';
                document.getElementById('email').value = data.email || '';
                document.getElementById('address').value = data.address || '';
                document.getElementById('notes').value = data.notes || '';
            }
            document.getElementById('formModal').classList.add('show');
        }

        function closeModal() { document.getElementById('formModal').classList.remove('show'); }
        document.getElementById('formModal').addEventListener('click', function (e) { if (e.target === this) closeModal(); });

        document.getElementById('dataForm').addEventListener('submit', async function (e) {
            e.preventDefault();
            closeModal();
            Swal.fire({ title: 'ກຳລັງບັນທຶກ...', text: 'ກະລຸນາລໍຖ້າ', allowOutsideClick: false, showConfirmButton: false, didOpen: () => Swal.showLoading() });
            try {
                const response = await fetch('customers.php', { method: 'POST', body: new FormData(this) });
                const data = await response.json();
                if (data.success) {
                    await Swal.fire({ icon: 'success', title: 'ສຳເລັດ!', timer: 1500, timerProgressBar: true, showConfirmButton: false });
                    location.reload();
                } else {
                    Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: data.message });
                }
            } catch (error) {
                Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: 'ການເຊື່ອມຕໍ່ມີປັນຫາ' });
            }
        });

        async function confirmDelete(id, name) {
            const result = await Swal.fire({
                title: 'ຢືນຢັນການລຶບ?', html: `ລຶບລູກຄ້າ <strong>"${name}"</strong> ແທ້ບໍ?`, icon: 'warning',
                showCancelButton: true, confirmButtonColor: '#dc3545', confirmButtonText: '<i class="fas fa-trash"></i> ລຶບ', cancelButtonText: 'ຍົກເລີກ', reverseButtons: true
            });
            if (result.isConfirmed) {
                Swal.fire({ title: 'ກຳລັງລຶບ...', allowOutsideClick: false, showConfirmButton: false, didOpen: () => Swal.showLoading() });
                try {
                    const fd = new FormData(); fd.append('action', 'delete'); fd.append('id', id);
                    const response = await fetch('customers.php', { method: 'POST', body: fd });
                    const data = await response.json();
                    if (data.success) {
                        await Swal.fire({ icon: 'success', title: 'ລຶບສຳເລັດ!', timer: 1500, showConfirmButton: false });
                        location.reload();
                    } else {
                        Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: data.message });
                    }
                } catch (error) {
                    Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: 'ການເຊື່ອມຕໍ່ມີປັນຫາ' });
                }
            }
        }
    </script>
<?php endif; ?>