<?php
session_start();
// Error handling
ini_set('display_errors', 0);
error_reporting(0);

// Check login
if (!isset($_SESSION['user_id'])) {
    header("Location: ../index.php");
    exit();
}

// Connect to database first for POST requests
require_once '../includes/con_database.php';

// Get Shop ID
$shop_id = $_SESSION['shop_id'] ?? 0;

// Handle POST actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Ensure no previous output
    ob_clean();
    header('Content-Type: application/json');
    $response = ['success' => false, 'message' => 'Unknown action'];

    if (!$shop_id) {
        echo json_encode(['success' => false, 'message' => 'Session Expired or No Shop Selected']);
        exit();
    }

    try {
        $action = $_POST['action'] ?? '';

        // --- CURRENCY ACTIONS ---
        if ($action === 'add_currency') {
            $name = trim($_POST['currencys_name']);
            $fullname = trim($_POST['currencys_fullname']);
            $symbol = trim($_POST['currencys_symbol']);
            $base = 'NO'; // Default

            // Check duplicate
            $stmt = $conn->prepare("SELECT id FROM currencys WHERE (currencys_name = ? OR currencys_symbol = ?) AND shop_id = ?");
            $stmt->bind_param("ssi", $name, $symbol, $shop_id);
            $stmt->execute();
            if ($stmt->get_result()->num_rows > 0) {
                throw new Exception("ມີສະກຸນເງິນນີ້ໃນລະບົບແລ້ວ");
            }

            // Insert
            $stmt = $conn->prepare("INSERT INTO currencys (currencys_name, currencys_fullname, currencys_symbol, base_currency, shop_id) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("ssssi", $name, $fullname, $symbol, $base, $shop_id);
            if ($stmt->execute()) {
                $response = ['success' => true, 'message' => 'ເພີ່ມສະກຸນເງິນສຳເລັດແລ້ວ'];
            } else {
                throw new Exception($conn->error);
            }
        } elseif ($action === 'edit_currency') {
            $id = intval($_POST['currency_id']);
            $name = trim($_POST['currencys_name']);
            $fullname = trim($_POST['currencys_fullname']);
            $symbol = trim($_POST['currencys_symbol']);

            // Check duplicate
            $stmt = $conn->prepare("SELECT id FROM currencys WHERE (currencys_name = ? OR currencys_symbol = ?) AND id != ? AND shop_id = ?");
            $stmt->bind_param("ssii", $name, $symbol, $id, $shop_id);
            $stmt->execute();
            if ($stmt->get_result()->num_rows > 0) {
                throw new Exception("ມີສະກຸນເງິນນີ້ໃນລະບົບແລ້ວ");
            }

            $stmt = $conn->prepare("UPDATE currencys SET currencys_name = ?, currencys_fullname = ?, currencys_symbol = ? WHERE id = ? AND shop_id = ?");
            $stmt->bind_param("sssii", $name, $fullname, $symbol, $id, $shop_id);
            if ($stmt->execute()) {
                $response = ['success' => true, 'message' => 'ແກ້ໄຂສະກຸນເງິນສຳເລັດແລ້ວ'];
            } else {
                throw new Exception($conn->error);
            }
        } elseif ($action === 'delete_currency') {
            $id = intval($_POST['currency_id']);

            // Check usage in rates
            $stmt = $conn->prepare("SELECT COUNT(*) as count FROM rates WHERE currencys_id = (SELECT currencys_id FROM currencys WHERE id = ? AND shop_id = ?) AND shop_id = ?");
            $stmt->bind_param("iii", $id, $shop_id, $shop_id);
            $stmt->execute();
            if ($stmt->get_result()->fetch_assoc()['count'] > 0) {
                throw new Exception("ບໍ່ສາມາດລຶບໄດ້ເພາະມີການໃຊ້ງານໃນອັດຕາແລກປ່ຽນ");
            }

            $stmt = $conn->prepare("DELETE FROM currencys WHERE id = ? AND shop_id = ?");
            $stmt->bind_param("ii", $id, $shop_id);
            if ($stmt->execute()) {
                $response = ['success' => true, 'message' => 'ລຶບສະກຸນເງິນສຳເລັດແລ້ວ'];
            } else {
                throw new Exception($conn->error);
            }
        }

        // --- RATE ACTIONS ---
        elseif ($action === 'add_rate') {
            $curr_id = trim($_POST['currencys_id']);
            $amount = floatval($_POST['rate_amount']);
            $date = date('Y-m-d');
            $datetime = date('Y-m-d H:i:s');

            if ($amount <= 0)
                throw new Exception("ກະລຸນາໃສ່ອັດຕາແລກປ່ຽນທີ່ຖືກຕ້ອງ");

            $stmt = $conn->prepare("INSERT INTO rates (currencys_id, rate_amount, rate_date, rate_datetime, shop_id) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("sdssi", $curr_id, $amount, $date, $datetime, $shop_id);
            if ($stmt->execute()) {
                $response = ['success' => true, 'message' => 'ເພີ່ມອັດຕາແລກປ່ຽນສຳເລັດແລ້ວ'];
            } else {
                throw new Exception($conn->error);
            }
        } elseif ($action === 'edit_rate') {
            $id = intval($_POST['rate_id_edit']);
            $curr_id = trim($_POST['currencys_id']);
            $amount = floatval($_POST['rate_amount']);
            $date = date('Y-m-d');
            $datetime = date('Y-m-d H:i:s');

            if ($amount <= 0)
                throw new Exception("ກະລຸນາໃສ່ອັດຕາແລກປ່ຽນທີ່ຖືກຕ້ອງ");

            $stmt = $conn->prepare("UPDATE rates SET currencys_id = ?, rate_amount = ?, rate_date = ?, rate_datetime = ? WHERE id = ? AND shop_id = ?");
            $stmt->bind_param("sdssii", $curr_id, $amount, $date, $datetime, $id, $shop_id);
            if ($stmt->execute()) {
                $response = ['success' => true, 'message' => 'ແກ້ໄຂອັດຕາແລກປ່ຽນສຳເລັດແລ້ວ'];
            } else {
                throw new Exception($conn->error);
            }
        } elseif ($action === 'delete_rate') {
            $id = intval($_POST['rate_id']);
            $stmt = $conn->prepare("DELETE FROM rates WHERE id = ? AND shop_id = ?");
            $stmt->bind_param("ii", $id, $shop_id);
            if ($stmt->execute()) {
                $response = ['success' => true, 'message' => 'ລຶບອັດຕາແລກປ່ຽນສຳເລັດແລ້ວ'];
            } else {
                throw new Exception($conn->error);
            }
        }

    } catch (Exception $e) {
        $response['message'] = $e->getMessage();
    }

    echo json_encode($response);
    exit();
}

require_once 'includes/header.php';

if (!$shop_id) {
    echo "<script>Swal.fire('Error', 'Session Expired or No Shop Selected', 'error');</script>";
    exit();
}

// Fetch Data
$stmt = $conn->prepare("SELECT * FROM currencys WHERE shop_id = ? ORDER BY currencys_name");
$stmt->bind_param("i", $shop_id);
$stmt->execute();
$currencies = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

$stmt = $conn->prepare("SELECT r.*, c.currencys_name, c.currencys_symbol, c.currencys_fullname 
    FROM rates r 
    LEFT JOIN currencys c ON r.currencys_id = c.currencys_id 
    WHERE r.shop_id = ? AND c.shop_id = ?
    ORDER BY r.rate_datetime ASC");
$stmt->bind_param("ii", $shop_id, $shop_id);
$stmt->execute();
$rates = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

$stmt = $conn->prepare("SELECT r.*, c.currencys_symbol 
    FROM rates r 
    JOIN (SELECT MAX(id) as max_id FROM rates WHERE shop_id = ? GROUP BY currencys_id) latest ON r.id = latest.max_id
    LEFT JOIN currencys c ON r.currencys_id = c.currencys_id
    WHERE r.shop_id = ? AND c.shop_id = ?");
$stmt->bind_param("iii", $shop_id, $shop_id, $shop_id);
$stmt->execute();
$latest_rates = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
?>

<style>
    /* Premium CSS Styles */
    :root {
        --glass-bg: rgba(255, 255, 255, 0.05);
        --glass-border: rgba(255, 255, 255, 0.1);
        --glass-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.37);
    }

    [data-theme="light"] {
        --glass-bg: #fff;
        --glass-border: #e0e0e0;
        --glass-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
    }

    /* Layout Utilities */
    .d-flex {
        display: flex;
    }

    .justify-between {
        justify-content: space-between;
    }

    .align-center {
        align-items: center;
    }

    .gap-10 {
        gap: 10px;
    }

    .gap-20 {
        gap: 20px;
    }

    .mb-20 {
        margin-bottom: 20px;
    }

    .mt-20 {
        margin-top: 20px;
    }

    .w-100 {
        width: 100%;
    }

    .grid-container {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
        gap: 20px;
    }

    .row {
        display: flex;
        flex-wrap: wrap;
        margin: -10px;
    }

    .col-6 {
        width: 50%;
        padding: 10px;
    }

    @media (max-width: 768px) {
        .col-6 {
            width: 100%;
        }

        .grid-container {
            grid-template-columns: 1fr;
        }
    }

    /* Cards */
    .premium-card {
        background: var(--card-bg, #1e1e1e);
        border: 1px solid var(--border-color, #333);
        border-radius: 16px;
        padding: 24px;
        box-shadow: var(--glass-shadow);
        backdrop-filter: blur(4px);
        margin-bottom: 20px;
    }

    .card-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
        border-bottom: 1px solid var(--border-color, #333);
        padding-bottom: 15px;
    }

    .card-title {
        font-size: 18px;
        font-weight: 600;
        color: var(--text-primary);
        display: flex;
        align-items: center;
        gap: 10px;
    }

    /* Tabs */
    .tabs-nav {
        display: flex;
        gap: 10px;
        margin-bottom: 20px;
        border-bottom: 1px solid var(--border-color, #333);
        padding-bottom: 10px;
    }

    .tab-btn {
        background: transparent;
        border: none;
        color: var(--text-secondary);
        padding: 10px 20px;
        font-size: 16px;
        font-weight: 500;
        cursor: pointer;
        position: relative;
        transition: all 0.3s;
        border-radius: 8px;
    }

    .tab-btn:hover {
        background: rgba(var(--accent-rgb), 0.1);
        color: var(--accent);
    }

    .tab-btn.active {
        color: var(--accent);
        background: rgba(var(--accent-rgb), 0.15);
    }

    .tab-btn.active::after {
        content: '';
        position: absolute;
        bottom: -11px;
        left: 0;
        width: 100%;
        height: 2px;
        background: var(--accent);
    }

    .tab-pane {
        display: none;
        animation: slideUp 0.3s ease;
    }

    .tab-pane.active {
        display: block;
    }

    @keyframes slideUp {
        from {
            opacity: 0;
            transform: translateY(10px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Tables */
    .premium-table {
        width: 100%;
        border-collapse: collapse;
    }

    .premium-table th {
        text-align: left;
        padding: 15px;
        color: var(--text-secondary);
        font-weight: 600;
        border-bottom: 1px solid var(--border-color);
        background: rgba(0, 0, 0, 0.02);
    }

    .premium-table td {
        padding: 15px;
        border-bottom: 1px solid var(--border-color);
        color: var(--text-primary);
    }

    .premium-table tr:hover td {
        background: rgba(255, 255, 255, 0.03);
    }

    /* Buttons */
    .btn {
        padding: 10px 20px;
        border-radius: 10px;
        border: none;
        font-weight: 600;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        transition: all 0.2s;
        font-size: 14px;
        text-decoration: none;
    }

    .btn-primary {
        background: var(--accent);
        color: white;
        box-shadow: 0 4px 15px rgba(var(--accent-rgb), 0.3);
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(var(--accent-rgb), 0.4);
    }

    .btn-icon {
        width: 36px;
        height: 36px;
        border-radius: 8px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        border: none;
        cursor: pointer;
        transition: all 0.2s;
        margin-left: 5px;
    }

    .btn-edit {
        background: rgba(255, 193, 7, 0.2);
        color: #ffc107;
    }

    .btn-edit:hover {
        background: #ffc107;
        color: #000;
    }

    .btn-delete {
        background: rgba(220, 53, 69, 0.2);
        color: #dc3545;
    }

    .btn-delete:hover {
        background: #dc3545;
        color: white;
    }

    /* Forms */
    .form-group {
        margin-bottom: 15px;
    }

    .form-label {
        display: block;
        margin-bottom: 8px;
        color: var(--text-secondary);
        font-weight: 500;
    }

    .form-control {
        width: 100%;
        padding: 12px 15px;
        border-radius: 10px;
        background: var(--bg-primary);
        border: 2px solid var(--border-color);
        color: var(--text-primary);
        font-size: 14px;
        transition: border-color 0.2s;
    }

    .form-control:focus {
        border-color: var(--accent);
        outline: none;
    }

    /* Modals */
    .modal-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.6);
        backdrop-filter: blur(5px);
        z-index: 1000;
        display: none;
        align-items: center;
        justify-content: center;
    }

    .modal-overlay.show {
        display: flex;
    }

    .modal-container {
        background: var(--card-bg);
        width: 100%;
        max-width: 500px;
        border-radius: 20px;
        border: 1px solid var(--border-color);
        box-shadow: 0 20px 50px rgba(0, 0, 0, 0.3);
        transform: scale(0.9);
        opacity: 0;
        transition: all 0.3s;
        overflow: hidden;
    }

    .modal-overlay.show .modal-container {
        transform: scale(1);
        opacity: 1;
    }

    .modal-header {
        padding: 20px 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .modal-body {
        padding: 24px;
    }

    .modal-footer {
        padding: 20px 24px;
        border-top: 1px solid var(--border-color);
        display: flex;
        justify-content: flex-end;
        gap: 10px;
    }

    .btn-close {
        background: transparent;
        border: none;
        color: var(--text-secondary);
        font-size: 20px;
        cursor: pointer;
    }

    /* Rate Cards - Premium Theme-Aware Design */
    .rate-card {
        background: linear-gradient(135deg, var(--primary-light, #003366) 0%, var(--primary, #001E3F) 100%);
        color: white;
        padding: 24px;
        border-radius: 20px;
        position: relative;
        overflow: hidden;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        border: 1px solid rgba(255, 255, 255, 0.1);
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
    }

    .rate-card::before {
        content: '';
        position: absolute;
        top: -50%;
        right: -50%;
        width: 100%;
        height: 100%;
        background: radial-gradient(circle, rgba(255, 255, 255, 0.1) 0%, transparent 60%);
        transition: all 0.5s;
    }

    .rate-card:hover {
        transform: translateY(-8px) scale(1.02);
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.4);
    }

    .rate-card:hover::before {
        top: -30%;
        right: -30%;
    }

    .rate-symbol {
        font-size: 48px;
        font-weight: 800;
        opacity: 0.15;
        position: absolute;
        top: 15px;
        right: 20px;
        font-family: 'Courier New', monospace;
    }

    .rate-value {
        font-size: 32px;
        font-weight: 800;
        margin: 15px 0;
        text-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
    }

    .rate-sub {
        background: rgba(255, 255, 255, 0.15);
        backdrop-filter: blur(10px);
        padding: 6px 14px;
        border-radius: 20px;
        font-size: 12px;
        display: inline-block;
        font-weight: 500;
    }

    .rate-badge {
        position: absolute;
        top: 15px;
        right: 15px;
        display: flex;
        align-items: center;
        gap: 5px;
        background: rgba(0, 0, 0, 0.2);
        padding: 5px 10px;
        border-radius: 20px;
        font-size: 11px;
    }

    .rate-bottom {
        border-top: 1px solid rgba(255, 255, 255, 0.15);
        margin-top: 20px;
        padding-top: 15px;
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 10px;
    }

    .rate-bottom-item {
        background: rgba(255, 255, 255, 0.08);
        padding: 10px 12px;
        border-radius: 10px;
        text-align: center;
    }

    .rate-bottom-item small {
        display: block;
        opacity: 0.7;
        font-size: 11px;
        margin-bottom: 4px;
    }

    .rate-bottom-item strong {
        font-size: 14px;
    }

    .empty-state {
        text-align: center;
        padding: 60px 40px;
        color: var(--text-secondary);
    }

    .empty-state i {
        font-size: 60px;
        margin-bottom: 20px;
        opacity: 0.3;
    }

    .empty-state p {
        font-size: 16px;
    }
</style>

<div class="tabs-nav">
    <button class="tab-btn active" onclick="switchTab('currencies')"><i class="fas fa-coins"></i> ສະກຸນເງິນ</button>
    <button class="tab-btn" onclick="switchTab('rates')"><i class="fas fa-exchange-alt"></i> ອັດຕາແລກປ່ຽນ</button>
</div>

<!-- CURRENCIES TAB -->
<div id="tab-currencies" class="tab-pane active">
    <!-- Action Bar -->
    <div class="premium-card d-flex justify-between align-center">
        <div>
            <h3 class="card-title">ສະກຸນເງິນທັງໝົດ</h3>
            <p style="color:var(--text-secondary);font-size:13px;margin-top:5px">ຈັດການສະກຸນເງິນທີ່ໃຊ້ໃນລະບົບ</p>
        </div>
        <button class="btn btn-primary" onclick="openCurrencyModal()"><i class="fas fa-plus"></i>
            ເພີ່ມສະກຸນເງິນ</button>
    </div>

    <!-- Table -->
    <div class="premium-card" style="padding:0; overflow:hidden">
        <div style="overflow-x:auto">
            <table class="premium-table">
                <thead>
                    <tr>
                        <th>ລະຫັດ</th>
                        <th>ຊື່ສະກຸນເງິນ</th>
                        <th>ຊື່ເຕັມ</th>
                        <th>ສັນຍາລັກ</th>
                        <th style="text-align:right">ຈັດການ</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($currencies)): ?>
                        <tr>
                            <td colspan="5">
                                <div class="empty-state"><i class="fas fa-search"></i>
                                    <p>ບໍ່ພົບຂໍ້ມູນ</p>
                                </div>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($currencies as $c): ?>
                            <tr>
                                <td><span class="rate-sub"><?= $c['currencys_id'] ?></span></td>
                                <td><strong><?= htmlspecialchars($c['currencys_name']) ?></strong></td>
                                <td class="text-muted"><?= htmlspecialchars($c['currencys_fullname']) ?></td>
                                <td><span style="font-size:18px"><?= $c['currencys_symbol'] ?></span></td>
                                <td style="text-align:right">
                                    <button class="btn-icon btn-edit"
                                        onclick="editCurrency(<?= htmlspecialchars(json_encode($c)) ?>)"><i
                                            class="fas fa-pen"></i></button>
                                    <button class="btn-icon btn-delete" onclick="deleteCurrency(<?= $c['id'] ?>)"><i
                                            class="fas fa-trash"></i></button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- RATES TAB -->
<div id="tab-rates" class="tab-pane">
    <div class="grid-container mb-20">
        <?php foreach ($latest_rates as $rate): ?>
            <div class="rate-card">
                <div class="rate-symbol"><?= $rate['currencys_symbol'] ?></div>
                <div class="rate-badge">
                    <i class="fas fa-clock"></i>
                    <?= date('d/m H:i', strtotime($rate['rate_datetime'])) ?>
                </div>

                <span class="rate-sub"><?= $rate['currencys_name'] ?></span>

                <div style="margin-top: 15px; opacity: 0.8; font-size: 13px">
                    1 <?= $rate['currencys_symbol'] ?> =
                </div>
                <div class="rate-value">
                    <?= number_format($rate['rate_amount'], 0) ?> <small style="font-size:18px;opacity:0.7">₭</small>
                </div>

                <div class="rate-bottom">
                    <div class="rate-bottom-item">
                        <small>10 <?= $rate['currencys_symbol'] ?></small>
                        <strong><?= number_format($rate['rate_amount'] * 10, 0) ?> ₭</strong>
                    </div>
                    <div class="rate-bottom-item">
                        <small>100 <?= $rate['currencys_symbol'] ?></small>
                        <strong><?= number_format($rate['rate_amount'] * 100, 0) ?> ₭</strong>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>

        <?php if (empty($latest_rates)): ?>
            <div class="premium-card" style="grid-column: 1/-1">
                <div class="empty-state">
                    <i class="fas fa-exchange-alt"></i>
                    <p>ຍັງບໍ່ມີອັດຕາແລກປ່ຽນ</p>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <div class="premium-card">
        <div class="card-header">
            <h3 class="card-title"><i class="fas fa-history"></i> ປະຫວັດອັດຕາແລກປ່ຽນ</h3>
            <button class="btn btn-primary" onclick="openRateModal()"><i class="fas fa-plus"></i> ອັບເດດອັດຕາ</button>
        </div>
        <div style="overflow-x:auto">
            <table class="premium-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>ສະກຸນເງິນ</th>
                        <th>ອັດຕາ (LAK)</th>
                        <th>ວັນທີ່</th>
                        <th style="text-align:right">ຈັດການ</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($rates)): ?>
                        <tr>
                            <td colspan="5">
                                <div class="empty-state"><i class="fas fa-list"></i>
                                    <p>ບໍ່ພົບຂໍ້ມູນ</p>
                                </div>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($rates as $r): ?>
                            <tr>
                                <td><span class="rate-sub"><?= $r['rate_id'] ?></span></td>
                                <td>
                                    <i class="fas fa-coins" style="color:var(--accent);margin-right:5px"></i>
                                    <?= htmlspecialchars($r['currencys_name']) ?> (<?= $r['currencys_symbol'] ?>)
                                </td>
                                <td class="text-success" style="font-size:16px;font-weight:bold">
                                    <?= number_format($r['rate_amount'], 0) ?>
                                </td>
                                <td><?= date('d/m/Y H:i', strtotime($r['rate_datetime'])) ?></td>
                                <td style="text-align:right">
                                    <button class="btn-icon btn-edit"
                                        onclick="editRate(<?= htmlspecialchars(json_encode($r)) ?>)"><i
                                            class="fas fa-pen"></i></button>
                                    <button class="btn-icon btn-delete" onclick="deleteRate(<?= $r['id'] ?>)"><i
                                            class="fas fa-trash"></i></button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- CURRENCY MODAL -->
<div class="modal-overlay" id="currencyModal">
    <div class="modal-container">
        <div class="modal-header">
            <h3 class="card-title" id="currModalTitle">ເພີ່ມສະກຸນເງິນ</h3>
            <button class="btn-close" onclick="closeModal('currencyModal')">&times;</button>
        </div>
        <form id="currencyForm">
            <div class="modal-body">
                <input type="hidden" name="action" id="currAction" value="add_currency">
                <input type="hidden" name="currency_id" id="currId">

                <div class="form-group">
                    <label class="form-label">ຊື່ສະກຸນເງິນ</label>
                    <select name="currencys_name" id="currName" class="form-control" onchange="updateCurrencyMeta()"
                        required>
                        <option value="">-- ເລືອກສະກຸນເງິນ --</option>
                        <option value="US Dollar" data-sym="$" data-full="United States Dollar">US Dollar</option>
                        <option value="Thai Baht" data-sym="฿" data-full="Thai Baht">Thai Baht</option>
                        <option value="Lao Kip" data-sym="₭" data-full="Lao Kip">Lao Kip</option>
                        <option value="Chinese Yuan" data-sym="¥" data-full="Chinese Yuan">Chinese Yuan</option>
                        <option value="Euro" data-sym="€" data-full="Euro">Euro</option>
                        <option value="Vietnamese Dong" data-sym="₫" data-full="Vietnamese Dong">Vietnamese Dong
                        </option>
                    </select>
                </div>

                <div class="row">
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">ສັນຍາລັກ</label>
                            <input type="text" name="currencys_symbol" id="currSymbol" class="form-control"
                                placeholder="$" required>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">ຊື່ເຕັມ</label>
                            <input type="text" name="currencys_fullname" id="currFull" class="form-control"
                                placeholder="Optional">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn" onclick="closeModal('currencyModal')">ຍົກເລີກ</button>
                <button type="submit" class="btn btn-primary">ບັນທຶກ</button>
            </div>
        </form>
    </div>
</div>

<!-- RATE MODAL -->
<div class="modal-overlay" id="rateModal">
    <div class="modal-container">
        <div class="modal-header">
            <h3 class="card-title" id="rateModalTitle">ອັບເດດອັດຕາແລກປ່ຽນ</h3>
            <button class="btn-close" onclick="closeModal('rateModal')">&times;</button>
        </div>
        <form id="rateForm">
            <div class="modal-body">
                <input type="hidden" name="action" id="rateAction" value="add_rate">
                <input type="hidden" name="rate_id_edit" id="rateId">

                <div class="form-group">
                    <label class="form-label">ສະກຸນເງິນ</label>
                    <select name="currencys_id" id="rateCurrId" class="form-control" required>
                        <option value="">-- ເລືອກ --</option>
                        <?php foreach ($currencies as $c): ?>
                            <option value="<?= $c['currencys_id'] ?>"><?= $c['currencys_symbol'] ?> -
                                <?= $c['currencys_name'] ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label class="form-label">ອັດຕາແລກປ່ຽນ (LAK)</label>
                    <div style="position:relative">
                        <input type="number" step="0.01" name="rate_amount" id="rateAmount" class="form-control"
                            style="padding-right:50px" placeholder="0.00" required>
                        <span style="position:absolute;right:15px;top:12px;color:var(--text-secondary)">₭</span>
                    </div>
                    <small style="color:var(--text-secondary);font-size:12px;margin-top:5px;display:block">1 ຫົວໜ່ວຍ =
                        ເທົ່າໃດກີບ</small>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn" onclick="closeModal('rateModal')">ຍົກເລີກ</button>
                <button type="submit" class="btn btn-primary">ບັນທຶກ</button>
            </div>
        </form>
    </div>
</div>

<script>
    function switchTab(id) {
        document.querySelectorAll('.tab-pane').forEach(el => el.classList.remove('active'));
        document.querySelectorAll('.tab-btn').forEach(el => el.classList.remove('active'));
        document.getElementById('tab-' + id).classList.add('active');
        event.target.classList.add('active');
        localStorage.setItem('active_currency_tab', id);
    }

    document.addEventListener('DOMContentLoaded', () => {
        const active = localStorage.getItem('active_currency_tab') || 'currencies';
        const btn = document.querySelector(`.tab-btn[onclick="switchTab('${active}')"]`);
        if (btn) btn.click();
    });

    function openCurrencyModal() {
        document.getElementById('currencyForm').reset();
        document.getElementById('currAction').value = 'add_currency';
        document.getElementById('currModalTitle').innerText = 'ເພີ່ມສະກຸນເງິນ';
        document.getElementById('currencyModal').classList.add('show');
    }

    function editCurrency(data) {
        document.getElementById('currencyForm').reset();
        document.getElementById('currAction').value = 'edit_currency';
        document.getElementById('currModalTitle').innerText = 'ແກ້ໄຂສະກຸນເງິນ';
        document.getElementById('currId').value = data.id;
        document.getElementById('currName').value = data.currencys_name;
        document.getElementById('currSymbol').value = data.currencys_symbol;
        document.getElementById('currFull').value = data.currencys_fullname;
        document.getElementById('currencyModal').classList.add('show');
    }

    function openRateModal() {
        document.getElementById('rateForm').reset();
        document.getElementById('rateAction').value = 'add_rate';
        document.getElementById('rateModalTitle').innerText = 'ເພີ່ມອັດຕາແລກປ່ຽນ';
        document.getElementById('rateModal').classList.add('show');
    }

    function editRate(data) {
        document.getElementById('rateForm').reset();
        document.getElementById('rateAction').value = 'edit_rate';
        document.getElementById('rateModalTitle').innerText = 'ແກ້ໄຂອັດຕາແລກປ່ຽນ';
        document.getElementById('rateId').value = data.id;
        document.getElementById('rateCurrId').value = data.currencys_id;
        document.getElementById('rateAmount').value = data.rate_amount;
        document.getElementById('rateModal').classList.add('show');
    }

    function closeModal(id) {
        document.getElementById(id).classList.remove('show');
    }

    function updateCurrencyMeta() {
        const sel = document.getElementById('currName');
        const opt = sel.options[sel.selectedIndex];
        if (opt.value) {
            document.getElementById('currSymbol').value = opt.getAttribute('data-sym');
            document.getElementById('currFull').value = opt.getAttribute('data-full');
        }
    }

    // AJAX Form Handling
    ['currencyForm', 'rateForm'].forEach(id => {
        document.getElementById(id).addEventListener('submit', async function (e) {
            e.preventDefault();
            const fd = new FormData(this);
            closeModal(this.closest('.modal-overlay').id);
            Swal.fire({ title: 'ກຳລັງບັນທຶກ...', didOpen: () => Swal.showLoading() });

            try {
                const res = await fetch('currencies.php', { method: 'POST', body: fd });
                const data = await res.json();
                if (data.success) {
                    await Swal.fire('ສຳເລັດ', data.message, 'success');
                    location.reload();
                } else {
                    Swal.fire('ຜິດພາດ', data.message, 'error');
                }
            } catch (err) {
                Swal.fire('Error', 'Connection Failed', 'error');
            }
        });
    });

    async function deleteCurrency(id) {
        const result = await Swal.fire({
            title: 'ຢືນຢັນການລຶບ?',
            text: "ຂໍ້ມູນທີ່ກ່ຽວຂ້ອງອາດຈະຫາຍໄປ",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            confirmButtonText: 'ລຶບ',
            cancelButtonText: 'ຍົກເລີກ'
        });

        if (result.isConfirmed) {
            const fd = new FormData();
            fd.append('action', 'delete_currency');
            fd.append('currency_id', id);

            try {
                const res = await fetch('currencies.php', { method: 'POST', body: fd });
                const data = await res.json();
                if (data.success) {
                    await Swal.fire('Deleted!', data.message, 'success');
                    location.reload();
                } else {
                    Swal.fire('Error', data.message, 'error');
                }
            } catch (err) {
                Swal.fire('Error', 'Connection Failed', 'error');
            }
        }
    }

    async function deleteRate(id) {
        const result = await Swal.fire({
            title: 'ຢືນຢັນການລຶບ?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            confirmButtonText: 'ລຶບ',
            cancelButtonText: 'ຍົກເລີກ'
        });

        if (result.isConfirmed) {
            const fd = new FormData();
            fd.append('action', 'delete_rate');
            fd.append('rate_id', id);

            try {
                const res = await fetch('currencies.php', { method: 'POST', body: fd });
                const data = await res.json();
                if (data.success) {
                    await Swal.fire('Deleted!', data.message, 'success');
                    location.reload();
                } else {
                    Swal.fire('Error', data.message, 'error');
                }
            } catch (err) {
                Swal.fire('Error', 'Connection Failed', 'error');
            }
        }
    }
</script>

<?php require_once 'includes/footer.php'; ?>