<?php
$page_title = 'ສີສິນຄ້າ';

// Handle AJAX requests BEFORE any HTML output
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    @ob_end_clean();
    @ini_set('display_errors', 0);
    @error_reporting(0);
    if (session_status() === PHP_SESSION_NONE)
        @session_start();

    // Try multiple paths for database connection
    $db_paths = [__DIR__ . '/../includes/con_database.php', dirname(__FILE__) . '/../includes/con_database.php', $_SERVER['DOCUMENT_ROOT'] . '/epcommerce/includes/con_database.php'];
    foreach ($db_paths as $path) {
        if (file_exists($path)) {
            require_once $path;
            break;
        }
    }
    // Include secondary ID helper
    require_once __DIR__ . '/../includes/secondary_ids.php';

    header('Content-Type: application/json');

    $shop_id = $_SESSION['shop_id'] ?? null;
    $user_id = $_SESSION['user_id'] ?? null;
    $user_secondary_id = getUserSecondaryId($conn, $user_id);
    $action = $_POST['action'] ?? '';

    if (!$shop_id) {
        echo json_encode(['success' => false, 'message' => 'ກະລຸນາເລືອກຮ້ານກ່ອນ']);
        exit;
    }

    try {
        if ($action === 'add') {
            $stmt = $conn->prepare("INSERT INTO colors (shop_id, color_name, color_code, created_by) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("isss", $shop_id, $_POST['color_name'], $_POST['color_code'], $user_secondary_id);
            echo json_encode(['success' => $stmt->execute(), 'message' => $stmt->error ?: 'ເພີ່ມສຳເລັດ']);
            exit;
        }
        if ($action === 'edit') {
            $stmt = $conn->prepare("UPDATE colors SET color_name = ?, color_code = ?, updated_by = ? WHERE id = ? AND shop_id = ?");
            $stmt->bind_param("sssii", $_POST['color_name'], $_POST['color_code'], $user_secondary_id, $_POST['id'], $shop_id);
            echo json_encode(['success' => $stmt->execute(), 'message' => 'ແກ້ໄຂສຳເລັດ']);
            exit;
        }
        if ($action === 'delete') {
            $stmt = $conn->prepare("UPDATE colors SET deleted_at = NOW(), deleted_by = ? WHERE id = ? AND shop_id = ?");
            $stmt->bind_param("sii", $user_secondary_id, $_POST['id'], $shop_id);
            echo json_encode(['success' => $stmt->execute(), 'message' => 'ລຶບສຳເລັດ']);
            exit;
        }
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
        exit;
    }
}

require_once 'includes/header.php';

$shop_id = $_SESSION['shop_id'] ?? null;
$user_id = $_SESSION['user_id'] ?? null;

$colors = [];
if ($shop_id) {
    $stmt = $conn->prepare("SELECT * FROM colors WHERE shop_id = ? AND deleted_at IS NULL ORDER BY created_at ASC");
    $stmt->bind_param("i", $shop_id);
    $stmt->execute();
    $colors = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}
?>

<style>
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px
    }

    .page-header h1 {
        font-size: 24px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 12px;
        margin: 0
    }

    .page-header h1 i {
        color: var(--accent)
    }

    .stats-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 16px;
        margin-bottom: 24px
    }

    .mini-stat {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 12px;
        padding: 20px;
        display: flex;
        align-items: center;
        gap: 16px
    }

    .mini-stat .icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        color: #fff;
        background: linear-gradient(135deg, #9b59b6, #8e44ad)
    }

    .mini-stat .info h3 {
        font-size: 24px;
        margin: 0
    }

    .mini-stat .info p {
        color: var(--text-secondary);
        margin: 0;
        font-size: 13px
    }

    .data-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        overflow: hidden
    }

    .data-card-header {
        padding: 20px 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 16px
    }

    .data-card-header h3 {
        font-size: 18px;
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px
    }

    .search-box {
        display: flex;
        align-items: center;
        gap: 8px;
        background: var(--input-bg);
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 8px 12px;
        width: 250px;
        max-width: 100%
    }

    .search-box input {
        border: none;
        background: transparent;
        outline: none;
        color: var(--text-primary);
        width: 100%;
        font-size: 14px
    }

    .pro-table {
        width: 100%;
        border-collapse: collapse
    }

    .pro-table th {
        background: rgba(var(--accent-rgb), 0.1);
        padding: 14px 16px;
        text-align: left;
        font-weight: 600;
        font-size: 13px;
        text-transform: uppercase;
        color: var(--text-secondary);
        white-space: nowrap
    }

    .pro-table td {
        padding: 16px;
        border-bottom: 1px solid var(--border-color);
        vertical-align: middle
    }

    .pro-table tbody tr:hover {
        background: rgba(var(--accent-rgb), 0.05)
    }

    .pro-table tbody tr:last-child td {
        border-bottom: none
    }

    .color-preview {
        width: 32px;
        height: 32px;
        border-radius: 8px;
        border: 2px solid var(--border-color);
        display: inline-block
    }

    .action-btns {
        display: flex;
        gap: 8px
    }

    .btn-icon {
        width: 36px;
        height: 36px;
        border-radius: 8px;
        border: none;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all .2s;
        font-size: 14px
    }

    .btn-icon.edit {
        background: rgba(255, 193, 7, .15);
        color: #ffc107
    }

    .btn-icon.edit:hover {
        background: #ffc107;
        color: #000
    }

    .btn-icon.delete {
        background: rgba(220, 53, 69, .15);
        color: #dc3545
    }

    .btn-icon.delete:hover {
        background: #dc3545;
        color: #fff
    }

    .btn-pro {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 12px 24px;
        border-radius: 10px;
        border: none;
        font-weight: 600;
        cursor: pointer;
        transition: all .3s;
        font-size: 14px
    }

    .btn-pro.primary {
        background: linear-gradient(135deg, var(--accent), var(--accent-soft));
        color: #fff;
        box-shadow: 0 4px 15px rgba(74, 144, 217, .3)
    }

    .pro-modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, .6);
        backdrop-filter: blur(4px);
        z-index: 9998;
        align-items: center;
        justify-content: center;
        padding: 20px
    }

    .pro-modal.show {
        display: flex
    }

    .pro-modal-content {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 20px;
        width: 100%;
        max-width: 480px;
        max-height: 90vh;
        overflow-y: auto;
        animation: modalSlide .3s ease
    }

    @keyframes modalSlide {
        from {
            opacity: 0;
            transform: translateY(-20px) scale(.95)
        }

        to {
            opacity: 1;
            transform: translateY(0) scale(1)
        }
    }

    .pro-modal-header {
        padding: 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center
    }

    .pro-modal-header h3 {
        margin: 0;
        font-size: 20px;
        display: flex;
        align-items: center;
        gap: 10px
    }

    .pro-modal-header h3 i {
        color: var(--accent)
    }

    .pro-modal-close {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        border: none;
        background: rgba(255, 255, 255, .1);
        color: var(--text-secondary);
        cursor: pointer;
        font-size: 18px
    }

    .pro-modal-body {
        padding: 24px
    }

    .pro-modal-footer {
        padding: 20px 24px;
        border-top: 1px solid var(--border-color);
        display: flex;
        gap: 12px;
        justify-content: flex-end
    }

    .form-pro-group {
        margin-bottom: 20px
    }

    .form-pro-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 500
    }

    .form-pro-group label span {
        color: #dc3545
    }

    .form-pro-input {
        width: 100%;
        padding: 14px 16px;
        border: 2px solid var(--border-color);
        border-radius: 10px;
        background: var(--input-bg);
        color: var(--text-primary);
        font-size: 15px;
        transition: all .2s
    }

    .form-pro-input:focus {
        outline: none;
        border-color: var(--accent)
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: var(--text-secondary)
    }

    .empty-state i {
        font-size: 64px;
        opacity: .3;
        margin-bottom: 20px
    }

    @media(max-width:768px) {
        .page-header {
            flex-direction: column;
            align-items: flex-start
        }

        .search-box {
            width: 100%
        }

        .pro-table {
            display: block;
            overflow-x: auto
        }
    }
</style>

<?php if (!$shop_id): ?>
    <div class="empty-state"><i class="fas fa-store-slash"></i>
        <h4>ກະລຸນາເລືອກຮ້ານກ່ອນ</h4>
    </div>
<?php else: ?>

    <div class="page-header">
        <h1><i class="fas fa-palette"></i> ສີສິນຄ້າ</h1>
        <button class="btn-pro primary" onclick="openModal('add')"><i class="fas fa-plus"></i> ເພີ່ມສີໃໝ່</button>
    </div>

    <div class="stats-row">
        <div class="mini-stat">
            <div class="icon"><i class="fas fa-palette"></i></div>
            <div class="info">
                <h3><?= count($colors) ?></h3>
                <p>ສີທັງໝົດ</p>
            </div>
        </div>
    </div>

    <div class="data-card">
        <div class="data-card-header">
            <h3><i class="fas fa-list"></i> ລາຍການສີ</h3>
            <div class="search-box"><i class="fas fa-search"></i><input type="text" id="searchInput" placeholder="ຄົ້ນຫາ..."
                    onkeyup="filterTable()"></div>
        </div>

        <?php if (empty($colors)): ?>
            <div class="empty-state"><i class="fas fa-inbox"></i>
                <h4>ຍັງບໍ່ມີຂໍ້ມູນ</h4>
            </div>
        <?php else: ?>
            <div style="overflow-x:auto">
                <table class="pro-table" id="dataTable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>ສີ</th>
                            <th>ຊື່ສີ</th>
                            <th>ລະຫັດສີ</th>
                            <th>ຈັດການ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($colors as $i => $c): ?>
                            <tr>
                                <td><?= $i + 1 ?></td>
                                <td><span class="color-preview" style="background:<?= htmlspecialchars($c['color_code']) ?>"></span>
                                </td>
                                <td><strong><?= htmlspecialchars($c['color_name']) ?></strong></td>
                                <td><code><?= htmlspecialchars($c['color_code']) ?></code></td>
                                <td>
                                    <div class="action-btns">
                                        <button class="btn-icon edit" onclick='openModal("edit", <?= json_encode($c) ?>)'><i
                                                class="fas fa-pen"></i></button>
                                        <button class="btn-icon delete"
                                            onclick="confirmDelete(<?= $c['id'] ?>, '<?= htmlspecialchars(addslashes($c['color_name'])) ?>')"><i
                                                class="fas fa-trash"></i></button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>

    <div class="pro-modal" id="formModal">
        <div class="pro-modal-content">
            <div class="pro-modal-header">
                <h3><i class="fas fa-palette"></i> <span id="modalTitle">ເພີ່ມສີ</span></h3>
                <button class="pro-modal-close" onclick="closeModal()">&times;</button>
            </div>
            <form id="dataForm">
                <div class="pro-modal-body">
                    <input type="hidden" name="action" id="formAction" value="add">
                    <input type="hidden" name="id" id="formId">
                    <div class="form-pro-group">
                        <label>ຊື່ສີ <span>*</span></label>
                        <input type="text" name="color_name" id="color_name" class="form-pro-input" required
                            placeholder="ເຊັ່ນ: ແດງ, ຂາວ, ດຳ">
                    </div>
                    <div class="form-pro-group">
                        <label>ລະຫັດສີ</label>
                        <input type="color" name="color_code" id="color_code" class="form-pro-input" value="#000000"
                            style="height:50px;cursor:pointer">
                    </div>
                </div>
                <div class="pro-modal-footer">
                    <button type="button" class="btn-pro" style="background:var(--border-color);color:var(--text-primary)"
                        onclick="closeModal()">ຍົກເລີກ</button>
                    <button type="submit" class="btn-pro primary"><i class="fas fa-save"></i> ບັນທຶກ</button>
                </div>
            </form>
        </div>
    </div>

<?php endif; ?>
<?php require_once 'includes/footer.php'; ?>

<?php if ($shop_id): ?>
    <script>
        function openModal(mode, data = null) {
            document.getElementById('dataForm').reset();
            document.getElementById('formId').value = '';
            if (mode === 'add') {
                document.getElementById('modalTitle').textContent = 'ເພີ່ມສີໃໝ່';
                document.getElementById('formAction').value = 'add';
                document.getElementById('color_code').value = '#000000';
            } else {
                document.getElementById('modalTitle').textContent = 'ແກ້ໄຂສີ';
                document.getElementById('formAction').value = 'edit';
                document.getElementById('formId').value = data.id;
                document.getElementById('color_name').value = data.color_name;
                document.getElementById('color_code').value = data.color_code || '#000000';
            }
            document.getElementById('formModal').classList.add('show');
        }

        function closeModal() { document.getElementById('formModal').classList.remove('show'); }
        document.getElementById('formModal').addEventListener('click', function (e) { if (e.target === this) closeModal(); });

        document.getElementById('dataForm').addEventListener('submit', async function (e) {
            e.preventDefault();
            closeModal();

            Swal.fire({ title: 'ກຳລັງບັນທຶກ...', text: 'ກະລຸນາລໍຖ້າ', allowOutsideClick: false, showConfirmButton: false, didOpen: () => Swal.showLoading() });

            try {
                const response = await fetch('colors.php', { method: 'POST', body: new FormData(this) });
                const data = await response.json();

                if (data.success) {
                    await Swal.fire({ icon: 'success', title: 'ສຳເລັດ!', text: data.message, timer: 1500, timerProgressBar: true, showConfirmButton: false });
                    location.reload();
                } else {
                    Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: data.message });
                }
            } catch (error) {
                Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: 'ການເຊື່ອມຕໍ່ມີປັນຫາ' });
            }
        });

        async function confirmDelete(id, name) {
            const result = await Swal.fire({
                title: 'ຢືນຢັນການລຶບ?', html: `ລຶບ <strong>"${name}"</strong> ແທ້ບໍ?`, icon: 'warning',
                showCancelButton: true, confirmButtonColor: '#dc3545', confirmButtonText: '<i class="fas fa-trash"></i> ລຶບ', cancelButtonText: 'ຍົກເລີກ', reverseButtons: true
            });

            if (result.isConfirmed) {
                Swal.fire({ title: 'ກຳລັງລຶບ...', allowOutsideClick: false, showConfirmButton: false, didOpen: () => Swal.showLoading() });
                try {
                    const fd = new FormData(); fd.append('action', 'delete'); fd.append('id', id);
                    const response = await fetch('colors.php', { method: 'POST', body: fd });
                    const data = await response.json();
                    if (data.success) {
                        await Swal.fire({ icon: 'success', title: 'ລຶບສຳເລັດ!', timer: 1500, showConfirmButton: false });
                        location.reload();
                    } else {
                        Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: data.message });
                    }
                } catch (error) {
                    Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: 'ການເຊື່ອມຕໍ່ມີປັນຫາ' });
                }
            }
        }

        function filterTable() {
            const f = document.getElementById('searchInput').value.toLowerCase();
            document.querySelectorAll('#dataTable tbody tr').forEach(r => { r.style.display = r.textContent.toLowerCase().includes(f) ? '' : 'none'; });
        }
    </script>
<?php endif; ?>