<?php
/**
 * Cancelled Orders Page
 * Shows orders with: order_status = 'returned', 'cancelled' OR payment_status = 'refunded'
 */
$page_title = 'ອໍເດີຍົກເລີກ/ຕີກັບ';
require_once 'includes/header.php';

$shop_id = $_SESSION['shop_id'] ?? null;

// Get filter values
$search_query = isset($_GET['search']) ? trim($_GET['search']) : '';
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : date('Y-m-01');
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : date('Y-m-d');
$filter_type = isset($_GET['filter_type']) ? $_GET['filter_type'] : 'all';
?>

<style>
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px
    }

    .page-header h1 {
        font-size: 24px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 12px;
        margin: 0
    }

    .page-header h1 i {
        color: #dc3545
    }

    /* Filter Card */
    .filter-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        padding: 20px;
        margin-bottom: 20px
    }

    .filter-row {
        display: flex;
        gap: 16px;
        flex-wrap: wrap;
        align-items: center
    }

    .search-box {
        display: flex;
        align-items: center;
        gap: 8px;
        background: var(--input-bg);
        border: 1px solid var(--border-color);
        border-radius: 10px;
        padding: 12px 16px;
        flex: 1;
        min-width: 250px
    }

    .search-box input {
        border: none;
        background: transparent;
        outline: none;
        color: var(--text-primary);
        width: 100%;
        font-size: 16px
    }

    .date-input,
    .filter-select {
        padding: 12px 16px;
        border: 1px solid var(--border-color);
        border-radius: 10px;
        background: var(--input-bg);
        color: var(--text-primary);
        font-size: 16px
    }

    .btn-pro {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 14px 24px;
        border-radius: 10px;
        border: none;
        font-weight: 600;
        cursor: pointer;
        transition: all .3s;
        font-size: 16px
    }

    .btn-pro.primary {
        background: linear-gradient(135deg, var(--accent), var(--accent-soft));
        color: #fff;
        box-shadow: 0 4px 15px rgba(74, 144, 217, .3)
    }

    .btn-pro.primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(74, 144, 217, .4)
    }

    /* Summary Cards */
    .summary-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 16px;
        margin-bottom: 20px;
    }

    .summary-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 12px;
        padding: 16px;
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .summary-card .icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
    }

    .summary-card .icon.cancelled {
        background: rgba(220, 53, 69, 0.15);
        color: #dc3545;
    }

    .summary-card .icon.returned {
        background: rgba(255, 193, 7, 0.15);
        color: #ffc107;
    }

    .summary-card .icon.refunded {
        background: rgba(108, 117, 125, 0.15);
        color: #6c757d;
    }

    .summary-card .info h3 {
        font-size: 24px;
        font-weight: 700;
        margin: 0;
    }

    .summary-card .info p {
        font-size: 13px;
        color: var(--text-secondary);
        margin: 0;
    }

    /* Table */
    .table-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        overflow: hidden
    }

    .data-table {
        width: 100%;
        border-collapse: collapse
    }

    .data-table th {
        background: var(--bg-secondary);
        padding: 14px 12px;
        text-align: left;
        font-weight: 600;
        font-size: 14px;
        color: var(--text-secondary);
        border-bottom: 1px solid var(--border-color)
    }

    .data-table td {
        padding: 14px 12px;
        border-bottom: 1px solid var(--border-color);
        font-size: 14px
    }

    .data-table tbody tr:hover {
        background: var(--bg-secondary)
    }

    .badge {
        display: inline-flex;
        align-items: center;
        gap: 4px;
        padding: 4px 10px;
        border-radius: 6px;
        font-size: 12px;
        font-weight: 600
    }

    .badge.status-cancelled {
        background: rgba(220, 53, 69, 0.15);
        color: #dc3545
    }

    .badge.status-returned {
        background: rgba(255, 193, 7, 0.15);
        color: #ffc107
    }

    .badge.status-refunded {
        background: rgba(108, 117, 125, 0.15);
        color: #6c757d
    }

    .badge.type-pos {
        background: rgba(40, 167, 69, 0.15);
        color: #28a745
    }

    .badge.type-online {
        background: rgba(74, 144, 217, 0.15);
        color: #4a90e2
    }

    .amount-cell {
        font-weight: 600;
        color: #dc3545;
        text-decoration: line-through;
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: var(--text-secondary)
    }

    .empty-state i {
        font-size: 48px;
        opacity: 0.4;
        margin-bottom: 16px;
        display: block;
    }

    .btn-icon {
        width: 32px;
        height: 32px;
        border-radius: 8px;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        transition: all .2s
    }

    .btn-icon.view {
        background: rgba(74, 144, 217, .15);
        color: #4a90e2
    }

    .btn-icon.restore {
        background: rgba(40, 167, 69, .15);
        color: #28a745
    }

    .btn-icon:hover {
        transform: scale(1.1)
    }

    .action-btns {
        display: flex;
        gap: 6px
    }
</style>

<div class="page-header">
    <h1><i class="fas fa-ban"></i> ອໍເດີຍົກເລີກ/ຕີກັບ</h1>
    <a href="sales_history.php" class="btn-pro primary">
        <i class="fas fa-arrow-left"></i> ກັບໄປປະຫວັດການຂາຍ
    </a>
</div>

<!-- Summary Cards -->
<div class="summary-cards" id="summaryCards">
    <div class="summary-card">
        <div class="icon cancelled"><i class="fas fa-times-circle"></i></div>
        <div class="info">
            <h3 id="cancelledCount">0</h3>
            <p>ຍົກເລີກ</p>
        </div>
    </div>
    <div class="summary-card">
        <div class="icon returned"><i class="fas fa-undo"></i></div>
        <div class="info">
            <h3 id="returnedCount">0</h3>
            <p>ສິນຄ້າຕີກັບ</p>
        </div>
    </div>
    <div class="summary-card">
        <div class="icon refunded"><i class="fas fa-money-bill-wave"></i></div>
        <div class="info">
            <h3 id="refundedCount">0</h3>
            <p>ຄືນເງິນ</p>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="filter-card">
    <div class="filter-row">
        <div class="search-box">
            <i class="fas fa-search"></i>
            <input type="text" id="searchInput" placeholder="ຄົ້ນຫາ Order ID, ລູກຄ້າ..."
                value="<?= htmlspecialchars($search_query) ?>">
        </div>
        <select id="filterType" class="filter-select">
            <option value="all" <?= $filter_type == 'all' ? 'selected' : '' ?>>ທັງໝົດ</option>
            <option value="cancelled" <?= $filter_type == 'cancelled' ? 'selected' : '' ?>>ຍົກເລີກ</option>
            <option value="returned" <?= $filter_type == 'returned' ? 'selected' : '' ?>>ສິນຄ້າຕີກັບ</option>
            <option value="refunded" <?= $filter_type == 'refunded' ? 'selected' : '' ?>>ຄືນເງິນ</option>
        </select>
        <input type="date" id="dateFrom" class="date-input" value="<?= $date_from ?>">
        <span>ຫາ</span>
        <input type="date" id="dateTo" class="date-input" value="<?= $date_to ?>">
        <button class="btn-pro primary" onclick="loadData()">
            <i class="fas fa-search"></i> ຄົ້ນຫາ
        </button>
    </div>
</div>

<!-- Data Table -->
<div class="table-card">
    <table class="data-table">
        <thead>
            <tr>
                <th>#</th>
                <th>ປະເພດ</th>
                <th>Order ID</th>
                <th>ວັນທີ</th>
                <th>ລູກຄ້າ</th>
                <th>ເບີໂທ</th>
                <th>ສະຖານະ</th>
                <th>ຍອດເງິນ</th>
                <th>ຈັດການ</th>
            </tr>
        </thead>
        <tbody id="tableBody">
            <tr>
                <td colspan="9" class="empty-state">
                    <i class="fas fa-spinner fa-spin"></i>
                    <p>ກຳລັງໂຫຼດຂໍ້ມູນ...</p>
                </td>
            </tr>
        </tbody>
    </table>
</div>

<?php require_once 'includes/footer.php'; ?>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        loadData();

        // Enter key search
        document.getElementById('searchInput').addEventListener('keypress', function (e) {
            if (e.key === 'Enter') loadData();
        });
    });

    function loadData() {
        const search = document.getElementById('searchInput').value;
        const filterType = document.getElementById('filterType').value;
        const dateFrom = document.getElementById('dateFrom').value;
        const dateTo = document.getElementById('dateTo').value;

        document.getElementById('tableBody').innerHTML = `
        <tr><td colspan="9" class="empty-state">
            <i class="fas fa-spinner fa-spin"></i>
            <p>ກຳລັງໂຫຼດຂໍ້ມູນ...</p>
        </td></tr>
    `;

        fetch(`cancelled_orders_table.php?search=${encodeURIComponent(search)}&filter_type=${filterType}&date_from=${dateFrom}&date_to=${dateTo}`)
            .then(res => res.text())
            .then(html => {
                document.getElementById('tableBody').innerHTML = html;
                updateSummary();
            })
            .catch(err => {
                document.getElementById('tableBody').innerHTML = `
                <tr><td colspan="9" class="empty-state">
                    <i class="fas fa-exclamation-circle"></i>
                    <p>ເກີດຂໍ້ຜິດພາດ</p>
                </td></tr>
            `;
            });
    }

    function updateSummary() {
        const rows = document.querySelectorAll('#tableBody tr[data-status]');
        let cancelled = 0, returned = 0, refunded = 0;

        rows.forEach(row => {
            const status = row.dataset.status;
            if (status === 'cancelled') cancelled++;
            else if (status === 'returned') returned++;
            else if (status === 'refunded') refunded++;
        });

        document.getElementById('cancelledCount').textContent = cancelled;
        document.getElementById('returnedCount').textContent = returned;
        document.getElementById('refundedCount').textContent = refunded;
    }

    function viewOrder(orderId) {
        window.location.href = 'edit_order.php?id=' + orderId;
    }

    function restoreOrder(orderId) {
        Swal.fire({
            title: 'ກູ້ຄືນອໍເດີ?',
            text: 'ຕ້ອງການກູ້ຄືນອໍເດີນີ້ແມ່ນບໍ່?',
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'ກູ້ຄືນ',
            cancelButtonText: 'ຍົກເລີກ'
        }).then((result) => {
            if (result.isConfirmed) {
                fetch('api/restore_order.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ order_id: orderId })
                })
                    .then(res => res.json())
                    .then(data => {
                        if (data.status === 'success') {
                            Swal.fire({
                                title: 'ສຳເລັດ!',
                                text: 'ກູ້ຄືນອໍເດີແລ້ວ',
                                icon: 'success',
                                timer: 1500,
                                showConfirmButton: false
                            }).then(() => loadData());
                        } else {
                            Swal.fire('ຜິດພາດ', data.message, 'error');
                        }
                    });
            }
        });
    }
</script>