<?php
// API endpoint for deleting order (soft delete)
header('Content-Type: application/json');

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if logged in and is admin
if (!isset($_SESSION['user_id']) || $_SESSION['role_code'] !== 'admin') {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

require_once dirname(__DIR__, 2) . '/includes/con_database.php';

$shop_id = $_SESSION['shop_id'] ?? null;
if (!$shop_id) {
    echo json_encode(['status' => 'error', 'message' => 'ບໍ່ພົບຂໍ້ມູນຮ້ານຄ້າ']);
    exit;
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);
$order_id = isset($input['order_id']) ? trim($input['order_id']) : '';
$password = isset($input['password']) ? $input['password'] : '';

if (empty($order_id)) {
    echo json_encode(['status' => 'error', 'message' => 'ບໍ່ພົບ Order ID']);
    exit;
}

if (empty($password)) {
    echo json_encode(['status' => 'error', 'message' => 'ກະລຸນາປ້ອນລະຫັດຜ່ານ']);
    exit;
}

// Verify password (check against current user's password)
$user_id = $_SESSION['user_id'];
$sql = "SELECT password FROM users WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

if (!$user || !password_verify($password, $user['password'])) {
    echo json_encode(['status' => 'error', 'message' => 'ລະຫັດຜ່ານບໍ່ຖືກຕ້ອງ']);
    exit;
}

// Check if order exists and belongs to this shop
$sql = "SELECT id FROM orders WHERE OR_id = ? AND shop_id = ? AND deleted_at IS NULL";
$stmt = $conn->prepare($sql);
$stmt->bind_param("si", $order_id, $shop_id);
$stmt->execute();
$result = $stmt->get_result();
$order = $result->fetch_assoc();
$stmt->close();

if (!$order) {
    echo json_encode(['status' => 'error', 'message' => 'ບໍ່ພົບໃບບິນນີ້']);
    exit;
}

// Soft delete the order
$deleted_by = $_SESSION['US_id'] ?? $_SESSION['user_id'];
$sql = "UPDATE orders SET deleted_at = NOW(), deleted_by = ? WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("si", $deleted_by, $order['id']);
$success = $stmt->execute();
$stmt->close();

// Also soft delete any associated tip
if ($success) {
    $tip_sql = "UPDATE tips SET deleted_at = NOW() WHERE order_id = ? AND shop_id = ?";
    $tip_stmt = $conn->prepare($tip_sql);
    $tip_stmt->bind_param("si", $order_id, $shop_id);
    $tip_stmt->execute();
    $tip_stmt->close();
}

if ($success) {
    echo json_encode(['status' => 'success', 'message' => 'ລຶບໃບບິນສຳເລັດ']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'ເກີດຂໍ້ຜິດພາດ']);
}
?>